/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;

public enum OctalDirection implements StringRepresentable
{
    NORTH(0.0f, 0.0f, -1.0f, 1),
    SOUTH(0.0f, 0.0f, 1.0f, 0),
    WEST(-1.0f, 0.0f, 0.0f, 3),
    EAST(1.0f, 0.0f, 0.0f, 2),
    NORTHWEST(-0.7071f, 0.0f, -0.7071f, 7),
    NORTHEAST(0.7071f, 0.0f, -0.7071f, 6),
    SOUTHWEST(-0.7071f, 0.0f, 0.7071f, 5),
    SOUTHEAST(0.7071f, 0.0f, 0.7071f, 4),
    UP(0.0f, 1.0f, 0.0f, 9),
    DOWN(0.0f, -1.0f, 0.0f, 8),
    CENTER(0.0f, 0.0f, 0.0f, 10);

    public static final OctalDirection[] CARDINALS;
    public static final OctalDirection[] CARDINALS_UP;
    public static final OctalDirection[] STRAIGHTS;
    public static final OctalDirection[] DIAGONALS;
    public static final OctalDirection[] OCTALS;
    public static final OctalDirection[] OCTALS_UP;
    public static final OctalDirection[] NORTH_SINGLE;
    public static final OctalDirection[] SOUTH_SINGLE;
    public static final OctalDirection[] WEST_SINGLE;
    public static final OctalDirection[] EAST_SINGLE;
    public static final OctalDirection[] NORTHWEST_SINGLE;
    public static final OctalDirection[] NORTHEAST_SINGLE;
    public static final OctalDirection[] SOUTHWEST_SINGLE;
    public static final OctalDirection[] SOUTHEAST_SINGLE;
    public static final OctalDirection[] CENTER_SINGLE;
    public static final OctalDirection[] NORTH_AND_WEST;
    public static final OctalDirection[] NORTH_AND_EAST;
    public static final OctalDirection[] NORTH_AND_SOUTH;
    public static final OctalDirection[] SOUTH_AND_WEST;
    public static final OctalDirection[] SOUTH_AND_EAST;
    public static final OctalDirection[] WEST_AND_EAST;
    public static final OctalDirection[] NORTH_DIAGONALS;
    public static final OctalDirection[] SOUTH_DIAGONALS;
    public static final OctalDirection[] WEST_DIAGONALS;
    public static final OctalDirection[] EAST_DIAGONALS;
    public final float xStep;
    public final float yStep;
    public final float zStep;
    public final float xStepHalf;
    public final float yStepHalf;
    public final float zStepHalf;
    public final int xStepInt;
    public final int yStepInt;
    public final int zStepInt;
    private final int oppositeIndex;
    private final String name;

    private OctalDirection(float xStep, float yStep, float zStep, int oppositeIndex) {
        this.xStep = xStep;
        this.yStep = yStep;
        this.zStep = zStep;
        this.xStepHalf = xStep / 2.0f;
        this.yStepHalf = yStep / 2.0f;
        this.zStepHalf = zStep / 2.0f;
        this.xStepInt = Math.round(xStep);
        this.yStepInt = Math.round(yStep);
        this.zStepInt = Math.round(zStep);
        this.oppositeIndex = oppositeIndex;
        this.name = this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.name;
    }

    public String m_7912_() {
        return this.name;
    }

    public static OctalDirection fromDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public Direction toDirection() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORTH, NORTHWEST, NORTHEAST -> Direction.NORTH;
            case WEST -> Direction.WEST;
            case EAST -> Direction.EAST;
            case SOUTH, SOUTHWEST, SOUTHEAST -> Direction.SOUTH;
            case UP -> Direction.UP;
            case DOWN, CENTER -> Direction.DOWN;
        };
    }

    public boolean equalsDirection(Direction dir) {
        return dir.toString().equals(this.name);
    }

    public BlockPos move(BlockPos pos) {
        return pos.m_142082_(this.xStepInt, this.yStepInt, this.zStepInt);
    }

    public BlockPos.MutableBlockPos move(BlockPos.MutableBlockPos pos) {
        return pos.m_122184_(this.xStepInt, this.yStepInt, this.zStepInt);
    }

    public BlockPos.MutableBlockPos moveFrom(BlockPos.MutableBlockPos pos, Vec3i from) {
        return pos.m_122154_(from, this.xStepInt, this.yStepInt, this.zStepInt);
    }

    public OctalDirection straighten() {
        if (this.isDiagonal()) {
            return this.ordinal() <= 5 ? NORTH : SOUTH;
        }
        return this;
    }

    public OctalDirection getOpposite() {
        return OctalDirection.values()[this.oppositeIndex];
    }

    public boolean isCardinal() {
        return this.ordinal() < 4;
    }

    public boolean isDiagonal() {
        return this.ordinal() >= 4 && this.ordinal() <= 7;
    }

    public boolean isVertical() {
        return this.yStepInt != 0;
    }

    public boolean isNearSame(OctalDirection direction) {
        if (this.yStep != 0.0f) {
            return Math.abs(this.yStep + direction.yStep) > 1.5f;
        }
        return Math.abs(this.xStep + direction.xStep) > 1.5f || Math.abs(this.zStep + direction.zStep) > 1.5f;
    }

    public boolean isNearOpposite(OctalDirection direction) {
        if (this.yStep != 0.0f) {
            return Math.abs(this.yStep + direction.yStep) < 0.5f;
        }
        if (direction == CENTER) {
            return false;
        }
        return Math.abs(this.xStep + direction.xStep) < 0.8f && Math.abs(this.zStep + direction.zStep) < 0.8f;
    }

    public boolean isOpposite(OctalDirection direction) {
        return this.xStep == -direction.xStep && this.yStep == -direction.yStep && this.zStep == -direction.zStep;
    }

    static {
        CARDINALS = new OctalDirection[]{NORTH, WEST, SOUTH, EAST};
        CARDINALS_UP = new OctalDirection[]{NORTH, WEST, SOUTH, EAST, UP};
        STRAIGHTS = new OctalDirection[]{NORTH, WEST, SOUTH, EAST, UP, DOWN};
        DIAGONALS = new OctalDirection[]{NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST};
        OCTALS = new OctalDirection[]{NORTH, WEST, SOUTH, EAST, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST};
        OCTALS_UP = new OctalDirection[]{NORTH, WEST, SOUTH, EAST, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST, UP};
        NORTH_SINGLE = new OctalDirection[]{NORTH};
        SOUTH_SINGLE = new OctalDirection[]{SOUTH};
        WEST_SINGLE = new OctalDirection[]{WEST};
        EAST_SINGLE = new OctalDirection[]{EAST};
        NORTHWEST_SINGLE = new OctalDirection[]{NORTHWEST};
        NORTHEAST_SINGLE = new OctalDirection[]{NORTHEAST};
        SOUTHWEST_SINGLE = new OctalDirection[]{SOUTHWEST};
        SOUTHEAST_SINGLE = new OctalDirection[]{SOUTHEAST};
        CENTER_SINGLE = new OctalDirection[]{CENTER};
        NORTH_AND_WEST = new OctalDirection[]{NORTH, WEST};
        NORTH_AND_EAST = new OctalDirection[]{NORTH, EAST};
        NORTH_AND_SOUTH = new OctalDirection[]{NORTH, SOUTH};
        SOUTH_AND_WEST = new OctalDirection[]{SOUTH, WEST};
        SOUTH_AND_EAST = new OctalDirection[]{SOUTH, EAST};
        WEST_AND_EAST = new OctalDirection[]{WEST, EAST};
        NORTH_DIAGONALS = new OctalDirection[]{NORTHWEST, NORTHEAST};
        SOUTH_DIAGONALS = new OctalDirection[]{SOUTHWEST, SOUTHEAST};
        WEST_DIAGONALS = new OctalDirection[]{SOUTHWEST, NORTHWEST};
        EAST_DIAGONALS = new OctalDirection[]{SOUTHEAST, NORTHEAST};
    }
}

