/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;

public class Quat {
    public float r;
    public float i;
    public float j;
    public float k;

    public Quat() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat(float r, float i, float j, float k) {
        this.set(r, i, j, k);
    }

    public Quat(Quat q) {
        this.set(q.r, q.i, q.j, q.k);
    }

    public Quat(float angle, Vector3f axis, boolean inDegrees) {
        if (inDegrees) {
            angle = (float)((double)(angle / 180.0f) * Math.PI);
        }
        float cos = (float)Math.cos(angle / 2.0f);
        float sin = (float)Math.sin(angle / 2.0f);
        this.r = cos;
        this.i = axis.m_122239_() * sin;
        this.j = axis.m_122260_() * sin;
        this.k = axis.m_122269_() * sin;
    }

    float dot(Quat q) {
        return this.r * q.r + this.i * q.i + this.j * q.j + this.k * q.k;
    }

    public void normalize() {
        float magnitude = this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k;
        if (magnitude == 1.0f) {
            return;
        }
        magnitude = magnitude > 0.0f ? Mth.m_14195_((float)magnitude) : 0.0f;
        this.r *= magnitude;
        this.i *= magnitude;
        this.j *= magnitude;
        this.k *= magnitude;
    }

    public void set(float r, float i, float j, float k) {
        this.r = r;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public Quat getProduct(Quat q) {
        float qr = this.r * q.r - this.i * q.i - this.j * q.j - this.k * q.k;
        float qi = this.r * q.i - this.i * q.r + this.j * q.k - this.k * q.j;
        float qj = this.r * q.j - this.i * q.k + this.j * q.r + this.k * q.i;
        float qk = this.r * q.k + this.i * q.j - this.j * q.i + this.k * q.r;
        return new Quat(qr, qi, qj, qk);
    }

    @Deprecated
    public void multiply(Quat q) {
        this.r = -(this.j * q.j + this.i * q.i + this.k * q.k - this.r * q.r);
        this.i = this.i * q.r + this.j * q.k + this.r * q.i - this.k * q.j;
        this.j = this.k * q.i + this.r * q.j + this.j * q.r - this.i * q.k;
        this.k = this.r * q.k + this.k * q.r + this.i * q.j - this.j * q.i;
    }

    public Quat getConjugate() {
        return new Quat(this.r, -this.i, -this.j, -this.k);
    }
}

