/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math;

import frostnox.nightfall.util.math.Easing;

public class Spline {
    private final Point[] points;
    private final double[] inputsDiff;
    private final double[] outputsDiff;

    public Spline(Point ... points) {
        this.points = points;
        this.inputsDiff = new double[points.length == 0 ? 0 : points.length - 1];
        this.outputsDiff = new double[points.length == 0 ? 0 : points.length - 1];
        for (int i = 1; i < points.length; ++i) {
            this.inputsDiff[i - 1] = Math.abs(points[i].input - points[i - 1].input);
            this.outputsDiff[i - 1] = points[i].output - points[i - 1].output;
        }
    }

    public double fit(double input) {
        for (int i = 1; i < this.points.length; ++i) {
            if (!(input >= this.points[i - 1].input) || !(input <= this.points[i].input)) continue;
            return this.points[i - 1].output + this.outputsDiff[i - 1] * this.points[i].easing.apply((input - this.points[i - 1].input) / this.inputsDiff[i - 1]);
        }
        return input;
    }

    public static Point point(double noise, double height) {
        return Spline.point(noise, height, Easing.none);
    }

    public static Point point(double noise, double height, Easing easing) {
        return new Point(noise, height, easing);
    }

    public record Point(double input, double output, Easing easing) {
    }
}

