/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math.noise;

import frostnox.nightfall.util.math.noise.SimplexNoiseCached;

public class FractalSimplexNoiseCached {
    public final SimplexNoiseCached noiseSource;
    private final ThreadLocal<SimplexNoiseCached.Generator[]> generators = new ThreadLocal();
    public final float frequency;
    public final float persistence;
    public final float lacunarity;

    public FractalSimplexNoiseCached(long seed, float frequency, float persistence, float lacunarity) {
        this.noiseSource = new SimplexNoiseCached(seed);
        this.frequency = frequency;
        this.persistence = persistence;
        this.lacunarity = lacunarity;
    }

    public void initGenerators(int octaves) {
        this.generators.set(new SimplexNoiseCached.Generator[octaves]);
        for (int i = 0; i < octaves; ++i) {
            this.generators.get()[i] = this.noiseSource.generator();
        }
    }

    public void deleteGenerators() {
        this.generators.remove();
    }

    public void setXZ(double x, double z) {
        float frequency = this.frequency;
        for (SimplexNoiseCached.Generator generator : this.generators.get()) {
            generator.setXZ(x * (double)frequency, z * (double)frequency);
            frequency *= this.lacunarity;
        }
    }

    public float getForY(double y) {
        float noise = 0.0f;
        float amplitudes = 0.0f;
        float frequency = this.frequency;
        float amplitude = 1.0f;
        for (SimplexNoiseCached.Generator generator : this.generators.get()) {
            noise = (float)((double)noise + generator.getForY(y * (double)frequency) * (double)amplitude);
            amplitudes += amplitude;
            amplitude *= this.persistence;
            frequency *= this.lacunarity;
        }
        return noise / amplitudes;
    }
}

