/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math.noise;

import frostnox.nightfall.util.math.noise.SimplexNoiseFast;

public class FractalSimplexNoiseFast {
    public final SimplexNoiseFast noiseSource;
    private final float frequency;
    private final float persistence;
    private final float lacunarity;
    private final int octaves;

    public FractalSimplexNoiseFast(long seed, float frequency, int octaves, float persistence, float lacunarity) {
        this.noiseSource = new SimplexNoiseFast(seed);
        this.frequency = frequency;
        this.octaves = octaves;
        this.persistence = persistence;
        this.lacunarity = lacunarity;
    }

    public float noise2D(double x, double z) {
        float noise = 0.0f;
        float amplitudes = 0.0f;
        float frequency = this.frequency;
        float amplitude = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            noise += this.noiseSource.noise2D(x * (double)frequency, z * (double)frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= this.persistence;
            frequency *= this.lacunarity;
        }
        return noise / amplitudes;
    }

    public float noise3D(double x, double y, double z) {
        float noise = 0.0f;
        float amplitudes = 0.0f;
        float frequency = this.frequency;
        float amplitude = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            noise += this.noiseSource.noise3D(x * (double)frequency, y * (double)frequency, z * (double)frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= this.persistence;
            frequency *= this.lacunarity;
        }
        return noise / amplitudes;
    }

    public float noise4D(double x, double y, double z, double w) {
        float noise = 0.0f;
        float amplitudes = 0.0f;
        float frequency = this.frequency;
        float amplitude = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            noise += this.noiseSource.noise4D(x * (double)frequency, y * (double)frequency, z * (double)frequency, w * (double)frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= this.persistence;
            frequency *= this.lacunarity;
        }
        return noise / amplitudes;
    }
}

