/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math.noise;

import frostnox.nightfall.util.math.noise.SimplexNoiseSmooth;

public class FractalSimplexNoiseSmooth {
    public final SimplexNoiseSmooth noiseSource;
    private final float frequency;
    private final float persistence;
    private final float lacunarity;
    private final int octaves;

    public FractalSimplexNoiseSmooth(long seed, float frequency, int octaves, float persistence, float lacunarity) {
        this.noiseSource = new SimplexNoiseSmooth(seed);
        this.frequency = frequency;
        this.octaves = octaves;
        this.persistence = persistence;
        this.lacunarity = lacunarity;
    }

    public float noise2D(double x, double z) {
        float noise = 0.0f;
        float amplitudes = 0.0f;
        float frequency = this.frequency;
        float amplitude = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            noise += this.noiseSource.noise2D(x * (double)frequency, z * (double)frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= this.persistence;
            frequency *= this.lacunarity;
        }
        return noise / amplitudes;
    }

    public double noise3D(double x, double y, double z) {
        double noise = 0.0;
        double amplitudes = 0.0;
        double frequency = this.frequency;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            noise += (double)this.noiseSource.noise3D(x * frequency, y * frequency, z * frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= (double)this.persistence;
            frequency *= (double)this.lacunarity;
        }
        return noise / amplitudes;
    }

    public double noise4D(double x, double y, double z, double w) {
        double noise = 0.0;
        double amplitudes = 0.0;
        double frequency = this.frequency;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            noise += (double)this.noiseSource.noise4D(x * frequency, y * frequency, z * frequency, w * frequency) * amplitude;
            amplitudes += amplitude;
            amplitude *= (double)this.persistence;
            frequency *= (double)this.lacunarity;
        }
        return noise / amplitudes;
    }
}

