/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.util.math.noise;

import com.mojang.math.Vector3d;

public class SimplexNoiseCached {
    private static final double ROOT3 = 1.7320508075688772;
    private static final double ROOT3OVER3 = 0.5773502588272095;
    private static final double ROOT3OVER3_1_5 = 0.8660253882408142;
    private static final double _2ROOT3 = 3.464101552963257;
    private static final int PERMUTATION_TABLE_SIZE_EXPONENT = 8;
    private static final int PSIZE = 256;
    private static final int PMASK = 255;
    private static final double Y_ADDITION = 222.56852877260073;
    private final short[] perm = new short[256];
    private static final double[] RGRADIENTS_3D = new double[]{0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0};
    private static final double NORMALIZING_MULTIPLIER_3D = 9.046026385208288;

    public SimplexNoiseCached(long seed) {
        int i;
        short[] source = new short[256];
        for (i = 0; i < 256; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 255; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            source[r] = source[i];
        }
    }

    public Generator generator() {
        return new Generator();
    }

    public DirectionalGenerator directionalGenerator() {
        return new DirectionalGenerator();
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static double fma(double a, double b, double c) {
        return a * b + c;
    }

    static {
        for (int i = 0; i < RGRADIENTS_3D.length; i += 4) {
            double gx = RGRADIENTS_3D[i | 0];
            double gy = RGRADIENTS_3D[i | 1];
            double gz = RGRADIENTS_3D[i | 2];
            double s2 = (gx + gz) * -0.211324865405187 + gy * 0.577350269189626;
            SimplexNoiseCached.RGRADIENTS_3D[i | 0] = (gx + s2) * 9.046026385208288;
            SimplexNoiseCached.RGRADIENTS_3D[i | 1] = (gz + s2) * 9.046026385208288;
            SimplexNoiseCached.RGRADIENTS_3D[i | 2] = (gy - gx - gz) * 5.222725674857771;
        }
    }

    public final class Generator {
        HalfGenerator cA;
        HalfGenerator cB;

        public Generator() {
            this.cA = new HalfGenerator();
            this.cB = new HalfGenerator();
        }

        public void setXZ(double x, double z) {
            this.cA.setXZ(x, z);
            this.cB.setXZ(x, z);
        }

        public double getForY(double y) {
            double yB = y + 222.56852877260073;
            return this.cA.getForY(y) + this.cB.getForY(yB);
        }
    }

    public final class DirectionalGenerator {
        HalfDirectionalGenerator cA;
        HalfDirectionalGenerator cB;

        public DirectionalGenerator() {
            this.cA = new HalfDirectionalGenerator();
            this.cB = new HalfDirectionalGenerator();
        }

        public void setXZ(double x, double z) {
            this.cA.setXZ(x, z);
            this.cB.setXZ(x, z);
        }

        public double getForY(double y) {
            double yB = y + 222.56852877260073;
            return this.cA.getForY(y) + this.cB.getForY(yB);
        }

        public void getDirection(Vector3d direction, double y) {
            direction.m_176285_(0.0, 0.0, 0.0);
            double yB = y + 222.56852877260073;
            this.cA.getDirection(direction, y);
            this.cB.getDirection(direction, yB);
        }
    }

    private final class HalfDirectionalGenerator {
        private double xs;
        private double zs;
        private double xzr;
        private double localMinY = Double.POSITIVE_INFINITY;
        private double localMaxY;
        private double y0;
        private int xrb;
        private int yrb;
        private int zrb;
        private double xi0;
        private double zi0;
        private double gbRet;
        private double gvRet;
        private double gxRet;
        private double gzRet;
        private double g000b;
        private double g100b;
        private double g010b;
        private double g001b;
        private double g000y;
        private double g100y;
        private double g010y;
        private double g001y;
        private double g000x;
        private double g100x;
        private double g010x;
        private double g001x;
        private double g000z;
        private double g100z;
        private double g010z;
        private double g001z;
        private double xzFalloff000;
        private double xzFalloff100;
        private double xzFalloff010;
        private double xzFalloff001;
        private double yb000;
        private double yb100;
        private double yb010;
        private double yb001;
        private double dx000;
        private double dx100;
        private double dx010;
        private double dx001;
        private double dz000;
        private double dz100;
        private double dz010;
        private double dz001;
        private double yBound000;
        private double yBound100;
        private double yBound010;
        private double yBound001;
        private double yMin000;
        private double yMin100;
        private double yMin010;
        private double yMin001;
        private double yMax000;
        private double yMax100;
        private double yMax010;
        private double yMax001;

        protected HalfDirectionalGenerator() {
        }

        public void setXZ(double x, double z) {
            double xz = x + z;
            this.xs = SimplexNoiseCached.fma(xz, -0.211324865405187, x);
            this.zs = SimplexNoiseCached.fma(xz, -0.211324865405187, z);
            this.xzr = xz * -0.5773502588272095;
            this.localMinY = Double.POSITIVE_INFINITY;
        }

        public double getForY(double y) {
            this.setupAndDomainRotate(y);
            double t = y - this.y0;
            this.setup000Corner(t);
            this.corner100(t);
            this.corner010(t);
            this.corner001(t);
            double value = this.valueContribution(t);
            return value;
        }

        public void getDirection(Vector3d direction, double y) {
            this.setupAndDomainRotate(y);
            double t = y - this.y0;
            this.setup000Corner(t);
            this.corner100(t);
            this.corner010(t);
            this.corner001(t);
            this.setDirection(direction, t);
        }

        private void corner100(double t) {
            if (t < this.yMin100 || t > this.yMax100) {
                if (t > this.yBound100) {
                    this.yb100 = 1.154700517654419;
                    this.yMin100 = this.yBound100;
                    this.yMax100 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 + 0.788675134594813;
                    double zi = this.zi0 - 0.211324865405187;
                    this.dx100 = xi;
                    this.dz100 = zi;
                    int gi = this.gradIndex(this.xrb, this.yrb + 1, this.zrb + 1);
                    this.sample100(xi, zi, gi);
                } else {
                    this.yb100 = 0.5773502588272095;
                    this.yMin100 = Double.NEGATIVE_INFINITY;
                    this.yMax100 = this.yBound100;
                    double xi = this.xi0 - 0.788675134594813;
                    double zi = this.zi0 + 0.211324865405187;
                    this.dx100 = xi;
                    this.dz100 = zi;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb, this.zrb);
                    this.sample100(xi, zi, gi);
                }
            }
        }

        private void corner010(double t) {
            if (t < this.yMin010 || t > this.yMax010) {
                if (t > this.yBound010) {
                    this.yb010 = 1.154700517654419;
                    this.yMin010 = this.yBound010;
                    this.yMax010 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 - 0.57735026918962;
                    double zi = this.zi0 - 0.57735026918962;
                    this.dx010 = xi;
                    this.dz010 = zi;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb, this.zrb + 1);
                    this.sample010(xi, zi, gi);
                } else {
                    this.yb010 = 0.5773502588272095;
                    this.yMin010 = Double.NEGATIVE_INFINITY;
                    this.yMax010 = this.yBound010;
                    double xi = this.xi0 + 0.577350269189626;
                    double zi = this.zi0 + 0.577350269189626;
                    this.dx010 = xi;
                    this.dz010 = zi;
                    int gi = this.gradIndex(this.xrb, this.yrb + 1, this.zrb);
                    this.sample010(xi, zi, gi);
                }
            }
        }

        private void corner001(double t) {
            if (t < this.yMin001 || t > this.yMax001) {
                if (t > this.yBound001) {
                    this.yb001 = 1.154700517654419;
                    this.yMin001 = this.yBound001;
                    this.yMax001 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 - 0.211324865405187;
                    double zi = this.zi0 + 0.788675134594813;
                    this.dx001 = xi;
                    this.dz001 = zi;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb + 1, this.zrb);
                    this.sample001(xi, zi, gi);
                } else {
                    this.yb001 = 0.5773502588272095;
                    this.yMin001 = Double.NEGATIVE_INFINITY;
                    this.yMax001 = this.yBound001;
                    double xi = this.xi0 + 0.211324865405187;
                    double zi = this.zi0 - 0.788675134594813;
                    this.dx001 = xi;
                    this.dz001 = zi;
                    int gi = this.gradIndex(this.xrb, this.yrb, this.zrb + 1);
                    this.sample001(xi, zi, gi);
                }
            }
        }

        private double valueContribution(double t) {
            double value = 0.0;
            double dy000 = t - this.yb000;
            double dy100 = t - this.yb100;
            double dy010 = t - this.yb010;
            double dy001 = t - this.yb001;
            double dy000Sq = dy000 * dy000;
            double dy100Sq = dy100 * dy100;
            double dy010Sq = dy010 * dy010;
            double dy001Sq = dy001 * dy001;
            if (this.xzFalloff000 > dy000Sq) {
                value = this.falloffContribution(dy000, dy000Sq, this.xzFalloff000, this.g000y, this.g000b);
            }
            if (this.xzFalloff100 > dy100Sq) {
                value += this.falloffContribution(dy100, dy100Sq, this.xzFalloff100, this.g100y, this.g100b);
            }
            if (this.xzFalloff010 > dy010Sq) {
                value += this.falloffContribution(dy010, dy010Sq, this.xzFalloff010, this.g010y, this.g010b);
            }
            if (this.xzFalloff001 > dy001Sq) {
                value += this.falloffContribution(dy001, dy001Sq, this.xzFalloff001, this.g001y, this.g001b);
            }
            return value;
        }

        private void setDirection(Vector3d direction, double t) {
            double rampScaled;
            double falloffCubed;
            double ramp;
            double falloffSqr;
            double falloff;
            double dy000 = t - this.yb000;
            double dy100 = t - this.yb100;
            double dy010 = t - this.yb010;
            double dy001 = t - this.yb001;
            double dy000Sq = dy000 * dy000;
            double dy100Sq = dy100 * dy100;
            double dy010Sq = dy010 * dy010;
            double dy001Sq = dy001 * dy001;
            if (this.xzFalloff000 > dy000Sq) {
                falloff = this.xzFalloff000 - dy000Sq;
                falloffSqr = falloff * falloff;
                ramp = this.g000b + this.g000y * dy000;
                falloffCubed = falloff * falloffSqr;
                rampScaled = 8.0 * ramp;
                direction.f_86214_ += (this.g000x * falloff - rampScaled * this.dx000) * falloffCubed;
                direction.f_86215_ += (this.g000y * falloff - rampScaled * dy000) * falloffCubed;
                direction.f_86216_ += (this.g000z * falloff - rampScaled * this.dz000) * falloffCubed;
            }
            if (this.xzFalloff100 > dy100Sq) {
                falloff = this.xzFalloff100 - dy100Sq;
                falloffSqr = falloff * falloff;
                ramp = this.g100b + this.g100y * dy100;
                falloffCubed = falloff * falloffSqr;
                rampScaled = 8.0 * ramp;
                direction.f_86214_ += (this.g100x * falloff - rampScaled * this.dx100) * falloffCubed;
                direction.f_86215_ += (this.g100y * falloff - rampScaled * dy100) * falloffCubed;
                direction.f_86216_ += (this.g100z * falloff - rampScaled * this.dz100) * falloffCubed;
            }
            if (this.xzFalloff010 > dy010Sq) {
                falloff = this.xzFalloff010 - dy010Sq;
                falloffSqr = falloff * falloff;
                ramp = this.g010b + this.g010y * dy010;
                falloffCubed = falloff * falloffSqr;
                rampScaled = 8.0 * ramp;
                direction.f_86214_ += (this.g010x * falloff - rampScaled * this.dx010) * falloffCubed;
                direction.f_86215_ += (this.g010y * falloff - rampScaled * dy010) * falloffCubed;
                direction.f_86216_ += (this.g010z * falloff - rampScaled * this.dz010) * falloffCubed;
            }
            if (this.xzFalloff001 > dy001Sq) {
                falloff = this.xzFalloff001 - dy001Sq;
                falloffSqr = falloff * falloff;
                ramp = this.g001b + this.g001y * dy001;
                falloffCubed = falloff * falloffSqr;
                rampScaled = 8.0 * ramp;
                direction.f_86214_ += (this.g001x * falloff - rampScaled * this.dx001) * falloffCubed;
                direction.f_86215_ += (this.g001y * falloff - rampScaled * dy001) * falloffCubed;
                direction.f_86216_ += (this.g001z * falloff - rampScaled * this.dz001) * falloffCubed;
            }
        }

        private void setup000Corner(double t) {
            if (t < this.yMin000 || t > this.yMax000) {
                if (t > this.yBound000) {
                    this.yb000 = 1.7320508075688772;
                    this.yMin000 = this.yBound000;
                    this.yMax000 = Double.POSITIVE_INFINITY;
                    this.dx000 = this.xi0;
                    this.dz000 = this.zi0;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb + 1, this.zrb + 1);
                    this.sampleCorner(gi, this.xi0, this.zi0);
                } else {
                    this.yb000 = 0.0;
                    this.yMin000 = Double.NEGATIVE_INFINITY;
                    this.yMax000 = this.yBound000;
                    this.dx000 = this.xi0;
                    this.dz000 = this.zi0;
                    int gi = this.gradIndex(this.xrb, this.yrb, this.zrb);
                    this.sampleCorner(gi, this.xi0, this.zi0);
                }
                this.g000b = this.gbRet;
                this.g000y = this.gvRet;
                this.g000x = this.gxRet;
                this.g000z = this.gzRet;
            }
        }

        private void setupAndDomainRotate(double y) {
            if (y < this.localMinY || y > this.localMaxY) {
                double c2;
                double xr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.xs);
                double zr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.zs);
                double yr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.xzr);
                this.xrb = SimplexNoiseCached.fastFloor(xr);
                this.yrb = SimplexNoiseCached.fastFloor(yr);
                this.zrb = SimplexNoiseCached.fastFloor(zr);
                double xri = xr - (double)this.xrb;
                double yri = yr - (double)this.yrb;
                double zri = zr - (double)this.zrb;
                this.localMinY = SimplexNoiseCached.fma(xri < zri ? Math.min(xri, yri) : Math.min(zri, yri), -1.7320508075688772, y);
                this.localMaxY = SimplexNoiseCached.fma(1.0 - (xri >= zri ? Math.max(xri, yri) : Math.max(zri, yri)), 1.7320508075688772, y);
                this.y0 = (double)(this.yrb + this.xrb + this.zrb) * 0.5773502588272095;
                double tri = xri + yri;
                double xri0 = SimplexNoiseCached.fma(tri += zri, -0.3333333333333333, xri);
                double yri0 = SimplexNoiseCached.fma(tri, -0.3333333333333333, yri);
                double zri0 = SimplexNoiseCached.fma(tri, -0.3333333333333333, zri);
                this.xzFalloff000 = c2 = this.setupMulAdd(xri0, yri0, zri0);
                this.yMin001 = Double.POSITIVE_INFINITY;
                this.yMin010 = Double.POSITIVE_INFINITY;
                this.yMin100 = Double.POSITIVE_INFINITY;
                this.yMin000 = Double.POSITIVE_INFINITY;
            }
        }

        private double setupMulAdd(double xri0, double yri0, double zri0) {
            double x0r1 = SimplexNoiseCached.fma(xri0, 3.464101552963257, 0.8660253882408142);
            double y0r1 = SimplexNoiseCached.fma(yri0, 3.464101552963257, 0.8660253882408142);
            double z0r1 = SimplexNoiseCached.fma(zri0, 3.464101552963257, 0.8660253882408142);
            double a1 = xri0 + zri0;
            double b2 = yri0 * 0.5773502588272095;
            double s2i = SimplexNoiseCached.fma(a1, -0.211324865405187, -b2);
            this.xi0 = xri0 + s2i;
            this.zi0 = zri0 + s2i;
            double c1 = SimplexNoiseCached.fma(-this.xi0, this.xi0, 0.75);
            double c2 = SimplexNoiseCached.fma(-this.zi0, this.zi0, c1);
            this.yBound000 = 0.8660253882408142;
            this.yBound100 = x0r1;
            this.yBound010 = y0r1;
            this.yBound001 = z0r1;
            return c2;
        }

        private void sample100(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g100b = this.gbRet;
            this.g100y = this.gvRet;
            this.g100x = this.gxRet;
            this.g100z = this.gzRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff100 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sample010(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g010b = this.gbRet;
            this.g010y = this.gvRet;
            this.g010x = this.gxRet;
            this.g010z = this.gzRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff010 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sample001(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g001b = this.gbRet;
            this.g001y = this.gvRet;
            this.g001x = this.gxRet;
            this.g001z = this.gzRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff001 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sampleCorner(int gi, double xi, double zi) {
            int i0 = gi + 0;
            int i1 = gi + 1;
            int i2 = gi + 2;
            double gr0 = RGRADIENTS_3D[i0];
            double gr1 = RGRADIENTS_3D[i1];
            double gr2 = RGRADIENTS_3D[i2];
            double b1 = gr0 * xi;
            this.gxRet = gr0;
            this.gzRet = gr1;
            this.gvRet = gr2;
            this.gbRet = SimplexNoiseCached.fma(gr1, zi, b1);
        }

        private double falloffContribution(double dy000, double dy000Sq, double xzFalloff, double gv, double gb) {
            double falloff = xzFalloff - dy000Sq;
            falloff *= falloff;
            double f2 = falloff * falloff;
            return f2 * SimplexNoiseCached.fma(gv, dy000, gb);
        }

        private int gradIndex(int xrv, int yrv, int zrv) {
            int xm = xrv & 0xFF;
            int ym = yrv & 0xFF;
            int zm = zrv & 0xFF;
            return SimplexNoiseCached.this.perm[SimplexNoiseCached.this.perm[SimplexNoiseCached.this.perm[xm] ^ ym] ^ zm] & 0xFC;
        }
    }

    private final class HalfGenerator {
        private double xs;
        private double zs;
        private double xzr;
        private double localMinY = Double.POSITIVE_INFINITY;
        private double localMaxY;
        private double y0;
        private int xrb;
        private int yrb;
        private int zrb;
        private double xi0;
        private double zi0;
        private double gbRet;
        private double gvRet;
        private double g000b;
        private double g100b;
        private double g010b;
        private double g001b;
        private double g000v;
        private double g100v;
        private double g010v;
        private double g001v;
        private double xzFalloff000;
        private double xzFalloff100;
        private double xzFalloff010;
        private double xzFalloff001;
        private double yb000;
        private double yb100;
        private double yb010;
        private double yb001;
        private double yBound000;
        private double yBound100;
        private double yBound010;
        private double yBound001;
        private double yMin000;
        private double yMin100;
        private double yMin010;
        private double yMin001;
        private double yMax000;
        private double yMax100;
        private double yMax010;
        private double yMax001;

        protected HalfGenerator() {
        }

        public void setXZ(double x, double z) {
            double xz = x + z;
            this.xs = SimplexNoiseCached.fma(xz, -0.211324865405187, x);
            this.zs = SimplexNoiseCached.fma(xz, -0.211324865405187, z);
            this.xzr = xz * -0.5773502588272095;
            this.localMinY = Double.POSITIVE_INFINITY;
        }

        public double getForY(double y) {
            this.setupAndDomainRotate(y);
            double t = y - this.y0;
            this.setup000Corner(t);
            this.corner100(t);
            this.corner010(t);
            this.corner001(t);
            double value = this.valueContribution(t);
            return value;
        }

        private void corner100(double t) {
            if (t < this.yMin100 || t > this.yMax100) {
                if (t > this.yBound100) {
                    this.yb100 = 1.154700517654419;
                    this.yMin100 = this.yBound100;
                    this.yMax100 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 + 0.788675134594813;
                    double zi = this.zi0 - 0.211324865405187;
                    int gi = this.gradIndex(this.xrb, this.yrb + 1, this.zrb + 1);
                    this.sample100(xi, zi, gi);
                } else {
                    this.yb100 = 0.5773502588272095;
                    this.yMin100 = Double.NEGATIVE_INFINITY;
                    this.yMax100 = this.yBound100;
                    double xi = this.xi0 - 0.788675134594813;
                    double zi = this.zi0 + 0.211324865405187;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb, this.zrb);
                    this.sample100(xi, zi, gi);
                }
            }
        }

        private void corner010(double t) {
            if (t < this.yMin010 || t > this.yMax010) {
                if (t > this.yBound010) {
                    this.yb010 = 1.154700517654419;
                    this.yMin010 = this.yBound010;
                    this.yMax010 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 - 0.57735026918962;
                    double zi = this.zi0 - 0.57735026918962;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb, this.zrb + 1);
                    this.sample010(xi, zi, gi);
                } else {
                    this.yb010 = 0.5773502588272095;
                    this.yMin010 = Double.NEGATIVE_INFINITY;
                    this.yMax010 = this.yBound010;
                    double xi = this.xi0 + 0.577350269189626;
                    double zi = this.zi0 + 0.577350269189626;
                    int gi = this.gradIndex(this.xrb, this.yrb + 1, this.zrb);
                    this.sample010(xi, zi, gi);
                }
            }
        }

        private void corner001(double t) {
            if (t < this.yMin001 || t > this.yMax001) {
                if (t > this.yBound001) {
                    this.yb001 = 1.154700517654419;
                    this.yMin001 = this.yBound001;
                    this.yMax001 = Double.POSITIVE_INFINITY;
                    double xi = this.xi0 - 0.211324865405187;
                    double zi = this.zi0 + 0.788675134594813;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb + 1, this.zrb);
                    this.sample001(xi, zi, gi);
                } else {
                    this.yb001 = 0.5773502588272095;
                    this.yMin001 = Double.NEGATIVE_INFINITY;
                    this.yMax001 = this.yBound001;
                    double xi = this.xi0 + 0.211324865405187;
                    double zi = this.zi0 - 0.788675134594813;
                    int gi = this.gradIndex(this.xrb, this.yrb, this.zrb + 1);
                    this.sample001(xi, zi, gi);
                }
            }
        }

        private double valueContribution(double t) {
            double value = 0.0;
            double dy000 = t - this.yb000;
            double dy100 = t - this.yb100;
            double dy010 = t - this.yb010;
            double dy001 = t - this.yb001;
            double dy000Sq = dy000 * dy000;
            double dy100Sq = dy100 * dy100;
            double dy010Sq = dy010 * dy010;
            double dy001Sq = dy001 * dy001;
            if (this.xzFalloff000 > dy000Sq) {
                value = this.falloffContribution(dy000, dy000Sq, this.xzFalloff000, this.g000v, this.g000b);
            }
            if (this.xzFalloff100 > dy100Sq) {
                value += this.falloffContribution(dy100, dy100Sq, this.xzFalloff100, this.g100v, this.g100b);
            }
            if (this.xzFalloff010 > dy010Sq) {
                value += this.falloffContribution(dy010, dy010Sq, this.xzFalloff010, this.g010v, this.g010b);
            }
            if (this.xzFalloff001 > dy001Sq) {
                value += this.falloffContribution(dy001, dy001Sq, this.xzFalloff001, this.g001v, this.g001b);
            }
            return value;
        }

        private void setup000Corner(double t) {
            if (t < this.yMin000 || t > this.yMax000) {
                if (t > this.yBound000) {
                    this.yb000 = 1.7320508075688772;
                    this.yMin000 = this.yBound000;
                    this.yMax000 = Double.POSITIVE_INFINITY;
                    int gi = this.gradIndex(this.xrb + 1, this.yrb + 1, this.zrb + 1);
                    this.sampleCorner(gi, this.xi0, this.zi0);
                } else {
                    this.yb000 = 0.0;
                    this.yMin000 = Double.NEGATIVE_INFINITY;
                    this.yMax000 = this.yBound000;
                    int gi = this.gradIndex(this.xrb, this.yrb, this.zrb);
                    this.sampleCorner(gi, this.xi0, this.zi0);
                }
                this.g000b = this.gbRet;
                this.g000v = this.gvRet;
            }
        }

        private void setupAndDomainRotate(double y) {
            if (y < this.localMinY || y > this.localMaxY) {
                double c2;
                double xr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.xs);
                double zr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.zs);
                double yr = SimplexNoiseCached.fma(y, 0.5773502588272095, this.xzr);
                this.xrb = SimplexNoiseCached.fastFloor(xr);
                this.yrb = SimplexNoiseCached.fastFloor(yr);
                this.zrb = SimplexNoiseCached.fastFloor(zr);
                double xri = xr - (double)this.xrb;
                double yri = yr - (double)this.yrb;
                double zri = zr - (double)this.zrb;
                this.localMinY = SimplexNoiseCached.fma(xri < zri ? Math.min(xri, yri) : Math.min(zri, yri), -1.7320508075688772, y);
                this.localMaxY = SimplexNoiseCached.fma(1.0 - (xri >= zri ? Math.max(xri, yri) : Math.max(zri, yri)), 1.7320508075688772, y);
                this.y0 = (double)(this.yrb + this.xrb + this.zrb) * 0.5773502588272095;
                double tri = xri + yri;
                double xri0 = SimplexNoiseCached.fma(tri += zri, -0.3333333333333333, xri);
                double yri0 = SimplexNoiseCached.fma(tri, -0.3333333333333333, yri);
                double zri0 = SimplexNoiseCached.fma(tri, -0.3333333333333333, zri);
                this.xzFalloff000 = c2 = this.setupMulAdd(xri0, yri0, zri0);
                this.yMin001 = Double.POSITIVE_INFINITY;
                this.yMin010 = Double.POSITIVE_INFINITY;
                this.yMin100 = Double.POSITIVE_INFINITY;
                this.yMin000 = Double.POSITIVE_INFINITY;
            }
        }

        private double setupMulAdd(double xri0, double yri0, double zri0) {
            double x0r1 = SimplexNoiseCached.fma(xri0, 3.464101552963257, 0.8660253882408142);
            double y0r1 = SimplexNoiseCached.fma(yri0, 3.464101552963257, 0.8660253882408142);
            double z0r1 = SimplexNoiseCached.fma(zri0, 3.464101552963257, 0.8660253882408142);
            double a1 = xri0 + zri0;
            double b2 = yri0 * 0.5773502588272095;
            double s2i = SimplexNoiseCached.fma(a1, -0.211324865405187, -b2);
            this.xi0 = xri0 + s2i;
            this.zi0 = zri0 + s2i;
            double c1 = SimplexNoiseCached.fma(-this.xi0, this.xi0, 0.75);
            double c2 = SimplexNoiseCached.fma(-this.zi0, this.zi0, c1);
            this.yBound000 = 0.8660253882408142;
            this.yBound100 = x0r1;
            this.yBound010 = y0r1;
            this.yBound001 = z0r1;
            return c2;
        }

        private void sample100(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g100b = this.gbRet;
            this.g100v = this.gvRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff100 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sample010(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g010b = this.gbRet;
            this.g010v = this.gvRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff010 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sample001(double xi, double zi, int gi) {
            double c2;
            this.sampleCorner(gi, xi, zi);
            this.g001b = this.gbRet;
            this.g001v = this.gvRet;
            double c1 = SimplexNoiseCached.fma(-xi, xi, 0.75);
            this.xzFalloff001 = c2 = SimplexNoiseCached.fma(-zi, zi, c1);
        }

        private void sampleCorner(int gi, double xi, double zi) {
            int i0 = gi + 0;
            int i1 = gi + 1;
            int i2 = gi + 2;
            double gr0 = RGRADIENTS_3D[i0];
            double gr1 = RGRADIENTS_3D[i1];
            double gr2 = RGRADIENTS_3D[i2];
            double b1 = gr0 * xi;
            this.gvRet = gr2;
            this.gbRet = SimplexNoiseCached.fma(gr1, zi, b1);
        }

        private double falloffContribution(double dy000, double dy000Sq, double xzFalloff, double gv, double gb) {
            double falloff = xzFalloff - dy000Sq;
            falloff *= falloff;
            double f2 = falloff * falloff;
            return f2 * SimplexNoiseCached.fma(gv, dy000, gb);
        }

        private int gradIndex(int xrv, int yrv, int zrv) {
            int xm = xrv & 0xFF;
            int ym = yrv & 0xFF;
            int zm = zrv & 0xFF;
            return SimplexNoiseCached.this.perm[SimplexNoiseCached.this.perm[SimplexNoiseCached.this.perm[xm] ^ ym] ^ zm] & 0xFC;
        }
    }
}

