/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world;

import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.util.data.Vec2f;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Locale;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public enum Season {
    SPRING,
    SUMMER,
    FALL,
    WINTER;

    public static final long SEASON_LENGTH = 336000L;
    public static final long YEAR_LENGTH = 1344000L;
    public static final long SPRING_START = 0L;
    public static final long SUMMER_START = 336000L;
    public static final long FALL_START = 672000L;
    public static final long WINTER_START = 1008000L;
    public static final float TEMP_INFLUENCE = 0.25f;
    private final TranslatableComponent translatable = new TranslatableComponent("season." + this.toString().toLowerCase(Locale.ROOT));

    public float getProgress(long time) {
        return (float)(time % 336000L) / 336000.0f;
    }

    public long getStartTime() {
        return (long)this.ordinal() * 336000L;
    }

    public long getMiddleTime() {
        return (long)this.ordinal() * 336000L + 168000L;
    }

    public TranslatableComponent toTranslatable() {
        return this.translatable;
    }

    public static Season get(Level level) {
        return LevelData.isPresent(level) ? Season.get(LevelData.get(level).getSeasonTime()) : SUMMER;
    }

    public static Season get(long time) {
        return switch ((int)(time / 336000L) % 4) {
            case 0 -> SPRING;
            case 1 -> SUMMER;
            case 2 -> FALL;
            default -> WINTER;
        };
    }

    public static float getNormalizedProgress(Level level) {
        return LevelData.isPresent(level) ? Season.getNormalizedProgress(LevelData.get(level).getSeasonTime()) : (float)SUMMER.getMiddleTime();
    }

    public static float getNormalizedProgress(long time) {
        return (float)(time % 1344000L) / 1344000.0f;
    }

    public static LongLongPair getTimesAtTemperatureInfluence(float tempInfluence) {
        double acos = 4.0 * Math.acos(-tempInfluence / 0.25f);
        long startTime = (long)(-(168000.0 * (Math.PI + acos) / Math.PI));
        long endTime = (long)(168000.0 * (-Math.PI + acos) / Math.PI);
        return LongLongPair.of((long)startTime, (long)endTime);
    }

    public static long getTimePassedWithin(long seasonTime, long elapsedTime, long startTime, long endTime) {
        long pastPartialTime;
        long fullDays = elapsedTime / 1344000L;
        long activeTime = endTime - startTime;
        if (activeTime != 1344000L) {
            activeTime = Math.floorMod(activeTime, 1344000L);
        }
        long timePassed = activeTime * fullDays;
        long currentPartialTime = Math.floorMod(seasonTime, 1344000L);
        if (currentPartialTime == (pastPartialTime = currentPartialTime - elapsedTime % 1344000L)) {
            return timePassed;
        }
        if (endTime < startTime) {
            if (pastPartialTime < endTime) {
                timePassed += Math.min(endTime, currentPartialTime) - pastPartialTime;
            }
            if (currentPartialTime > startTime) {
                timePassed += currentPartialTime - Math.max(pastPartialTime, startTime);
            }
        } else if (currentPartialTime > startTime && pastPartialTime < endTime) {
            timePassed += Math.min(currentPartialTime, endTime) - Math.max(pastPartialTime, startTime);
        }
        return timePassed;
    }

    public static float getTemperatureInfluence(long time) {
        float progress = (float)time / 1344000.0f * (float)Math.PI * 2.0f;
        return 0.25f * Mth.m_14031_((float)(progress - 0.7853982f));
    }

    public static Vec2f getMinMaxTemperatureInfluence(long startTime, long endTime) {
        boolean hasC2;
        long c2;
        long timeElapsed = endTime - startTime;
        if (timeElapsed >= 1344000L) {
            return new Vec2f(-0.25f, 0.25f);
        }
        long c1 = Math.round((double)startTime / 672000.0) * 672000L;
        if (c1 == (c2 = Math.round((double)endTime / 672000.0) * 672000L)) {
            c2 = -1L;
        } else if ((Math.abs(c1) + Math.abs(c2)) % 1344000L == 0L) {
            c1 += 672000L;
        }
        boolean hasC1 = (c1 -= 168000L) >= startTime && c1 <= endTime;
        boolean bl = hasC2 = (c2 -= 168000L) >= startTime && c2 <= endTime;
        if (hasC1 && hasC2) {
            float c1Temp = Season.getTemperatureInfluence(c1);
            float c2Temp = Season.getTemperatureInfluence(c2);
            return new Vec2f(Math.min(c1Temp, c2Temp), Math.max(c1Temp, c2Temp));
        }
        float startTemp = Season.getTemperatureInfluence(startTime);
        float endTemp = Season.getTemperatureInfluence(endTime);
        if (hasC1) {
            float cTemp = Season.getTemperatureInfluence(c1);
            return new Vec2f(Math.min(cTemp, Math.min(startTemp, endTemp)), Math.max(cTemp, Math.max(startTemp, endTemp)));
        }
        if (hasC2) {
            float cTemp = Season.getTemperatureInfluence(c2);
            return new Vec2f(Math.min(cTemp, Math.min(startTemp, endTemp)), Math.max(cTemp, Math.max(startTemp, endTemp)));
        }
        return new Vec2f(Math.min(startTemp, endTemp), Math.max(startTemp, endTemp));
    }

    public static float getGrowthMultiplier(long time) {
        float progress = (float)time / 1344000.0f * (float)Math.PI * 2.0f;
        float sin = Mth.m_14031_((float)(progress - 0.7853982f));
        if (sin > 0.0f) {
            sin *= 0.5f;
        }
        return 0.5f * sin;
    }
}

