/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world;

import java.util.Locale;
import net.minecraft.network.chat.TranslatableComponent;

public enum Weather {
    CLEAR(false),
    CLOUDS(false),
    RAIN(true),
    SNOW(true),
    FOG(false);

    public static final double PARTICLE_SPAWN_RADIUS = 32.0;
    public static final double PARTICLE_DESPAWN_RADIUS_SQR = 1296.0;
    public static final float FOG_THRESHOLD = -0.45f;
    public static final float GLOBAL_CLEAR_THRESHOLD = 0.15f;
    public static final float GLOBAL_CLOUDS_THRESHOLD = 0.45f;
    public final boolean isPrecipitation;
    private final TranslatableComponent translatable;

    private Weather(boolean isPrecipitation) {
        this.isPrecipitation = isPrecipitation;
        this.translatable = new TranslatableComponent("weather." + this.toString().toLowerCase(Locale.ROOT));
    }

    public static Weather get(float intensity) {
        if (intensity < -0.45f) {
            return FOG;
        }
        if (intensity < 0.15f) {
            return CLEAR;
        }
        if (intensity < 0.45f) {
            return CLOUDS;
        }
        return RAIN;
    }

    public TranslatableComponent toTranslatable() {
        return this.translatable;
    }
}

