/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3d;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.block.IStone;
import frostnox.nightfall.block.ITimeSimulatedBlock;
import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.DirtBlock;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.UnstableBlock;
import frostnox.nightfall.block.block.fireable.SimpleFireableBlock;
import frostnox.nightfall.block.block.liquid.LavaLiquidBlock;
import frostnox.nightfall.block.block.liquid.SizedLiquidBlock;
import frostnox.nightfall.registry.forge.BiomesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.data.WrappedBool;
import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.util.math.Spline;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseCached;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.util.math.noise.SimplexNoiseCached;
import frostnox.nightfall.world.StoneGroup;
import frostnox.nightfall.world.biome.ContinentalBiomeSource;
import frostnox.nightfall.world.generation.TreePool;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ContinentalChunkGenerator
extends ChunkGenerator {
    public static final Codec<ContinentalChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> ContinentalChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(gen -> gen.seed))).apply((Applicative)instance, instance.stable(ContinentalChunkGenerator::new)));
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final BlockState CAVE_AIR = Blocks.f_50627_.m_49966_();
    private static final BlockState BEDROCK = ((Block)BlocksNF.BEDROCK.get()).m_49966_();
    private static final BlockState WATER = ((SizedLiquidBlock)((Object)BlocksNF.WATER.get())).m_49966_();
    private static final BlockState SEAWATER = ((SizedLiquidBlock)((Object)BlocksNF.SEAWATER.get())).m_49966_();
    private static final BlockState LAVA = ((LavaLiquidBlock)BlocksNF.LAVA.get()).m_49966_();
    private static final BlockState SILT = ((SoilBlock)BlocksNF.SILT.get()).m_49966_();
    private static final BlockState DIRT = ((DirtBlock)BlocksNF.DIRT.get()).m_49966_();
    private static final BlockState LOAM = ((SoilBlock)BlocksNF.LOAM.get()).m_49966_();
    private static final Map<Soil, BlockState> SOILS = DataUtil.mapEnum(Soil.class, type -> switch (type) {
        default -> throw new IncompatibleClassChangeError();
        case Soil.SILT -> ((SoilBlock)BlocksNF.SILT.get()).m_49966_();
        case Soil.DIRT -> ((DirtBlock)BlocksNF.DIRT.get()).m_49966_();
        case Soil.LOAM -> ((SoilBlock)BlocksNF.LOAM.get()).m_49966_();
        case Soil.ASH -> ((UnstableBlock)BlocksNF.ASH.get()).m_49966_();
        case Soil.GRAVEL -> ((UnstableBlock)BlocksNF.GRAVEL.get()).m_49966_();
        case Soil.BLUE_GRAVEL -> ((UnstableBlock)BlocksNF.BLUE_GRAVEL.get()).m_49966_();
        case Soil.BLACK_GRAVEL -> ((UnstableBlock)BlocksNF.BLACK_GRAVEL.get()).m_49966_();
        case Soil.SAND -> ((UnstableBlock)BlocksNF.SAND.get()).m_49966_();
        case Soil.RED_SAND -> ((UnstableBlock)BlocksNF.RED_SAND.get()).m_49966_();
        case Soil.WHITE_SAND -> ((UnstableBlock)BlocksNF.WHITE_SAND.get()).m_49966_();
    });
    public static final float LOW_CLIMATE = 0.3f;
    public static final float HIGH_CLIMATE = 0.7f;
    private static final float PILLAR_Y = 0.12f;
    public static final int SEA_LEVEL = 416;
    public static final int LAVA_LEVEL = 16;
    public static final int MIN_Y = 0;
    public static final int MAX_Y = 832;
    private static final ThreadLocal<Object2FloatMap<ChunkPos>> temperatureCache = new ThreadLocal();
    private static final ThreadLocal<Object2FloatMap<ChunkPos>> humidityCache = new ThreadLocal();
    private static final ThreadLocal<Object2FloatMap<ChunkPos>> exposureCache = new ThreadLocal();
    private static final ThreadLocal<Map<ChunkPos, StoneGroup>> stoneGroupCache = new ThreadLocal();
    private static final ThreadLocal<Map<ChunkPos, Stone>> surfaceStoneCache = new ThreadLocal();
    private static final ThreadLocal<Map<ChunkPos, Soil>> soilCache = new ThreadLocal();
    private static final ThreadLocal<Map<ChunkPos, TreePool>> treePoolCache = new ThreadLocal();
    protected final long seed;
    protected final FractalSimplexNoiseFast elevation;
    protected final FractalSimplexNoiseFast roughness;
    protected final FractalSimplexNoiseFast detail;
    protected final FractalSimplexNoiseCached weathering;
    protected final FractalSimplexNoiseFast exposure;
    protected final FractalSimplexNoiseFast temperature;
    protected final FractalSimplexNoiseFast humidity;
    protected final FractalSimplexNoiseFast forestation;
    protected final FractalSimplexNoiseFast tree1;
    protected final FractalSimplexNoiseFast tree2;
    protected final FractalSimplexNoiseFast tree3;
    protected final FractalSimplexNoiseFast tree4;
    protected final FractalSimplexNoiseFast clayPatches;
    protected final FractalSimplexNoiseFast mudPatches;
    protected final SimplexNoiseCached bigTunnels1;
    protected final SimplexNoiseCached bigTunnels2;
    protected final SimplexNoiseCached smallTunnels1;
    protected final SimplexNoiseCached smallTunnels2;
    protected final FractalSimplexNoiseFast bigTunnelsWarp;
    protected final FractalSimplexNoiseFast smallTunnelsWarp;
    protected final FractalSimplexNoiseCached caverns;
    protected final FractalSimplexNoiseCached pillars;
    protected final FractalSimplexNoiseFast bedrock;
    protected final FractalSimplexNoiseFast bedrockCover;
    protected final FractalSimplexNoiseFast stoneType;
    protected final FractalSimplexNoiseFast igneousHeight;
    protected final FractalSimplexNoiseFast metamorphicHeight;
    protected final Spline elevationSpline;
    protected final Spline roughnessSpline;
    protected final Spline detailSpline;
    protected final Spline exposureSpline;

    public ContinentalChunkGenerator(Registry<StructureSet> structureSets, BiomeSource biomeSource, long seed) {
        super(structureSets, Optional.empty(), biomeSource, biomeSource, seed);
        if (biomeSource instanceof ContinentalBiomeSource) {
            ContinentalBiomeSource cBiomeSource = (ContinentalBiomeSource)biomeSource;
            cBiomeSource.generator = this;
        }
        this.seed = seed;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(seed));
        this.elevation = new FractalSimplexNoiseFast(random.nextLong(), 1.7E-4f, 8, 0.55f, 2.0f);
        this.roughness = new FractalSimplexNoiseFast(random.nextLong(), 7.0E-4f, 7, 0.5f, 2.0f);
        this.detail = new FractalSimplexNoiseFast(random.nextLong(), 0.0025f, 3, 0.5f, 2.0f);
        this.weathering = new FractalSimplexNoiseCached(random.nextLong(), 0.0056f, 0.64f, 2.0f);
        this.exposure = new FractalSimplexNoiseFast(random.nextLong(), 6.5E-4f, 6, 0.5f, 2.0f);
        this.temperature = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.humidity = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.forestation = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.tree1 = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.tree2 = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.tree3 = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.tree4 = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.clayPatches = new FractalSimplexNoiseFast(random.nextLong(), 0.011f, 2, 0.5f, 2.0f);
        this.mudPatches = new FractalSimplexNoiseFast(random.nextLong(), 0.011f, 2, 0.5f, 2.0f);
        this.bigTunnelsWarp = new FractalSimplexNoiseFast(random.nextLong(), 0.014f, 2, 0.5f, 2.0f);
        this.smallTunnelsWarp = new FractalSimplexNoiseFast(random.nextLong(), 0.011f, 2, 0.5f, 2.0f);
        this.bigTunnels1 = new SimplexNoiseCached(random.nextLong());
        this.bigTunnels2 = new SimplexNoiseCached(random.nextLong());
        this.smallTunnels1 = new SimplexNoiseCached(random.nextLong());
        this.smallTunnels2 = new SimplexNoiseCached(random.nextLong());
        this.caverns = new FractalSimplexNoiseCached(random.nextLong(), 0.0063f, 0.5f, 2.0f);
        this.pillars = new FractalSimplexNoiseCached(random.nextLong(), 0.06f, 0.5f, 2.0f);
        this.bedrock = new FractalSimplexNoiseFast(random.nextLong(), 0.012f, 3, 0.52f, 2.24f);
        this.bedrockCover = new FractalSimplexNoiseFast(random.nextLong(), 0.016f, 3, 0.52f, 2.24f);
        this.stoneType = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.igneousHeight = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.metamorphicHeight = new FractalSimplexNoiseFast(random.nextLong(), 2.0E-4f, 7, 0.5f, 2.0f);
        this.elevationSpline = new Spline(Spline.point(-1.0, 423.0), Spline.point(-0.67, 423.0), Spline.point(-0.57, 364.0, Easing.inSine), Spline.point(-0.505, 64.0), Spline.point(0.115, 88.0), Spline.point(0.178, 364.0, Easing.inSine), Spline.point(0.278, 423.0, Easing.inSine), Spline.point(1.0, 423.0));
        this.roughnessSpline = new Spline(Spline.point(-1.0, 416.0), Spline.point(-0.7, 380.0), Spline.point(-0.3, 80.0, Easing.inOutSine), Spline.point(-0.1, 35.0, Easing.inOutSine), Spline.point(0.07, 17.0), Spline.point(0.3, -12.0, Easing.inSine), Spline.point(0.45, 90.0, Easing.inOutSine), Spline.point(0.5, 96.0), Spline.point(1.0, 0.0, Easing.inSine));
        this.detailSpline = new Spline(Spline.point(-1.0, 0.0), Spline.point(-0.65, 0.2, Easing.inOutSine), Spline.point(0.0, 0.5, Easing.inOutSine), Spline.point(0.7, 1.0, Easing.inOutSine), Spline.point(1.0, 1.0, Easing.outSine));
        this.exposureSpline = new Spline(Spline.point(-1.0, 2.0), Spline.point(-0.2, 2.0), Spline.point(0.0, 0.5), Spline.point(0.2, 0.0), Spline.point(1.0, 0.0));
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new ContinentalChunkGenerator((Registry<StructureSet>)this.f_207955_, this.f_62137_.m_7206_(seed), seed);
    }

    public Climate.Sampler m_183403_() {
        return Climate.m_207841_();
    }

    public int m_142051_(LevelHeightAccessor level) {
        return 417;
    }

    public void m_183516_(WorldGenRegion level, long pSeed, BiomeManager pBiomeManager, StructureFeatureManager pStructureFeatureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }

    public void m_183621_(WorldGenRegion level, StructureFeatureManager featureManager, ChunkAccess chunk) {
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess pChunk, StructureFeatureManager pStructureFeatureManager) {
        temperatureCache.set((Object2FloatMap<ChunkPos>)new Object2FloatArrayMap(4));
        humidityCache.set((Object2FloatMap<ChunkPos>)new Object2FloatArrayMap(4));
        exposureCache.set((Object2FloatMap<ChunkPos>)new Object2FloatArrayMap(4));
        stoneGroupCache.set((Map<ChunkPos, StoneGroup>)new Object2ObjectArrayMap(4));
        surfaceStoneCache.set((Map<ChunkPos, Stone>)new Object2ObjectArrayMap(4));
        soilCache.set((Map<ChunkPos, Soil>)new Object2ObjectArrayMap(4));
        treePoolCache.set((Map<ChunkPos, TreePool>)new Object2ObjectArrayMap(4));
        super.m_183372_(level, pChunk, pStructureFeatureManager);
        temperatureCache.remove();
        humidityCache.remove();
        exposureCache.remove();
        stoneGroupCache.remove();
        surfaceStoneCache.remove();
        soilCache.remove();
        treePoolCache.remove();
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        int maxIndex = chunk.m_151564_(831);
        int minIndex = chunk.m_151564_(0);
        HashSet set = Sets.newHashSet();
        for (int i = maxIndex; i >= minIndex; --i) {
            LevelChunkSection chunkSection = chunk.m_183278_(i);
            chunkSection.m_62981_();
            set.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"wgen_fill_noise", () -> this.fill(chunk)), Util.m_183991_()).whenCompleteAsync((p_209132_, p_209133_) -> {
            for (LevelChunkSection chunkSection : set) {
                chunkSection.m_63006_();
            }
        }, executor);
    }

    public float getElevation(int worldX, int worldZ) {
        return this.elevation.noise2D(worldX, worldZ);
    }

    public float getCachedTemperature(ChunkPos pos) {
        Object2FloatMap<ChunkPos> map = temperatureCache.get();
        if (map.containsKey((Object)pos)) {
            return map.getFloat((Object)pos);
        }
        float value = this.getTemperature(pos.m_45604_(), pos.m_45605_());
        map.put((Object)pos, value);
        return value;
    }

    public float getCachedHumidity(ChunkPos pos) {
        Object2FloatMap<ChunkPos> map = humidityCache.get();
        if (map.containsKey((Object)pos)) {
            return map.getFloat((Object)pos);
        }
        float value = this.getHumidity(pos.m_45604_(), pos.m_45605_());
        map.put((Object)pos, value);
        return value;
    }

    public float getCachedExposure(ChunkPos pos) {
        Object2FloatMap<ChunkPos> map = exposureCache.get();
        if (map.containsKey((Object)pos)) {
            return map.getFloat((Object)pos);
        }
        float value = this.exposure.noise2D(pos.m_45604_(), pos.m_45605_());
        map.put((Object)pos, value);
        return value;
    }

    public StoneGroup getCachedStoneGroup(ChunkPos pos) {
        Map<ChunkPos, StoneGroup> map = stoneGroupCache.get();
        if (map.containsKey(pos)) {
            return map.get(pos);
        }
        StoneGroup value = this.getStoneGroup(this.getCachedTemperature(pos), this.stoneType.noise2D(pos.m_151390_(), pos.m_151393_()));
        map.put(pos, value);
        return value;
    }

    public Stone getCachedSurfaceStone(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Map<ChunkPos, Stone> map = surfaceStoneCache.get();
        if (map.containsKey(chunkPos)) {
            return map.get(chunkPos);
        }
        float igneousHeight = this.getIgneousHeight(chunkPos.m_151390_(), chunkPos.m_151393_(), pos.m_123342_());
        Stone value = (Stone)ContinentalChunkGenerator.getStoneType(pos.m_123342_(), this.getCachedStoneGroup(chunkPos), igneousHeight, this.getMetamorphicHeight(chunkPos.m_151390_(), chunkPos.m_151393_(), pos.m_123342_(), igneousHeight));
        map.put(chunkPos, value);
        return value;
    }

    public Soil getCachedSoil(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Map<ChunkPos, Soil> map = soilCache.get();
        if (map.containsKey(chunkPos)) {
            return map.get(chunkPos);
        }
        int soilDepth = ContinentalChunkGenerator.getSoilDepth(pos.m_123342_(), this.getCachedHumidity(chunkPos), this.getCachedExposure(chunkPos));
        int soilQuality = ContinentalChunkGenerator.getSoilQuality(soilDepth, this.getCachedTemperature(chunkPos), this.getCachedHumidity(chunkPos));
        Soil value = switch (soilQuality) {
            case 1 -> Soil.SILT;
            case 2 -> Soil.DIRT;
            case 3 -> Soil.LOAM;
            default -> (Soil)this.getCachedSurfaceStone(pos).getSoil();
        };
        map.put(chunkPos, value);
        return value;
    }

    public TreePool getCachedTreePool(ChunkPos pos) {
        Map<ChunkPos, TreePool> map = treePoolCache.get();
        if (map.containsKey(pos)) {
            return map.get(pos);
        }
        TreePool value = this.getTreePool(pos.m_151390_(), pos.m_151393_(), this.getCachedTemperature(pos), this.getCachedHumidity(pos));
        map.put(pos, value);
        return value;
    }

    public TreePool getTreePool(int x, int z, float temp, float humidity) {
        int weight;
        TreePool.Entry[] trees = new TreePool.Entry[4];
        Tree primary = null;
        Tree secondary = null;
        Tree tertiary = null;
        Tree quaternary = null;
        float noise = this.tree1.noise2D(x, z);
        if ((double)noise < -0.14 || (double)noise > 0.14) {
            primary = Tree.chooseTree(Tree.PRIMARY_TREES, temp, humidity);
        }
        if ((double)(noise = this.tree2.noise2D(x, z)) < -0.164 || (double)noise > 0.164) {
            secondary = Tree.chooseTree(Tree.SECONDARY_TREES, temp, humidity);
        }
        if ((double)(noise = this.tree3.noise2D(x, z)) < -0.213 || (double)noise > 0.213) {
            tertiary = Tree.chooseTree(Tree.TERTIARY_TREES, temp, humidity);
        }
        if ((double)(noise = this.tree4.noise2D(x, z)) < -0.293 || (double)noise > 0.293) {
            quaternary = Tree.chooseTree(Tree.QUATERNARY_TREES, temp, humidity);
        }
        int totalWeight = 0;
        int size = 0;
        if (primary != null) {
            weight = 4;
            totalWeight += weight;
            trees[size] = new TreePool.Entry(primary, weight);
            ++size;
        }
        if (secondary != null) {
            weight = 3;
            totalWeight += weight;
            trees[size] = new TreePool.Entry(secondary, weight);
            ++size;
        }
        if (tertiary != null) {
            weight = 2;
            totalWeight += weight;
            trees[size] = new TreePool.Entry(tertiary, weight);
            ++size;
        }
        if (quaternary != null) {
            weight = 1;
            totalWeight += weight;
            trees[size] = new TreePool.Entry(quaternary, weight);
            ++size;
        }
        return new TreePool(trees, size, totalWeight);
    }

    public float getTemperature(int x, int z) {
        float noise = this.temperature.noise2D(x, z);
        float noise2 = noise * noise;
        float noise3 = noise2 * noise;
        float noise4 = noise3 * noise;
        if ((noise = 0.401713f * noise4 * noise + 3.44293E-4f * noise4 - 1.01173f * noise3 - 5.35267E-4f * noise2 + 1.10971f * noise + 0.500192f) > 1.0f) {
            noise = 1.0f;
        } else if (noise < 0.0f) {
            noise = 0.0f;
        }
        return noise;
    }

    public float getHumidity(int x, int z) {
        float noise = this.humidity.noise2D(x, z);
        float noise2 = noise * noise;
        float noise3 = noise2 * noise;
        float noise4 = noise3 * noise;
        if ((noise = 0.401713f * noise4 * noise + 3.44293E-4f * noise4 - 1.01173f * noise3 - 5.35267E-4f * noise2 + 1.10971f * noise + 0.500192f) > 1.0f) {
            noise = 1.0f;
        } else if (noise < 0.0f) {
            noise = 0.0f;
        }
        return noise;
    }

    public float getForestation(int x, int z) {
        return this.forestation.noise2D(x, z);
    }

    private int getHeight(float elevation, float roughness, float detail) {
        return (int)(this.elevationSpline.fit(elevation) + this.roughnessSpline.fit(roughness) * this.detailSpline.fit(detail));
    }

    public int getHeight(int x, int z) {
        return this.getHeight(this.elevation.noise2D(x, z), this.roughness.noise2D(x, z), this.detail.noise2D(x, z));
    }

    private StoneGroup getStoneGroup(float temperature, float noise) {
        float groupValue = 1.0f;
        return (groupValue += noise * 0.8f + (temperature - 0.5f) * 0.8f) > 1.5f ? StoneGroup.GRANITE : (groupValue < 0.5f ? StoneGroup.STYGFEL : (groupValue < 1.0f ? StoneGroup.DEEPSLATE : StoneGroup.BASALT));
    }

    private float getIgneousHeight(int x, int z, int height) {
        float randHeight = this.igneousHeight.noise2D(x, z);
        float igneousOffset = randHeight > 0.0f ? ((float)(height - 416) + randHeight * 160.0f) * 0.07f : (float)(height - 416) * 0.07f;
        return 128.0f + igneousOffset * igneousOffset;
    }

    private float getMetamorphicHeight(int x, int z, int height, float igneousHeight) {
        float randHeight = this.metamorphicHeight.noise2D(x, z);
        float metamorphicOffset = randHeight > 0.0f ? ((float)(height - 416) + randHeight * 160.0f) * 0.07f : (float)(height - 416) * 0.07f;
        return igneousHeight + 128.0f + metamorphicOffset * metamorphicOffset;
    }

    private float adjustCavernsNoise(float noise, int y, int height) {
        if (y > 63) {
            noise *= Math.max(0.0f, 1.0f - (float)(y - 63) / (float)(height - 63) * 1.4f);
        }
        return noise;
    }

    private boolean isPillarAir(float pillarNoise, float erosion, int worldY) {
        if ((float)worldY <= 40.0f) {
            return pillarNoise * (1.12f - erosion * ((float)worldY / 40.0f)) < 0.55f;
        }
        return pillarNoise * (1.12f - erosion) < 0.55f;
    }

    private boolean carveTunnels(int worldY, int height, SimplexNoiseCached.DirectionalGenerator tunnelsBig1, SimplexNoiseCached.DirectionalGenerator tunnelsBig2, SimplexNoiseCached.DirectionalGenerator tunnelsSmall1, SimplexNoiseCached.DirectionalGenerator tunnelsSmall2, Vector3d tunnelsBig1Dir, Vector3d tunnelsBig2Dir, Vector3d tunnelsSmall1Dir, Vector3d tunnelsSmall2Dir) {
        double y2;
        double value2;
        double y1 = (double)worldY * 0.0075 * 1.51;
        double value1 = tunnelsBig1.getForY(y1);
        double densityBig = value1 * value1;
        double thresholdBig = 0.017161000000000003;
        if (height < 384) {
            if ((float)worldY > (float)height - 16.0f) {
                thresholdBig *= (double)(8 - (worldY - (height - 16))) / 8.0;
            }
        } else if ((float)worldY > (float)height - 32.0f) {
            thresholdBig *= Math.max((double)0.23f, (double)(32 - (worldY - (height - 32))) / 32.0);
        }
        if (densityBig < thresholdBig && (densityBig += (value2 = tunnelsBig2.getForY(y2 = (double)worldY * 0.0075 * 1.51 + 0.4330127018922193)) * value2) < thresholdBig) {
            tunnelsBig1.getDirection(tunnelsBig1Dir, y1);
            tunnelsBig2.getDirection(tunnelsBig2Dir, y2);
            densityBig += MathUtil.getCaveClosingValue(tunnelsBig1Dir, tunnelsBig2Dir) * (thresholdBig * 10.0);
            if (densityBig < thresholdBig) {
                return true;
            }
        }
        if (thresholdBig > 0.0) {
            double y4;
            double value4;
            double y3 = (double)worldY * 0.0058 * 1.51;
            double value3 = tunnelsSmall1.getForY(y3);
            double densitySmall = value3 * value3;
            double thresholdSmall = thresholdBig * (double)0.35f;
            if ((float)worldY > (float)height - 32.0f) {
                thresholdSmall *= (double)(16 - (worldY - (height - 32))) / 16.0;
            }
            if (densitySmall < thresholdSmall && (densitySmall += (value4 = tunnelsSmall2.getForY(y4 = (double)worldY * 0.0058 * 1.51 + 0.4330127018922193)) * value4) < thresholdSmall) {
                tunnelsSmall1.getDirection(tunnelsSmall1Dir, y3);
                tunnelsSmall2.getDirection(tunnelsSmall2Dir, y4);
                densitySmall += MathUtil.getCaveClosingValue(tunnelsSmall1Dir, tunnelsSmall2Dir) * (thresholdSmall * 12.0);
                if (densitySmall < thresholdSmall) {
                    return true;
                }
            }
        }
        return false;
    }

    private static IStone getStoneType(int worldY, StoneGroup stoneGroup, float igneousHeight, float metamorphicHeight) {
        if ((float)worldY < igneousHeight) {
            return stoneGroup.igneousType;
        }
        if ((float)worldY < metamorphicHeight) {
            return stoneGroup.metamorphicType;
        }
        return stoneGroup.sedimentaryType;
    }

    private BlockState getStone(int worldY, StoneGroup stoneGroup, float igneousHeight, float metamorphicHeight) {
        if ((float)worldY < igneousHeight) {
            return stoneGroup.igneousStone;
        }
        if ((float)worldY < metamorphicHeight) {
            return stoneGroup.metamorphicStone;
        }
        return stoneGroup.sedimentaryStone;
    }

    private BlockState getBlock(int worldY, int height, float elevation, float exposure, float temperature, float humidity, int soilDepth, BlockState soil, BlockState coveredSoil, BlockState water, StoneGroup stoneGroup, float igneousHeight, float metamorphicHeight, int bedrockHeight, int bedrockLayerHeight, WrappedInt lastSurfaceAirHeight, boolean[] pillarsCache, boolean[] cavernsCache, WrappedBool doFluidUpdate, WrappedBool wasAboveTunneled, WrappedInt lastCavernBlock, WrappedInt pillarGaps, WrappedInt pillarGapCount, SimplexNoiseCached.DirectionalGenerator tunnelsBig1, SimplexNoiseCached.DirectionalGenerator tunnelsBig2, SimplexNoiseCached.DirectionalGenerator tunnelsSmall1, SimplexNoiseCached.DirectionalGenerator tunnelsSmall2, Vector3d tunnelsBig1Dir, Vector3d tunnelsBig2Dir, Vector3d tunnelsSmall1Dir, Vector3d tunnelsSmall2Dir) {
        if (worldY < height) {
            if (worldY < bedrockLayerHeight) {
                return worldY >= bedrockHeight ? this.getStone(worldY, stoneGroup, igneousHeight, metamorphicHeight) : BEDROCK;
            }
            if (worldY < 416) {
                boolean isCavern;
                boolean isCached = pillarGaps.val != -1;
                float pillarErosion = 0.0f;
                if (isCached) {
                    isCavern = cavernsCache[worldY];
                } else {
                    float noise;
                    pillarErosion = noise = this.caverns.getForY((double)worldY * 1.65);
                    boolean bl = isCavern = (noise = this.adjustCavernsNoise(noise, worldY, height)) > 0.15f;
                }
                if (isCavern) {
                    boolean firstAir;
                    if (isCached) {
                        firstAir = pillarsCache[worldY];
                    } else {
                        float pillarsNoise = this.pillars.getForY((float)worldY * 0.12f);
                        boolean lastAir = firstAir = this.isPillarAir(pillarsNoise, pillarErosion, worldY);
                        lastCavernBlock.val = wasAboveTunneled.val ? 0 : 2;
                        int gaps = lastAir != wasAboveTunneled.val ? 1 : 0;
                        int yOffset = 1;
                        float cavernsNoiseNext = 1.0f;
                        while (cavernsNoiseNext > 0.12f) {
                            boolean air;
                            int y = worldY - yOffset;
                            if (y < bedrockLayerHeight) {
                                if (!lastAir) break;
                                ++gaps;
                                break;
                            }
                            float pillarErosionNext = cavernsNoiseNext = this.caverns.getForY((double)y * 1.65);
                            if ((cavernsNoiseNext = this.adjustCavernsNoise(cavernsNoiseNext, y, height)) <= 0.15f) {
                                if (lastAir == this.carveTunnels(y, height, tunnelsBig1, tunnelsBig2, tunnelsSmall1, tunnelsSmall2, tunnelsBig1Dir, tunnelsBig2Dir, tunnelsSmall1Dir, tunnelsSmall2Dir)) break;
                                ++gaps;
                                break;
                            }
                            cavernsCache[y] = true;
                            float pillarsNoiseNext = this.pillars.getForY((float)y * 0.12f);
                            pillarsCache[y] = air = this.isPillarAir(pillarsNoiseNext, pillarErosionNext, y);
                            if (lastAir != air) {
                                ++gaps;
                            }
                            lastAir = air;
                            ++yOffset;
                        }
                        pillarGaps.val = gaps;
                        pillarGapCount.val = 0;
                    }
                    if (!firstAir) {
                        if (lastCavernBlock.val < 2) {
                            if (lastCavernBlock.val == 0) {
                                ++pillarGapCount.val;
                            }
                            if (pillarGapCount.val < pillarGaps.val) {
                                lastCavernBlock.val = 1;
                                return worldY > 16 ? CAVE_AIR : LAVA;
                            }
                        }
                        lastCavernBlock.val = 2;
                        return this.getStone(worldY, stoneGroup, igneousHeight, metamorphicHeight);
                    }
                    if (lastCavernBlock.val == 2) {
                        ++pillarGapCount.val;
                    }
                    lastCavernBlock.val = 0;
                    return worldY > 16 ? CAVE_AIR : LAVA;
                }
                pillarGaps.val = -1;
            } else {
                float noise = this.weathering.getForY((double)worldY * 0.79);
                noise = worldY < 448 ? (noise *= (float)(worldY - 416) / 32.0f) : (noise += (float)(worldY - 416 - 32) / 465.0f);
                if (noise > 0.0f && (double)((noise -= (float)(height - worldY) / 150.0f) * Math.abs(exposure)) > 0.085) {
                    lastSurfaceAirHeight.val = worldY;
                    return AIR;
                }
            }
            if (this.carveTunnels(worldY, height, tunnelsBig1, tunnelsBig2, tunnelsSmall1, tunnelsSmall2, tunnelsBig1Dir, tunnelsBig2Dir, tunnelsSmall1Dir, tunnelsSmall2Dir)) {
                wasAboveTunneled.val = true;
                if (worldY > 16) {
                    if (worldY + 1 == lastSurfaceAirHeight.val) {
                        lastSurfaceAirHeight.val = worldY;
                    }
                    return CAVE_AIR;
                }
                return LAVA;
            }
            wasAboveTunneled.val = false;
            if (worldY >= lastSurfaceAirHeight.val - soilDepth) {
                return worldY == lastSurfaceAirHeight.val - 1 ? coveredSoil : soil;
            }
            return this.getStone(worldY, stoneGroup, igneousHeight, metamorphicHeight);
        }
        lastSurfaceAirHeight.val = worldY;
        if (worldY <= 416) {
            if (worldY - 1 < height && height >= 384) {
                doFluidUpdate.val = true;
            }
            return water;
        }
        return AIR;
    }

    private static RegistryObject<Biome> getBiome(int worldY, int height, float elevation, float temperature, float humidity) {
        if (worldY < height && worldY < 384) {
            if (worldY < 128) {
                return BiomesNF.DEPTHS;
            }
            if (worldY < 256) {
                return BiomesNF.CAVERNS;
            }
            return BiomesNF.TUNNELS;
        }
        if (elevation < -0.575f && height > 416) {
            return BiomesNF.ISLAND;
        }
        if (elevation < 0.278f && height <= 416) {
            return BiomesNF.OCEAN;
        }
        if (temperature > 0.7f) {
            if (humidity > 0.7f) {
                return BiomesNF.SWAMP;
            }
            if (humidity > 0.3f) {
                return BiomesNF.BADLANDS;
            }
            return BiomesNF.DESERT;
        }
        if (temperature > 0.3f) {
            if (humidity > 0.7f) {
                return BiomesNF.JUNGLE;
            }
            if (humidity > 0.3f) {
                return BiomesNF.FOREST;
            }
            return BiomesNF.GRASSLANDS;
        }
        if (humidity > 0.7f) {
            return BiomesNF.OLDWOODS;
        }
        if (humidity > 0.3f) {
            return BiomesNF.TAIGA;
        }
        return BiomesNF.TUNDRA;
    }

    public RegistryObject<Biome> calculateBiome(int worldX, int worldY, int worldZ) {
        float elevation = this.elevation.noise2D(worldX, worldZ);
        float roughness = this.roughness.noise2D(worldX, worldZ);
        float detail = this.detail.noise2D(worldX, worldZ);
        int height = this.getHeight(elevation, roughness, detail);
        return ContinentalChunkGenerator.getBiome(worldY, height, elevation, this.getTemperature(worldX, worldZ), this.getHumidity(worldX, worldZ));
    }

    private static int getSoilDepth(int height, float humidity, float exposure) {
        int soilDepth = humidity < 0.3f ? 1 : (humidity < 0.7f ? 2 : 3);
        if (exposure > 0.5f) {
            --soilDepth;
        }
        if (height > 608 && soilDepth > 0) {
            --soilDepth;
        }
        return soilDepth;
    }

    private static int getSoilQuality(int soilDepth, float temperature, float humidity) {
        return temperature < 0.3f && humidity > 0.3f || temperature > 0.7f && humidity < 0.7f ? soilDepth - 1 : soilDepth;
    }

    private static BlockState getSoil(int soilQuality, int height, StoneGroup stoneGroup, float igneousHeight, float metamorphicHeight) {
        if (height < 420) {
            return SOILS.get(ContinentalChunkGenerator.getStoneType(height, stoneGroup, igneousHeight, metamorphicHeight).getSoil());
        }
        return switch (soilQuality) {
            case 1 -> SILT;
            case 2 -> DIRT;
            case 3 -> LOAM;
            default -> SOILS.get(ContinentalChunkGenerator.getStoneType(height, stoneGroup, igneousHeight, metamorphicHeight).getSoil());
        };
    }

    private ChunkAccess fill(ChunkAccess chunk) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        Heightmap oceanMap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldMap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkX = chunkPos.m_45604_();
        int chunkZ = chunkPos.m_45605_();
        SimplexNoiseCached.DirectionalGenerator bigTunnelsGen1 = this.bigTunnels1.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator bigTunnelsGen2 = this.bigTunnels2.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator smallTunnelsGen1 = this.smallTunnels1.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator smallTunnelsGen2 = this.smallTunnels2.directionalGenerator();
        this.pillars.initGenerators(2);
        this.caverns.initGenerators(3);
        this.weathering.initGenerators(4);
        Vector3d bigTunnelsDir1 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d bigTunnelsDir2 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d smallTunnelsDir1 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d smallTunnelsDir2 = new Vector3d(0.0, 0.0, 0.0);
        LevelChunkSection section = chunk.m_183278_(chunk.m_151559_() / 2);
        WrappedBool doFluidUpdate = new WrappedBool(false);
        WrappedBool wasAboveTunneled = new WrappedBool(false);
        WrappedInt lastCavernBlock = new WrappedInt(2);
        WrappedInt pillarGaps = new WrappedInt(-1);
        WrappedInt cavernBlocks = new WrappedInt(0);
        Random rand = new Random(this.seed + ((long)chunkX << 32) + (long)chunkZ);
        for (int x = 0; x < 16; ++x) {
            int worldX = x + chunkX;
            for (int z = 0; z < 16; ++z) {
                SoilCover cover;
                int worldZ = z + chunkZ;
                float elevation = this.elevation.noise2D(worldX, worldZ);
                float roughness = this.roughness.noise2D(worldX, worldZ);
                float detail = this.detail.noise2D(worldX, worldZ);
                int height = this.getHeight(elevation, roughness, detail);
                float exposure = this.exposure.noise2D(worldX, worldZ);
                float temperature = this.getTemperature(worldX, worldZ);
                float humidity = this.getHumidity(worldX, worldZ);
                float stoneType = this.stoneType.noise2D(worldX, worldZ);
                StoneGroup stoneGroup = this.getStoneGroup(temperature, stoneType);
                int bedrockHeight = this.bedrock.noise2D(worldX, worldZ) < 0.0f ? 1 : 2;
                int bedrockLayerHeight = bedrockHeight + (this.bedrockCover.noise2D(worldX, worldZ) < 0.0f ? 1 : 2);
                float igneousHeight = this.getIgneousHeight(worldX, worldZ, height);
                float metamorphicHeight = this.getMetamorphicHeight(worldX, worldZ, height, igneousHeight);
                int soilDepth = ContinentalChunkGenerator.getSoilDepth(height, humidity, exposure);
                int soilQuality = ContinentalChunkGenerator.getSoilQuality(soilDepth, temperature, humidity);
                BlockState soil = ContinentalChunkGenerator.getSoil(soilQuality, height, stoneGroup, igneousHeight, metamorphicHeight);
                Holder biome = (Holder)ContinentalChunkGenerator.getBiome(832, height, elevation, temperature, humidity).getHolder().get();
                float coverTemp = temperature + rand.nextFloat() * 0.025f;
                float coverHumidity = humidity + rand.nextFloat() * 0.025f;
                int coverSoilDepth = ContinentalChunkGenerator.getSoilDepth(height, coverHumidity, exposure);
                int coverSoilQuality = ContinentalChunkGenerator.getSoilQuality(coverSoilDepth, coverTemp, coverHumidity);
                BlockState coveredSoil = ContinentalChunkGenerator.getSoil(coverSoilQuality, height, stoneGroup, igneousHeight, metamorphicHeight);
                if (height < 420) {
                    if (this.clayPatches.noise2D(worldX, worldZ) > 0.77f) {
                        coveredSoil = ((SimpleFireableBlock)BlocksNF.CLAY.get()).m_49966_();
                    } else if (coverSoilQuality >= 2 && this.mudPatches.noise2D(worldX, worldZ) > 0.77f) {
                        coveredSoil = ((UnstableBlock)BlocksNF.MUD.get()).m_49966_();
                    }
                } else if (coverSoilQuality > 0 && (cover = SoilCover.getForBiome((Holder<Biome>)((Holder)ContinentalChunkGenerator.getBiome(832, height, elevation, coverTemp, coverHumidity).getHolder().get()))) != null) {
                    coveredSoil = ((SoilBlock)coveredSoil.m_60734_()).getCoveredBlock(cover);
                }
                BlockState water = biome.m_203565_(BiomesNF.OCEAN.getKey()) ? SEAWATER : WATER;
                double bigX = (double)worldX * 0.0075 + (double)this.bigTunnelsWarp.noise2D(worldX, worldZ) * 0.055;
                double bigZ = (double)worldZ * 0.0075 + (double)this.bigTunnelsWarp.noise2D(worldX, worldZ + 149) * 0.055;
                bigTunnelsGen1.setXZ(bigX, bigZ);
                bigTunnelsGen2.setXZ(bigX, bigZ);
                double smallX = (double)worldX * 0.0075 + (double)this.smallTunnelsWarp.noise2D(worldX, worldZ) * 0.065;
                double smallZ = (double)worldZ * 0.0075 + (double)this.smallTunnelsWarp.noise2D(worldX, worldZ + 149) * 0.065;
                smallTunnelsGen1.setXZ(smallX, smallZ);
                smallTunnelsGen2.setXZ(smallX, smallZ);
                this.caverns.setXZ(worldX, worldZ);
                this.pillars.setXZ(worldX, worldZ);
                this.weathering.setXZ(worldX, worldZ);
                boolean[] pillarsCache = new boolean[416];
                boolean[] cavernsCache = new boolean[416];
                pillarGaps.val = -1;
                wasAboveTunneled.val = false;
                int startHeight = Math.max(416, height - 1);
                WrappedInt lastSurfaceAirHeight = new WrappedInt(startHeight + 1);
                for (int worldY = startHeight; worldY >= 0; --worldY) {
                    BlockState state;
                    int sectionIndex = chunk.m_151564_(worldY);
                    if (chunk.m_151564_(section.m_63017_()) != sectionIndex) {
                        section = chunk.m_183278_(sectionIndex);
                    }
                    if ((state = this.getBlock(worldY, height, elevation, exposure, temperature, humidity, soilDepth, soil, coveredSoil, water, stoneGroup, igneousHeight, metamorphicHeight, bedrockHeight, bedrockLayerHeight, lastSurfaceAirHeight, pillarsCache, cavernsCache, doFluidUpdate, wasAboveTunneled, lastCavernBlock, pillarGaps, cavernBlocks, bigTunnelsGen1, bigTunnelsGen2, smallTunnelsGen1, smallTunnelsGen2, bigTunnelsDir1, bigTunnelsDir2, smallTunnelsDir1, smallTunnelsDir2)) == AIR) continue;
                    if (state.m_60791_() != 0 && chunk instanceof ProtoChunk) {
                        ProtoChunk protoChunk = (ProtoChunk)chunk;
                        blockPos.m_122178_(worldX, worldY, worldZ);
                        protoChunk.m_63277_((BlockPos)blockPos);
                    }
                    section.m_62991_(x, worldY & 0xF, z, state, false);
                    worldMap.m_64249_(x, worldY, z, state);
                    oceanMap.m_64249_(x, worldY, z, state);
                    if (doFluidUpdate.val) {
                        chunk.m_8113_((BlockPos)blockPos.m_122178_(worldX, worldY, worldZ));
                        doFluidUpdate.val = false;
                        continue;
                    }
                    if (worldY != startHeight || !(state.m_60734_() instanceof ITimeSimulatedBlock)) continue;
                    chunk.m_8113_((BlockPos)blockPos.m_122178_(worldX, worldY, worldZ));
                }
            }
        }
        this.caverns.deleteGenerators();
        this.pillars.deleteGenerators();
        this.weathering.deleteGenerators();
        return chunk;
    }

    public int m_6337_() {
        return 416;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_6331_() {
        return 832;
    }

    public int m_142647_(int x, int z, Heightmap.Types pType, LevelHeightAccessor level) {
        return this.iterateNoiseColumn(x, z, null, pType.m_64299_()).orElse(level.m_141937_());
    }

    @NotNull
    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor level) {
        BlockState[] column = new BlockState[832];
        this.iterateNoiseColumn(x, z, column, null);
        return new NoiseColumn(level.m_141937_(), column);
    }

    protected OptionalInt iterateNoiseColumn(int worldX, int worldZ, @Nullable BlockState[] column, @Nullable Predicate<BlockState> stopState) {
        SoilCover cover;
        SimplexNoiseCached.DirectionalGenerator bigTunnelsGen1 = this.bigTunnels1.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator bigTunnelsGen2 = this.bigTunnels2.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator smallTunnelsGen1 = this.smallTunnels1.directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator smallTunnelsGen2 = this.smallTunnels2.directionalGenerator();
        this.pillars.initGenerators(2);
        this.caverns.initGenerators(3);
        this.weathering.initGenerators(4);
        Vector3d bigTunnelsDir1 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d bigTunnelsDir2 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d smallTunnelsDir1 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d smallTunnelsDir2 = new Vector3d(0.0, 0.0, 0.0);
        WrappedBool doFluidUpdate = new WrappedBool(false);
        WrappedBool wasAboveTunneled = new WrappedBool(false);
        WrappedInt lastCavernBlock = new WrappedInt(2);
        WrappedInt pillarGaps = new WrappedInt(-1);
        WrappedInt cavernBlocks = new WrappedInt(0);
        Random rand = new Random(this.seed + ((long)SectionPos.m_123171_((int)worldX) << 32) + (long)SectionPos.m_123171_((int)worldZ));
        float elevation = this.elevation.noise2D(worldX, worldZ);
        float roughness = this.roughness.noise2D(worldX, worldZ);
        float detail = this.detail.noise2D(worldX, worldZ);
        int height = this.getHeight(elevation, roughness, detail);
        float exposure = this.exposure.noise2D(worldX, worldZ);
        float temperature = this.getTemperature(worldX, worldZ);
        float humidity = this.getHumidity(worldX, worldZ);
        float stoneType = this.stoneType.noise2D(worldX, worldZ);
        StoneGroup stoneGroup = this.getStoneGroup(temperature, stoneType);
        int bedrockHeight = this.bedrock.noise2D(worldX, worldZ) < 0.0f ? 1 : 2;
        int bedrockLayerHeight = bedrockHeight + (this.bedrockCover.noise2D(worldX, worldZ) < 0.0f ? 1 : 2);
        float igneousHeight = this.getIgneousHeight(worldX, worldZ, height);
        float metamorphicHeight = this.getMetamorphicHeight(worldX, worldZ, height, igneousHeight);
        int soilDepth = ContinentalChunkGenerator.getSoilDepth(height, humidity, exposure);
        int soilQuality = ContinentalChunkGenerator.getSoilQuality(soilDepth, temperature, humidity);
        BlockState soil = ContinentalChunkGenerator.getSoil(soilQuality, height, stoneGroup, igneousHeight, metamorphicHeight);
        Holder biome = (Holder)ContinentalChunkGenerator.getBiome(832, height, elevation, temperature, humidity).getHolder().get();
        float coverTemp = temperature + rand.nextFloat() * 0.025f;
        float coverHumidity = humidity + rand.nextFloat() * 0.025f;
        int coverSoilDepth = ContinentalChunkGenerator.getSoilDepth(height, coverHumidity, exposure + rand.nextFloat() * 0.0225f);
        int coverSoilQuality = ContinentalChunkGenerator.getSoilQuality(coverSoilDepth, coverTemp, coverHumidity);
        BlockState coveredSoil = ContinentalChunkGenerator.getSoil(coverSoilQuality, height, stoneGroup, igneousHeight, metamorphicHeight);
        if (height < 420) {
            if (this.clayPatches.noise2D(worldX, worldZ) > 0.77f) {
                coveredSoil = ((SimpleFireableBlock)BlocksNF.CLAY.get()).m_49966_();
            } else if (coverSoilQuality >= 2 && this.mudPatches.noise2D(worldX, worldZ) > 0.77f) {
                coveredSoil = ((UnstableBlock)BlocksNF.MUD.get()).m_49966_();
            }
        } else if (coverSoilQuality > 0 && (cover = SoilCover.getForBiome((Holder<Biome>)((Holder)ContinentalChunkGenerator.getBiome(832, height, elevation, coverTemp, coverHumidity).getHolder().get()))) != null) {
            coveredSoil = ((SoilBlock)coveredSoil.m_60734_()).getCoveredBlock(cover);
        }
        BlockState water = biome.m_203565_(BiomesNF.OCEAN.getKey()) ? SEAWATER : WATER;
        double bigX = (double)worldX * 0.0075 + (double)this.bigTunnelsWarp.noise2D(worldX, worldZ) * 0.055;
        double bigZ = (double)worldZ * 0.0075 + (double)this.bigTunnelsWarp.noise2D(worldX, worldZ + 149) * 0.055;
        bigTunnelsGen1.setXZ(bigX, bigZ);
        bigTunnelsGen2.setXZ(bigX, bigZ);
        double smallX = (double)worldX * 0.0075 + (double)this.smallTunnelsWarp.noise2D(worldX, worldZ) * 0.065;
        double smallZ = (double)worldZ * 0.0075 + (double)this.smallTunnelsWarp.noise2D(worldX, worldZ + 149) * 0.065;
        smallTunnelsGen1.setXZ(smallX, smallZ);
        smallTunnelsGen2.setXZ(smallX, smallZ);
        this.caverns.setXZ(worldX, worldZ);
        this.pillars.setXZ(worldX, worldZ);
        this.weathering.setXZ(worldX, worldZ);
        boolean[] pillarsCache = new boolean[416];
        boolean[] cavernsCache = new boolean[416];
        pillarGaps.val = -1;
        wasAboveTunneled.val = false;
        int startHeight = Math.max(416, height - 1);
        WrappedInt lastSurfaceAirHeight = new WrappedInt(startHeight + 1);
        for (int worldY = 831; worldY >= 0; --worldY) {
            BlockState state = this.getBlock(worldY, height, elevation, exposure, temperature, humidity, soilDepth, soil, coveredSoil, water, stoneGroup, igneousHeight, metamorphicHeight, bedrockHeight, bedrockLayerHeight, lastSurfaceAirHeight, pillarsCache, cavernsCache, doFluidUpdate, wasAboveTunneled, lastCavernBlock, pillarGaps, cavernBlocks, bigTunnelsGen1, bigTunnelsGen2, smallTunnelsGen1, smallTunnelsGen2, bigTunnelsDir1, bigTunnelsDir2, smallTunnelsDir1, smallTunnelsDir2);
            if (column != null) {
                column[worldY] = state;
            }
            if (stopState == null || !stopState.test(state)) continue;
            this.caverns.deleteGenerators();
            this.pillars.deleteGenerators();
            this.weathering.deleteGenerators();
            return OptionalInt.of(worldY + 1);
        }
        this.caverns.deleteGenerators();
        this.pillars.deleteGenerators();
        this.weathering.deleteGenerators();
        return OptionalInt.empty();
    }

    public void m_207076_(List<String> info, BlockPos pos) {
        DecimalFormat format = new DecimalFormat("0.000");
        info.add("Terrain: E: " + format.format(this.elevation.noise2D(pos.m_123341_(), pos.m_123343_())) + " R: " + format.format(this.roughness.noise2D(pos.m_123341_(), pos.m_123343_())) + " D: " + format.format(this.detail.noise2D(pos.m_123341_(), pos.m_123343_())) + " EX: " + format.format(this.exposure.noise2D(pos.m_123341_(), pos.m_123343_())));
        info.add("Climate: T: " + format.format(this.getTemperature(pos.m_123341_(), pos.m_123343_())) + " H: " + format.format(this.getHumidity(pos.m_123341_(), pos.m_123343_())));
        info.add("Stone: ST: " + format.format(this.stoneType.noise2D(pos.m_123341_(), pos.m_123343_())) + " IH: " + format.format(this.igneousHeight.noise2D(pos.m_123341_(), pos.m_123343_())) + " MH: " + format.format(this.metamorphicHeight.noise2D(pos.m_123341_(), pos.m_123343_())));
        info.add("Trees: F: " + format.format(this.forestation.noise2D(pos.m_123341_(), pos.m_123343_())) + " 1: " + format.format(this.tree1.noise2D(pos.m_123341_(), pos.m_123343_())) + " 2: " + format.format(this.tree2.noise2D(pos.m_123341_(), pos.m_123343_())) + " 3: " + format.format(this.tree3.noise2D(pos.m_123341_(), pos.m_123343_())) + " 4: " + format.format(this.tree4.noise2D(pos.m_123341_(), pos.m_123343_())));
    }
}

