/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.block.SoilCover;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.DirtBlock;
import frostnox.nightfall.block.block.StoneBlock;
import frostnox.nightfall.registry.forge.BlocksNF;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class FlatChunkGenerator
extends ChunkGenerator {
    public static final Codec<FlatChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> FlatChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_)).apply((Applicative)instance, instance.stable(FlatChunkGenerator::new)));
    private static final BlockState GRASSY_DIRT = ((CoveredSoilBlock)BlocksNF.COVERED_DIRT.get((Object)SoilCover.GRASS).get()).m_49966_();
    private static final BlockState DIRT = ((DirtBlock)BlocksNF.DIRT.get()).m_49966_();
    private static final BlockState SHALE = ((StoneBlock)((Object)BlocksNF.STONE_BLOCKS.get(Stone.SHALE).get())).m_49966_();
    private static final BlockState BEDROCK = ((Block)BlocksNF.BEDROCK.get()).m_49966_();
    private static final NoiseColumn NOISE_COLUMN;

    public FlatChunkGenerator(Registry<StructureSet> structureSets, BiomeSource biomeSource) {
        super(structureSets, Optional.empty(), biomeSource, biomeSource, 0L);
    }

    public int m_142051_(LevelHeightAccessor level) {
        return 417;
    }

    public void m_183372_(WorldGenLevel level, ChunkAccess pChunk, StructureFeatureManager pStructureFeatureManager) {
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long pSeed) {
        return this;
    }

    public Climate.Sampler m_183403_() {
        return Climate.m_207841_();
    }

    public void m_183516_(WorldGenRegion level, long pSeed, BiomeManager pBiomeManager, StructureFeatureManager pStructureFeatureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }

    public void m_183621_(WorldGenRegion level, StructureFeatureManager pStructureFeatureManager, ChunkAccess pChunk) {
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public int m_6337_() {
        return 416;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_6331_() {
        return 832;
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor pExecutor, Blender pBlender, StructureFeatureManager pStructureFeatureManager, ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Heightmap oceanFloorMap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceMap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        for (int y = 0; y <= 416; ++y) {
            BlockState block = y == 0 ? BEDROCK : (y < 414 ? SHALE : (y < 416 ? DIRT : GRASSY_DIRT));
            int worldY = chunk.m_141937_() + y;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    chunk.m_6978_((BlockPos)pos.m_122178_(x, worldY, z), block, false);
                    oceanFloorMap.m_64249_(x, worldY, z, block);
                    worldSurfaceMap.m_64249_(x, worldY, z, block);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_142647_(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor level) {
        return 416;
    }

    public NoiseColumn m_141914_(int pX, int pZ, LevelHeightAccessor level) {
        return NOISE_COLUMN;
    }

    public void m_207076_(List<String> pInfo, BlockPos pos) {
    }

    static {
        BlockState[] column = new BlockState[417];
        for (int y = 0; y <= 416; ++y) {
            column[y] = y == 0 ? BEDROCK : (y < 414 ? SHALE : (y < 416 ? DIRT : GRASSY_DIRT));
        }
        NOISE_COLUMN = new NoiseColumn(0, column);
    }
}

