/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.feature;

import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.block.StoneBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MeteoriteFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState STONE = ((StoneBlock)((Object)BlocksNF.STONE_BLOCKS.get(Stone.MOONSTONE).get())).m_49966_();
    private static final BlockState ORE = ((Block)BlocksNF.METEORITE_ORE.get()).m_49966_();

    public MeteoriteFeature(String name) {
        super(NoneFeatureConfiguration.f_67815_);
        this.setRegistryName(name);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos.MutableBlockPos center = context.m_159777_().m_122032_();
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        while (!level.m_8055_((BlockPos)center).m_204336_(TagsNF.STRUCTURE_REPLACEABLE)) {
            center.m_142448_(center.m_123342_() - 1);
            if (center.m_123342_() > level.m_141937_()) continue;
            return false;
        }
        float f = random.nextFloat();
        int yRad = f < 0.45f ? 2 : (f < 0.85f ? 3 : (f < 0.97f ? 4 : 5));
        center.m_142448_(center.m_123342_() - 1 - random.nextInt(yRad));
        if (center.m_123342_() - yRad <= level.m_141937_() || center.m_123342_() + yRad > level.m_151558_()) {
            return false;
        }
        int xRad = random.nextBoolean() ? yRad + 1 : yRad;
        int zRad = random.nextBoolean() ? yRad + 1 : yRad;
        double xRadSqr = xRad * xRad;
        double yRadSqr = yRad * yRad;
        double zRadSqr = zRad * zRad;
        int xMin = center.m_123341_() - xRad + 1;
        int xMax = center.m_123341_() + xRad - 1;
        int zMin = center.m_123343_() - zRad + 1;
        int zMax = center.m_123343_() + zRad - 1;
        int yMin = center.m_123342_() - yRad + 1;
        int yMax = center.m_123342_() + yRad - 1;
        if (Math.abs(center.m_123342_() - level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xMin, zMin)) >= yRad - 1) {
            return false;
        }
        if (Math.abs(center.m_123342_() - level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xMax, zMin)) >= yRad - 1) {
            return false;
        }
        if (Math.abs(center.m_123342_() - level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xMin, zMax)) >= yRad - 1) {
            return false;
        }
        if (Math.abs(center.m_123342_() - level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xMax, zMax)) >= yRad - 1) {
            return false;
        }
        int sectionX = SectionPos.m_123171_((int)center.m_123341_());
        int sectionZ = SectionPos.m_123171_((int)center.m_123343_());
        ChunkAccess chunk = level.m_6325_(sectionX, sectionZ);
        int sectionIndex = chunk.m_151564_(center.m_123342_());
        LevelChunkSection section = chunk.m_183278_(sectionIndex);
        Heightmap motionBlockingMap = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING);
        Heightmap noLeavesMotionBlockingMap = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        Heightmap oceanMap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR);
        Heightmap worldMap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE);
        for (int x = xMin; x <= xMax; ++x) {
            int xDist = center.m_123341_() - x;
            double xFactor = (double)(xDist * xDist) / xRadSqr;
            boolean maybeSkipX = x == xMin || x == xMax;
            int newSectionX = SectionPos.m_123171_((int)x);
            boolean newChunk = false;
            if (newSectionX != sectionX) {
                sectionX = newSectionX;
                newChunk = true;
            }
            int localX = x & 0xF;
            for (int z = zMin; z <= zMax; ++z) {
                boolean maybeSkipZ = z == zMin || z == zMax;
                int zDist = center.m_123343_() - z;
                double xzFactor = xFactor + (double)(zDist * zDist) / zRadSqr;
                if (xzFactor > 1.0) continue;
                int newSectionZ = SectionPos.m_123171_((int)z);
                if (newSectionZ != sectionZ) {
                    sectionZ = newSectionZ;
                    newChunk = true;
                }
                int localZ = z & 0xF;
                for (int y = yMin; y <= yMax; ++y) {
                    int localY;
                    int yDist;
                    double dist;
                    if (maybeSkipX && maybeSkipZ && (y == yMin || y == yMax) || (dist = xzFactor + (double)((yDist = center.m_123342_() - y) * yDist) / yRadSqr) > 1.0 || dist >= 0.8 && random.nextInt(3) == 0) continue;
                    int newSectionIndex = chunk.m_151564_(y);
                    if (newSectionIndex != sectionIndex || newChunk) {
                        if (newChunk) {
                            chunk = level.m_6325_(sectionX, sectionZ);
                            newChunk = false;
                            motionBlockingMap = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING);
                            noLeavesMotionBlockingMap = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
                            oceanMap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR);
                            worldMap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE);
                        }
                        sectionIndex = newSectionIndex;
                        section = chunk.m_183278_(sectionIndex);
                    }
                    if (!section.m_62982_(localX, localY = y & 0xF, localZ).m_204336_(TagsNF.STRUCTURE_REPLACEABLE)) continue;
                    section.m_62991_(localX, localY, localZ, dist <= 0.2 && random.nextBoolean() ? ORE : STONE, false);
                    motionBlockingMap.m_64249_(localX, y, localZ, STONE);
                    noLeavesMotionBlockingMap.m_64249_(localX, y, localZ, STONE);
                    oceanMap.m_64249_(localX, y, localZ, STONE);
                    worldMap.m_64249_(localX, y, localZ, STONE);
                }
            }
        }
        return true;
    }
}

