/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3d;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.math.noise.SimplexNoiseCached;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class OreVeinFeature
extends Feature<Configuration> {
    public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.listOf().fieldOf("oreKeys").forGetter(config -> config.oreKeys), (App)BlockState.f_61039_.listOf().fieldOf("oreValues").forGetter(config -> config.oreValues), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(config -> config.threshold), (App)ExtraCodecs.f_184349_.fieldOf("richnessBase").forGetter(config -> Float.valueOf(config.richnessBase)), (App)ExtraCodecs.f_184349_.fieldOf("richnessRand").forGetter(config -> Float.valueOf(config.richnessRand)), (App)ExtraCodecs.f_144629_.fieldOf("xzRadBase").forGetter(config -> config.xzRadBase), (App)ExtraCodecs.f_144629_.fieldOf("xzRadRand").forGetter(config -> config.xzRadRand), (App)ExtraCodecs.f_144629_.fieldOf("yRadBase").forGetter(config -> config.yRadBase), (App)ExtraCodecs.f_144629_.fieldOf("yRadRand").forGetter(config -> config.yRadRand), (App)Codec.DOUBLE.fieldOf("xzFreq").forGetter(config -> config.xzFreq), (App)Codec.DOUBLE.fieldOf("yFreq").forGetter(config -> config.yFreq)).apply((Applicative)instance, Configuration::new));
    protected static final Map<Configuration, Pair<SimplexNoiseCached, SimplexNoiseCached>> NOISE = new Object2ObjectArrayMap();
    protected long levelSeed;

    public OreVeinFeature(String name) {
        super(CODEC);
        this.setRegistryName(name);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        int sectionZ;
        int sectionX;
        ChunkAccess chunk;
        Pair noisePair;
        Configuration config = (Configuration)context.m_159778_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Random random = context.m_159776_();
        if (level.m_7328_() != this.levelSeed) {
            NOISE.clear();
            this.levelSeed = level.m_7328_();
        }
        if ((noisePair = NOISE.get(config)) == null) {
            noisePair = Pair.of((Object)new SimplexNoiseCached(random.nextLong()), (Object)new SimplexNoiseCached(random.nextLong()));
            NOISE.put(config, (Pair<SimplexNoiseCached, SimplexNoiseCached>)noisePair);
        }
        if ((chunk = level.m_6325_(sectionX = SectionPos.m_123171_((int)origin.m_123341_()), sectionZ = SectionPos.m_123171_((int)origin.m_123343_()))).m_151562_(origin.m_123342_())) {
            return false;
        }
        int sectionIndex = chunk.m_151564_(origin.m_123342_());
        LevelChunkSection section = chunk.m_183278_(sectionIndex);
        if (section.m_188008_()) {
            return false;
        }
        int xRad = config.xzRadBase + random.nextInt(config.xzRadRand);
        double xRadSqr = xRad * xRad;
        int yRad = config.yRadBase + random.nextInt(config.yRadRand);
        double yRadSqr = yRad * yRad;
        int zRad = config.xzRadBase + random.nextInt(config.xzRadRand);
        double zRadSqr = zRad * zRad;
        int minX = origin.m_123341_() - xRad;
        int minZ = origin.m_123343_() - zRad;
        int minY = Math.max(origin.m_123342_() - yRad, level.m_141937_());
        int maxX = origin.m_123341_() + xRad;
        int maxZ = origin.m_123343_() + zRad;
        int maxY = Math.min(origin.m_123342_() + yRad, level.m_151558_() - 1);
        float richness = config.richnessBase + config.richnessRand * random.nextFloat();
        SimplexNoiseCached.DirectionalGenerator noiseGen1 = ((SimplexNoiseCached)noisePair.left()).directionalGenerator();
        SimplexNoiseCached.DirectionalGenerator noiseGen2 = ((SimplexNoiseCached)noisePair.right()).directionalGenerator();
        Vector3d noise1Dir = new Vector3d(0.0, 0.0, 0.0);
        Vector3d noise2Dir = new Vector3d(0.0, 0.0, 0.0);
        for (int x = minX; x <= maxX; ++x) {
            int xDist = origin.m_123341_() - x;
            double xFactor = (double)(xDist * xDist) / xRadSqr;
            double noiseX = (double)x * config.xzFreq;
            int newSectionX = SectionPos.m_123171_((int)x);
            boolean newChunk = false;
            if (newSectionX != sectionX) {
                sectionX = newSectionX;
                newChunk = true;
            }
            int localX = x & 0xF;
            block1: for (int z = minZ; z <= maxZ; ++z) {
                int zDist = origin.m_123343_() - z;
                double zFactor = (double)(zDist * zDist) / zRadSqr;
                double xzFactor = xFactor + zFactor;
                if (xzFactor > 1.0) continue;
                double noiseZ = (double)z * config.xzFreq;
                int newSectionZ = SectionPos.m_123171_((int)z);
                if (newSectionZ != sectionZ) {
                    sectionZ = newSectionZ;
                    newChunk = true;
                }
                int localZ = z & 0xF;
                noiseGen1.setXZ(noiseX, noiseZ);
                noiseGen2.setXZ(noiseX, noiseZ);
                int surfaceY = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, localX, localZ);
                for (int y = minY; y <= maxY; ++y) {
                    double noise2Y;
                    double val2;
                    double noise1Y;
                    double val1;
                    double density;
                    int localY;
                    int index;
                    if (y < chunk.m_141937_()) continue;
                    if (y >= chunk.m_151558_() || y >= surfaceY) continue block1;
                    int yDist = origin.m_123342_() - y;
                    if (xzFactor + (double)(yDist * yDist) / yRadSqr > 1.0 || random.nextFloat() > richness) continue;
                    int newSectionIndex = chunk.m_151564_(y);
                    if (newSectionIndex != sectionIndex || newChunk) {
                        if (newChunk) {
                            chunk = level.m_6325_(sectionX, sectionZ);
                            newChunk = false;
                        }
                        sectionIndex = newSectionIndex;
                        section = chunk.m_183278_(sectionIndex);
                    }
                    if ((index = config.oreKeys.indexOf(section.m_62982_(localX, localY = y & 0xF, localZ))) == -1 || !((density = (val1 = noiseGen1.getForY(noise1Y = (double)y * config.yFreq)) * val1) < config.threshold) || !((density += (val2 = noiseGen2.getForY(noise2Y = noise1Y + 0.4330127018922193)) * val2) < config.threshold)) continue;
                    noiseGen1.getDirection(noise1Dir, noise1Y);
                    noiseGen2.getDirection(noise2Dir, noise2Y);
                    density += MathUtil.getCaveClosingValue(noise1Dir, noise2Dir) * config.threshold * 8.0;
                    if (!(density < config.threshold)) continue;
                    section.m_62991_(localX, localY, localZ, config.oreValues.get(index), false);
                }
            }
        }
        return true;
    }

    public record Configuration(List<BlockState> oreKeys, List<BlockState> oreValues, double threshold, float richnessBase, float richnessRand, int xzRadBase, int xzRadRand, int yRadBase, int yRadRand, double xzFreq, double yFreq) implements FeatureConfiguration
    {
    }
}

