/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.feature;

import frostnox.nightfall.block.block.nest.GuardedNestBlockEntity;
import frostnox.nightfall.block.block.nest.NestBlockEntity;
import frostnox.nightfall.block.block.nest.SpiderNestBlock;
import frostnox.nightfall.entity.entity.monster.SpiderEntity;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SpiderNestFeature
extends Feature<NoneFeatureConfiguration> {
    public SpiderNestFeature(String name) {
        super(NoneFeatureConfiguration.f_67815_);
        this.setRegistryName(name);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        if (!level.m_46859_(pos) || !level.m_8055_(pos.m_7495_()).m_60767_().m_76334_()) {
            return false;
        }
        ObjectArrayList directions = new ObjectArrayList((Object[])LevelUtil.HORIZONTAL_DIRECTIONS);
        Collections.shuffle(directions, context.m_159776_());
        Direction exitDirection = null;
        SpiderEntity testSpider = (SpiderEntity)((EntityType)EntitiesNF.SPIDER.get()).m_20615_((Level)level.m_6018_());
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (Direction direction : directions) {
            mutablePos.m_122178_(pos.m_123341_() + direction.m_122429_(), pos.m_123342_(), pos.m_123343_() + direction.m_122431_());
            testSpider.m_6027_((double)mutablePos.m_123341_() + 0.5, mutablePos.m_123342_(), (double)mutablePos.m_123343_() + 0.5);
            if (!NestBlockEntity.canPlaceEntityAt((Entity)testSpider, (BlockPos)mutablePos, (BlockGetter)level)) continue;
            exitDirection = direction;
            break;
        }
        if (exitDirection == null) {
            return false;
        }
        ContinentalChunkGenerator gen = (ContinentalChunkGenerator)context.m_159775_();
        ChunkPos chunkPos = new ChunkPos(context.m_159777_());
        level.m_7731_(pos, ((SpiderNestBlock)BlocksNF.SPIDER_NEST.get()).m_49966_(), 20);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GuardedNestBlockEntity) {
            GuardedNestBlockEntity nest = (GuardedNestBlockEntity)blockEntity;
            level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_8113_(pos);
            while (nest.canRespawn()) {
                SpiderEntity spider = (SpiderEntity)((EntityType)EntitiesNF.SPIDER.get()).m_20615_((Level)level.m_6018_());
                spider.setHomePos(pos);
                spider.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.STRUCTURE, (SpawnGroupData)SpiderEntity.GroupData.create(gen.getCachedHumidity(chunkPos)), null);
                if (nest.scout == null) {
                    spider.isScout = true;
                    nest.scout = spider.m_142081_();
                    nest.startTrackingEntity(spider.m_142081_());
                    spider.m_20035_(pos.m_142300_(exitDirection), exitDirection.m_122435_() % 360.0f, 0.0f);
                    spider.m_5618_(spider.m_146908_());
                    spider.m_5616_(spider.m_146908_());
                    level.m_7967_((Entity)spider);
                    spider.m_146922_(spider.m_146908_());
                    continue;
                }
                nest.addEntity((Entity)spider);
            }
            ((SpiderNestBlock)BlocksNF.SPIDER_NEST.get()).growWebs(level, pos, 8);
        }
        return true;
    }
}

