/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.util.math.OctalDirection;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class AdjacentScanPlacement
extends PlacementModifier {
    private final BlockPredicate targetCondition;
    private final boolean avoid;
    public static final Codec<AdjacentScanPlacement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPredicate.f_190392_.fieldOf("target_condition").forGetter(placement -> placement.targetCondition), (App)Codec.BOOL.fieldOf("avoid").forGetter(placement -> placement.avoid)).apply((Applicative)builder, AdjacentScanPlacement::new));

    private AdjacentScanPlacement(BlockPredicate targetCondition, boolean avoid) {
        this.targetCondition = targetCondition;
        this.avoid = avoid;
    }

    public static AdjacentScanPlacement of(BlockPredicate pTargetCondition, boolean avoid) {
        return new AdjacentScanPlacement(pTargetCondition, avoid);
    }

    public Stream<BlockPos> m_183381_(PlacementContext pContext, Random pRandom, BlockPos pos) {
        BlockPos.MutableBlockPos adjPos = pos.m_122032_();
        WorldGenLevel level = pContext.m_191831_();
        for (OctalDirection dir : OctalDirection.OCTALS) {
            adjPos.m_142451_(pos.m_123341_() + dir.xStepInt);
            adjPos.m_142443_(pos.m_123343_() + dir.zStepInt);
            if (!this.targetCondition.test((Object)level, (Object)adjPos.m_142448_(pos.m_123342_())) && !this.targetCondition.test((Object)level, (Object)adjPos.m_142448_(pos.m_123342_() + 1))) continue;
            return this.avoid ? Stream.of(new BlockPos[0]) : Stream.of(pos);
        }
        return this.avoid ? Stream.of(pos) : Stream.of(new BlockPos[0]);
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.ADJACENT_SCAN_PLACEMENT;
    }
}

