/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ElevationPreciseFilter
extends PlacementFilter {
    public static final Codec<ElevationPreciseFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("elevationMin").forGetter(placement -> Float.valueOf(placement.elevationMin)), (App)Codec.FLOAT.fieldOf("elevationMax").forGetter(placement -> Float.valueOf(placement.elevationMax))).apply((Applicative)instance, ElevationPreciseFilter::new));
    private final float elevationMin;
    private final float elevationMax;

    private ElevationPreciseFilter(float elevationMin, float elevationMax) {
        this.elevationMin = elevationMin;
        this.elevationMax = elevationMax;
    }

    public static ElevationPreciseFilter with(float elevationMin, float elevationMax) {
        return new ElevationPreciseFilter(elevationMin, elevationMax);
    }

    protected boolean m_183168_(PlacementContext pContext, Random random, BlockPos pos) {
        float elevation = ((ContinentalChunkGenerator)pContext.m_191833_()).getElevation(pos.m_123341_(), pos.m_123343_());
        return elevation >= this.elevationMin && elevation <= this.elevationMax;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.ELEVATION_PRECISE_FILTER;
    }
}

