/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ExposureChanceFilter
extends PlacementFilter {
    public static final Codec<ExposureChanceFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_184349_.fieldOf("chance").forGetter(placement -> Float.valueOf(placement.chance)), (App)ExtraCodecs.f_184349_.fieldOf("minChance").forGetter(placement -> Float.valueOf(placement.minChance))).apply((Applicative)instance, ExposureChanceFilter::new));
    private final float chance;
    private final float minChance;

    protected ExposureChanceFilter(float chance, float minChance) {
        this.chance = chance;
        this.minChance = minChance;
    }

    public static ExposureChanceFilter with(float chance, float minChance) {
        return new ExposureChanceFilter(chance, minChance);
    }

    protected boolean m_183168_(PlacementContext pContext, Random random, BlockPos pos) {
        ContinentalChunkGenerator gen = (ContinentalChunkGenerator)pContext.m_191833_();
        return random.nextFloat() < Math.max(this.minChance, gen.getCachedExposure(new ChunkPos(pos)) * this.chance);
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.EXPOSURE_CHANCE_FILTER;
    }
}

