/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.placement.NoiseCountPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ExposureCountPlacement
extends NoiseCountPlacement {
    public static final Codec<ExposureCountPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("count").forGetter(placement -> Float.valueOf(placement.count)), (App)Codec.INT.fieldOf("min").forGetter(placement -> placement.min)).apply((Applicative)instance, ExposureCountPlacement::new));

    private ExposureCountPlacement(float count, int min) {
        super(count, min);
    }

    @Override
    protected float getScalar(ContinentalChunkGenerator gen, BlockPos pos) {
        return gen.getCachedExposure(new ChunkPos(pos)) + 0.5f;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.EXPOSURE_COUNT_PLACEMENT;
    }

    public static ExposureCountPlacement of(float count) {
        return new ExposureCountPlacement(count, 0);
    }

    public static ExposureCountPlacement of(float count, int min) {
        return new ExposureCountPlacement(count, min);
    }
}

