/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.placement.NoiseCountPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ForestationCountPlacement
extends NoiseCountPlacement {
    public static final Codec<ForestationCountPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("count").forGetter(placement -> Float.valueOf(placement.count)), (App)Codec.INT.fieldOf("min").forGetter(placement -> placement.min)).apply((Applicative)instance, ForestationCountPlacement::new));

    protected ForestationCountPlacement(float count, int min) {
        super(count, min);
    }

    @Override
    protected float getScalar(ContinentalChunkGenerator gen, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        float humidity = gen.getCachedHumidity(chunkPos) * 0.65f;
        float temperature = (1.0f - Math.abs(gen.getCachedTemperature(chunkPos) - 0.5f) * 2.0f) * 0.35f;
        return Easing.inOutSine.apply(humidity + temperature) + gen.getForestation(pos.m_123341_(), pos.m_123343_()) * 0.3f;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.FORESTATION_COUNT_PLACEMENT;
    }

    public static ForestationCountPlacement of(float count) {
        return new ForestationCountPlacement(count, 0);
    }

    public static ForestationCountPlacement of(float count, int min) {
        return new ForestationCountPlacement(count, min);
    }
}

