/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RectangleClimateFilter
extends PlacementFilter {
    public static final Codec<RectangleClimateFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("tempMin").forGetter(placement -> Float.valueOf(placement.tempMin)), (App)Codec.FLOAT.fieldOf("tempMax").forGetter(placement -> Float.valueOf(placement.tempMax)), (App)Codec.FLOAT.fieldOf("humidityMin").forGetter(placement -> Float.valueOf(placement.humidityMin)), (App)Codec.FLOAT.fieldOf("humidityMax").forGetter(placement -> Float.valueOf(placement.humidityMax))).apply((Applicative)instance, RectangleClimateFilter::new));
    private final float tempMin;
    private final float tempMax;
    private final float humidityMin;
    private final float humidityMax;

    private RectangleClimateFilter(float tempMin, float tempMax, float humidityMin, float humidityMax) {
        this.tempMin = tempMin;
        this.tempMax = tempMax;
        this.humidityMin = humidityMin;
        this.humidityMax = humidityMax;
    }

    public static RectangleClimateFilter with(float tempMin, float tempMax, float humidityMin, float humidityMax) {
        return new RectangleClimateFilter(tempMin, tempMax, humidityMin, humidityMax);
    }

    protected boolean m_183168_(PlacementContext pContext, Random random, BlockPos pos) {
        ChunkPos chunkPos;
        ContinentalChunkGenerator gen = (ContinentalChunkGenerator)pContext.m_191833_();
        float temp = gen.getCachedTemperature(chunkPos = new ChunkPos(pos));
        if (temp >= this.tempMin && temp <= this.tempMax) {
            float humidity = gen.getCachedHumidity(chunkPos);
            return humidity >= this.humidityMin && humidity <= this.humidityMax;
        }
        return false;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.RECTANGLE_CLIMATE_FILTER;
    }
}

