/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import frostnox.nightfall.registry.vanilla.PlacementModifierTypesNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SurfaceHeightFilter
extends PlacementFilter {
    public static final Codec<SurfaceHeightFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("minY").forGetter(placement -> placement.minY), (App)Codec.INT.fieldOf("maxY").forGetter(placement -> placement.maxY)).apply((Applicative)instance, SurfaceHeightFilter::new));
    private final int minY;
    private final int maxY;

    private SurfaceHeightFilter(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    public static SurfaceHeightFilter with(int minY, int maxY) {
        return new SurfaceHeightFilter(minY, maxY);
    }

    protected boolean m_183168_(PlacementContext pContext, Random random, BlockPos pos) {
        int y = pContext.m_191824_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_(), pos.m_123343_());
        return y >= this.minY && y <= this.maxY;
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifierTypesNF.SURFACE_HEIGHT_FILTER;
    }
}

