/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.structure;

import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.block.SidingBlock;
import frostnox.nightfall.block.block.SlabBlockNF;
import frostnox.nightfall.block.block.StairBlockNF;
import frostnox.nightfall.block.block.strangesoil.StrangeSoilBlock;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.StructuresNF;
import frostnox.nightfall.registry.vanilla.LootTablesNF;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.structure.StructurePieceNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class CottageRuinsPiece
extends StructurePieceNF {
    public static final int X_SIZE = 10;
    public static final int Z_SIZE = 10;
    protected static FractalSimplexNoiseFast heightNoise;
    protected long lastSeed;

    public CottageRuinsPiece(int x, int z) {
        super(StructuresNF.COTTAGE_RUINS_PIECE, 0, CottageRuinsPiece.m_163541_((int)x, (int)0, (int)z, (Direction)Direction.SOUTH, (int)10, (int)2, (int)10));
        this.m_73519_(Direction.SOUTH);
    }

    public CottageRuinsPiece(CompoundTag pTag) {
        super(StructuresNF.COTTAGE_RUINS_PIECE, pTag);
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag pTag) {
    }

    public void m_183269_(WorldGenLevel level, StructureFeatureManager pStructureFeatureManager, ChunkGenerator gen, Random random, BoundingBox box, ChunkPos pChunkPos, BlockPos centerPos) {
        int z;
        int y;
        int floorY;
        float height;
        int worldZ;
        int worldX;
        int x;
        int doorX;
        Soil soil;
        Stone stone;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        long seed = level.m_7328_();
        if (heightNoise == null || this.lastSeed != seed) {
            heightNoise = new FractalSimplexNoiseFast(seed, 0.085f, 2, 0.5f, 2.0f);
            this.lastSeed = seed;
        }
        BoundingBox surfaceBox = this.getSurfaceBox(level, box);
        int xSize = 5 + random.nextInt(6);
        int zSize = 5 + random.nextInt(6);
        int xHalf1 = xSize / 2;
        int xHalf2 = xSize % 2 == 0 ? xHalf1 : xSize / 2 + 1;
        int zHalf1 = zSize / 2;
        int zHalf2 = zSize % 2 == 0 ? zHalf1 : zSize / 2 + 1;
        int xEdge1 = 10 - xHalf1;
        int xEdge2 = 10 + xHalf2;
        int zEdge1 = 10 - zHalf1;
        int zEdge2 = 10 + zHalf2;
        if (gen instanceof ContinentalChunkGenerator) {
            ContinentalChunkGenerator contGen = (ContinentalChunkGenerator)gen;
            BlockPos center = pChunkPos.m_151394_(surfaceBox.m_162396_());
            stone = contGen.getCachedSurfaceStone(center);
            soil = contGen.getCachedSoil(center);
        } else {
            stone = Stone.SHALE;
            soil = Soil.DIRT;
        }
        int doorZ = switch (random.nextInt(4)) {
            case 0 -> {
                doorX = 10;
                yield zEdge1;
            }
            case 1 -> {
                doorX = 10;
                yield zEdge2;
            }
            case 2 -> {
                doorX = xEdge1;
                yield 10;
            }
            default -> {
                doorX = xEdge2;
                yield 10;
            }
        };
        for (x = 10 - xHalf1 + 1; x <= 10 + xHalf2 - 1; ++x) {
            worldX = this.m_73392_(x, zEdge1);
            worldZ = this.m_73525_(x, zEdge1);
            height = CottageRuinsPiece.getHeight(worldX, worldZ);
            floorY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ);
            pos.m_142451_(worldX).m_142443_(worldZ);
            for (y = 0; y <= (doorX == x && doorZ == zEdge1 ? 0 : Mth.m_14167_((float)height)); ++y) {
                this.placeBlock(level, CottageRuinsPiece.pickBlock(stone, y, height, random), (BlockPos)pos.m_142448_(floorY + y - 1), surfaceBox, y == 1);
            }
        }
        for (x = 10 - xHalf1 + 1; x <= 10 + xHalf2 - 1; ++x) {
            worldX = this.m_73392_(x, zEdge2);
            worldZ = this.m_73525_(x, zEdge2);
            height = CottageRuinsPiece.getHeight(worldX, worldZ);
            floorY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ);
            pos.m_142451_(worldX).m_142443_(worldZ);
            for (y = 0; y <= (doorX == x && doorZ == zEdge2 ? 0 : Mth.m_14167_((float)height)); ++y) {
                this.placeBlock(level, CottageRuinsPiece.pickBlock(stone, y, height, random), (BlockPos)pos.m_142448_(floorY + y - 1), surfaceBox, y == 1);
            }
        }
        for (z = 10 - zHalf1 + 1; z <= 10 + zHalf2 - 1; ++z) {
            worldX = this.m_73392_(xEdge1, z);
            worldZ = this.m_73525_(xEdge1, z);
            height = CottageRuinsPiece.getHeight(worldX, worldZ);
            floorY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ);
            pos.m_142451_(worldX).m_142443_(worldZ);
            for (y = 0; y <= (doorX == xEdge1 && doorZ == z ? 0 : Mth.m_14167_((float)height)); ++y) {
                this.placeBlock(level, CottageRuinsPiece.pickBlock(stone, y, height, random), (BlockPos)pos.m_142448_(floorY + y - 1), surfaceBox, y == 1);
            }
        }
        for (z = 10 - zHalf1 + 1; z <= 10 + zHalf2 - 1; ++z) {
            worldX = this.m_73392_(xEdge2, z);
            worldZ = this.m_73525_(xEdge2, z);
            height = CottageRuinsPiece.getHeight(worldX, worldZ);
            floorY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ);
            pos.m_142451_(worldX).m_142443_(worldZ);
            for (y = 0; y <= (doorX == xEdge2 && doorZ == z ? 0 : Mth.m_14167_((float)height)); ++y) {
                this.placeBlock(level, CottageRuinsPiece.pickBlock(stone, y, height, random), (BlockPos)pos.m_142448_(floorY + y - 1), surfaceBox, y == 1);
            }
        }
        BlockState strangeSoil = ((StrangeSoilBlock)BlocksNF.STRANGE_SOILS.get(soil).get()).m_49966_();
        for (int i = 0; i < (xSize * zSize >= 60 ? 2 : 1); ++i) {
            int soilX;
            int soilZ = switch (random.nextInt(4)) {
                case 0 -> {
                    soilX = 10 - xHalf1 + 1 + random.nextInt(xSize - 1);
                    yield zEdge1 + 1;
                }
                case 1 -> {
                    soilX = 10 - xHalf1 + 1 + random.nextInt(xSize - 1);
                    yield zEdge2 - 1;
                }
                case 2 -> {
                    soilX = xEdge1 + 1;
                    yield 10 - zHalf1 + 1 + random.nextInt(zSize - 1);
                }
                default -> {
                    soilX = xEdge2 - 1;
                    yield 10 - zHalf1 + 1 + random.nextInt(zSize - 1);
                }
            };
            this.placeStrangeSoil(level, this.adjustBoxMinY(surfaceBox, -2), random, (BlockPos)pos.m_122178_(this.m_73392_(soilX, soilZ), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_73392_(soilX, soilZ), this.m_73525_(soilX, soilZ)) - 2, this.m_73525_(soilX, soilZ)), strangeSoil, LootTablesNF.COTTAGE_RUINS_LOOT);
        }
    }

    private static float getHeight(int worldX, int worldZ) {
        return Math.abs(heightNoise.noise2D(worldX, worldZ)) * 1.6f;
    }

    private static BlockState pickBlock(Stone stone, int y, float height, Random random) {
        if (y < (int)height + 1) {
            float f = random.nextFloat();
            float f2 = y == 0 ? 0.05f : 0.1f;
            if (f < f2) {
                return (BlockState)((SidingBlock)BlocksNF.STACKED_STONE_SIDINGS.get(stone).get()).m_49966_().m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.values()[random.nextInt(4)]));
            }
            float f3 = y == 0 ? 0.15f : 0.3f;
            if (f < f3) {
                return (BlockState)((BlockState)((StairBlockNF)BlocksNF.STACKED_STONE_STAIRS.get(stone).get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random))).m_61124_((Property)StairBlock.f_56842_, (Comparable)(random.nextBoolean() ? Half.BOTTOM : Half.TOP));
            }
            return ((Block)BlocksNF.STACKED_STONE.get(stone).get()).m_49966_();
        }
        float fraction = height % 1.0f;
        if (fraction < 0.5f) {
            return ((SlabBlockNF)BlocksNF.STACKED_STONE_SLABS.get(stone).get()).m_49966_();
        }
        return (BlockState)((StairBlockNF)BlocksNF.STACKED_STONE_STAIRS.get(stone).get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
    }
}

