/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.structure;

import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.LogBlock;
import frostnox.nightfall.block.block.barrel.BarrelBlockNF;
import frostnox.nightfall.block.block.fuel.HorizontalFuelBlock;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.StructuresNF;
import frostnox.nightfall.registry.vanilla.LootTablesNF;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.TreePool;
import frostnox.nightfall.world.generation.structure.StructurePieceNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class DesertedCampPiece
extends StructurePieceNF {
    public static final int SIZE = 9;

    public DesertedCampPiece(Random random, int x, int z) {
        this(x, z, DesertedCampPiece.m_163580_((Random)random));
    }

    public DesertedCampPiece(int x, int z, Direction orientation) {
        super(StructuresNF.DESERTED_CAMP_PIECE, 0, DesertedCampPiece.m_163541_((int)x, (int)0, (int)z, (Direction)orientation, (int)9, (int)3, (int)9));
        this.m_73519_(orientation);
    }

    public DesertedCampPiece(CompoundTag pTag) {
        super(StructuresNF.DESERTED_CAMP_PIECE, pTag);
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag pTag) {
    }

    public void m_183269_(WorldGenLevel level, StructureFeatureManager pStructureFeatureManager, ChunkGenerator gen, Random random, BoundingBox box, ChunkPos pChunkPos, BlockPos centerPos) {
        int breachX;
        Stone stone;
        Tree tree;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BoundingBox surfaceBox = this.getSurfaceBox(level, box);
        if (gen instanceof ContinentalChunkGenerator) {
            ContinentalChunkGenerator contGen = (ContinentalChunkGenerator)gen;
            TreePool pool = contGen.getCachedTreePool(pChunkPos);
            tree = pool.trees()[0] == null ? Tree.OAK : pool.trees()[0].tree();
            stone = contGen.getCachedSurfaceStone(surfaceBox.m_162394_());
        } else {
            tree = Tree.OAK;
            stone = Stone.SHALE;
        }
        BlockState log = ((LogBlock)((Object)BlocksNF.LOGS.get(tree).get())).m_49966_();
        BlockState stackedStone = ((Block)BlocksNF.STACKED_STONE.get(stone).get()).m_49966_();
        int breachZ = switch (random.nextInt(4)) {
            case 0 -> {
                breachX = 3 + random.nextInt(3);
                yield 0;
            }
            case 1 -> {
                breachX = 3 + random.nextInt(3);
                yield 8;
            }
            case 2 -> {
                breachX = 0;
                yield 3 + random.nextInt(3);
            }
            default -> {
                breachX = 8;
                yield 3 + random.nextInt(3);
            }
        };
        for (int i = 2; i < 7; ++i) {
            int height;
            int n = height = i % 2 == 0 ? 3 : 2;
            if (i != 4) {
                this.placeEdge(level, log, pos, i, height, 0, breachX, breachZ, surfaceBox);
            }
            this.placeEdge(level, log, pos, i, height, 8, breachX, breachZ, surfaceBox);
            this.placeEdge(level, log, pos, 0, height, i, breachX, breachZ, surfaceBox);
            this.placeEdge(level, log, pos, 8, height, i, breachX, breachZ, surfaceBox);
        }
        this.stackSurfaceBlocks(level, log, pos, 1, 2, 1, surfaceBox);
        this.stackSurfaceBlocks(level, log, pos, 7, 2, 1, surfaceBox);
        this.stackSurfaceBlocks(level, log, pos, 1, 2, 7, surfaceBox);
        this.stackSurfaceBlocks(level, log, pos, 7, 2, 7, surfaceBox);
        this.placeSurfaceBlock(level, stackedStone, pos, 4, -1, 5, surfaceBox);
        for (int x = 3; x <= 5; ++x) {
            for (int z = 4; z <= 6; ++z) {
                if (x == 4 && z == 5 || !random.nextBoolean()) continue;
                this.placeSurfaceBlock(level, stackedStone, pos, x, -1, z, surfaceBox);
            }
        }
        BlockState firewood = (BlockState)((HorizontalFuelBlock)BlocksNF.FIREWOOD.get()).m_49966_().m_61124_(HorizontalFuelBlock.AXIS, (Comparable)Direction.Axis.X);
        this.placeSurfaceBlock(level, firewood, pos, 1, 0, 5, surfaceBox);
        this.placeSurfaceBlock(level, firewood, pos, 1, 0, 6, surfaceBox);
        if (random.nextBoolean()) {
            this.placeSurfaceBlock(level, firewood, pos, 1, 0, 6, surfaceBox);
        }
        this.embedSurfaceBlocks(level, stackedStone, pos, 2, 0, 1, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 3, 0, 1, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 2, 0, 4, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 3, 0, 4, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 1, 0, 2, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 1, 0, 3, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 4, 0, 2, 3, surfaceBox);
        this.embedSurfaceBlocks(level, stackedStone, pos, 4, 0, 3, 3, surfaceBox);
        BlockState charcoal = ((HorizontalFuelBlock)BlocksNF.CHARCOAL.get()).m_49966_();
        this.embedSurfaceBlocks(level, pos, 2, -1, 2, surfaceBox, charcoal, charcoal, stackedStone);
        this.embedSurfaceBlocks(level, pos, 3, -1, 2, surfaceBox, charcoal, charcoal, stackedStone);
        this.embedSurfaceBlocks(level, pos, 2, -1, 3, surfaceBox, charcoal, charcoal, stackedStone);
        this.embedSurfaceBlocks(level, pos, 3, -1, 3, surfaceBox, charcoal, charcoal, stackedStone);
        int barrelZ = 3 + random.nextInt(3);
        this.placeContainer(level, surfaceBox, random, 7, this.getSurfaceY(level, 7, barrelZ), barrelZ, (BlockState)((BarrelBlockNF)BlocksNF.BARRELS.get(tree).get()).m_49966_().m_61124_((Property)BarrelBlockNF.FACING, (Comparable)Direction.values()[1 + random.nextInt(4)]), LootTablesNF.DESERTED_CAMP_LOOT, true);
    }

    protected void placeEdge(WorldGenLevel level, BlockState pBlockstate, BlockPos.MutableBlockPos pos, int x, int amount, int z, int breachX, int breachZ, BoundingBox pBoundingbox) {
        int breach = Math.abs(x - breachX) + Math.abs(z - breachZ);
        if (breach == 0) {
            amount -= 2;
        } else if (breach == 1) {
            --amount;
        }
        int surfaceY = this.getSurfaceY(level, x, z);
        pos.m_142451_(this.m_73392_(x, z)).m_142443_(this.m_73525_(x, z));
        for (int y = 0; y < amount; ++y) {
            this.placeBlock(level, pBlockstate, (BlockPos)pos.m_142448_(surfaceY + y), pBoundingbox, y == 0);
        }
    }
}

