/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.structure;

import frostnox.nightfall.block.Soil;
import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.block.SlabBlockNF;
import frostnox.nightfall.block.block.StairBlockNF;
import frostnox.nightfall.block.block.strangesoil.StrangeSoilBlock;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.StructuresNF;
import frostnox.nightfall.registry.vanilla.LootTablesNF;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.structure.StructurePieceNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class ExplorerRuinsPiece
extends StructurePieceNF {
    public static final int SIZE = 11;
    public static final int ITEM_COLOR = 14930341;
    private static final int[] xWall = new int[]{3, 3, 3, 4, 6, 7, 7, 7};
    private static final int[] zWall = new int[]{2, 1, 0, 0, 0, 0, 1, 2};
    protected static FractalSimplexNoiseFast heightNoise;
    protected long lastSeed;

    public ExplorerRuinsPiece(Random random, int x, int z) {
        this(x, z, ExplorerRuinsPiece.m_163580_((Random)random));
    }

    public ExplorerRuinsPiece(int x, int z, Direction orientation) {
        super(StructuresNF.EXPLORER_RUINS_PIECE, 0, ExplorerRuinsPiece.m_163541_((int)x, (int)0, (int)z, (Direction)orientation, (int)11, (int)5, (int)11));
        this.m_73519_(orientation);
    }

    public ExplorerRuinsPiece(CompoundTag pTag) {
        super(StructuresNF.EXPLORER_RUINS_PIECE, pTag);
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag pTag) {
    }

    public void m_183269_(WorldGenLevel level, StructureFeatureManager pStructureFeatureManager, ChunkGenerator gen, Random random, BoundingBox box, ChunkPos pChunkPos, BlockPos centerPos) {
        if (this.updateHeightAverage((LevelAccessor)level, 0)) {
            int y;
            BlockState[] blocks;
            int z;
            int x;
            Soil soil;
            Stone stone;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            long seed = level.m_7328_();
            if (heightNoise == null || this.lastSeed != seed) {
                heightNoise = new FractalSimplexNoiseFast(seed, 0.09f, 2, 0.5f, 2.0f);
                this.lastSeed = seed;
            }
            BoundingBox surfaceBox = this.getSurfaceBox(level, box);
            if (gen instanceof ContinentalChunkGenerator) {
                ContinentalChunkGenerator contGen = (ContinentalChunkGenerator)gen;
                BlockPos center = pChunkPos.m_151394_(surfaceBox.m_162396_());
                stone = contGen.getCachedSurfaceStone(center);
                soil = contGen.getCachedSoil(center);
            } else {
                stone = Stone.SHALE;
                soil = Soil.DIRT;
            }
            for (int i = 0; i < xWall.length; ++i) {
                float height = this.getHeight(xWall[i], zWall[i]);
                int y2 = -1;
                while ((float)y2 <= height) {
                    this.placeBlock(level, ExplorerRuinsPiece.pickBrick(stone, y2, height, random), pos, xWall[i], y2, zWall[i], box);
                    ++y2;
                }
                height = this.getHeight(zWall[i], xWall[i]);
                y2 = -1;
                while ((float)y2 <= height) {
                    this.placeBlock(level, ExplorerRuinsPiece.pickBrick(stone, y2, height, random), pos, zWall[i], y2, xWall[i], box);
                    ++y2;
                }
                height = this.getHeight(10 - xWall[i], 10 - zWall[i]);
                y2 = -1;
                while ((float)y2 <= height) {
                    this.placeBlock(level, ExplorerRuinsPiece.pickBrick(stone, y2, height, random), pos, 10 - xWall[i], y2, 10 - zWall[i], box);
                    ++y2;
                }
                height = this.getHeight(10 - zWall[i], 10 - xWall[i]);
                y2 = -1;
                while ((float)y2 <= height) {
                    this.placeBlock(level, ExplorerRuinsPiece.pickBrick(stone, y2, height, random), pos, 10 - zWall[i], y2, 10 - xWall[i], box);
                    ++y2;
                }
            }
            BlockState strangeSoil = ((StrangeSoilBlock)BlocksNF.STRANGE_SOILS.get(soil).get()).m_49966_();
            int tries = 4 + random.nextInt(3);
            for (int i = 0; i < tries; ++i) {
                int soilZ;
                int soilX = 3 + random.nextInt(5);
                if (!(this.getRubbleHeight(soilX, soilZ = 3 + random.nextInt(5)) > 0.0f)) continue;
                this.placeStrangeSoil(level, this.adjustBoxMinY(surfaceBox, -1), random, (BlockPos)pos.m_122178_(this.m_73392_(soilX, soilZ), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_73392_(soilX, soilZ), this.m_73525_(soilX, soilZ)) - 1, this.m_73525_(soilX, soilZ)), strangeSoil, LootTablesNF.EXPLORER_RUINS_LOOT);
            }
            for (x = 4; x <= 6; ++x) {
                for (z = 1; z <= 9; ++z) {
                    float height = this.getRubbleHeight(x, z);
                    if (height < 0.0f) continue;
                    blocks = new BlockState[Mth.m_14167_((float)height)];
                    y = 0;
                    while ((float)y <= height) {
                        blocks[y] = ExplorerRuinsPiece.pickRubble(stone, y, height, random);
                        ++y;
                    }
                    this.stackSurfaceBlocks(level, pos, x, z, surfaceBox, blocks);
                }
            }
            for (x = 1; x <= 3; ++x) {
                for (z = 4; z <= 6; ++z) {
                    float height = this.getRubbleHeight(x, z);
                    if (height < 0.0f) continue;
                    blocks = new BlockState[Mth.m_14167_((float)height)];
                    y = 0;
                    while ((float)y <= height) {
                        blocks[y] = ExplorerRuinsPiece.pickRubble(stone, y, height, random);
                        ++y;
                    }
                    this.stackSurfaceBlocks(level, pos, x, z, surfaceBox, blocks);
                }
            }
            for (x = 7; x <= 9; ++x) {
                for (z = 4; z <= 6; ++z) {
                    float height = this.getRubbleHeight(x, z);
                    if (height < 0.0f) continue;
                    blocks = new BlockState[Mth.m_14167_((float)height)];
                    y = 0;
                    while ((float)y <= height) {
                        blocks[y] = ExplorerRuinsPiece.pickRubble(stone, y, height, random);
                        ++y;
                    }
                    this.stackSurfaceBlocks(level, pos, x, z, surfaceBox, blocks);
                }
            }
            for (x = 3; x <= 7; x += 4) {
                for (z = 3; z <= 7; z += 4) {
                    float height = this.getRubbleHeight(x, z);
                    if (height < 0.0f) continue;
                    blocks = new BlockState[Mth.m_14167_((float)height)];
                    y = 0;
                    while ((float)y <= height) {
                        blocks[y] = ExplorerRuinsPiece.pickRubble(stone, y, height, random);
                        ++y;
                    }
                    this.stackSurfaceBlocks(level, pos, x, z, surfaceBox, blocks);
                }
            }
        }
    }

    private float getHeight(int x, int z) {
        return 1.1f + Math.abs(heightNoise.noise2D(this.m_73392_(x, z), this.m_73525_(x, z))) * 1.5f;
    }

    private float getRubbleHeight(int x, int z) {
        float dist = (float)Math.sqrt((x - 5) * (x - 5) + (z - 5) * (z - 5)) / 2.6f;
        return 1.55f * (1.0f - dist) - 0.15f + Math.abs(heightNoise.noise2D(this.m_73392_(x, z), this.m_73525_(x, z))) * 1.8f;
    }

    private static BlockState pickBrick(Stone stone, int y, float height, Random random) {
        if (y < (int)height) {
            return ((Block)BlocksNF.STONE_BRICK_BLOCKS.get(stone).get()).m_49966_();
        }
        float fraction = height % 1.0f;
        if (fraction < 0.5f) {
            return ((SlabBlockNF)BlocksNF.STONE_BRICK_SLABS.get(stone).get()).m_49966_();
        }
        return (BlockState)((StairBlockNF)BlocksNF.STONE_BRICK_STAIRS.get(stone).get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
    }

    private static BlockState pickRubble(Stone stone, int y, float height, Random random) {
        if (y < (int)height) {
            return random.nextFloat() < 0.33f ? ((Block)BlocksNF.TERRACOTTA_TILES.get()).m_49966_() : ((Block)BlocksNF.COBBLED_STONE.get(stone).get()).m_49966_();
        }
        float fraction = height % 1.0f;
        if (fraction < 0.5f) {
            return random.nextFloat() < 0.33f ? ((SlabBlockNF)BlocksNF.TERRACOTTA_TILE_SLAB.get()).m_49966_() : ((SlabBlockNF)BlocksNF.COBBLED_STONE_SLABS.get(stone).get()).m_49966_();
        }
        return (BlockState)(random.nextFloat() < 0.33f ? ((StairBlockNF)BlocksNF.TERRACOTTA_TILE_STAIRS.get()).m_49966_() : ((StairBlockNF)BlocksNF.COBBLED_STONE_STAIRS.get(stone).get()).m_49966_()).m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
    }
}

