/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.structure;

import frostnox.nightfall.block.Stone;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.block.block.ClusterBlock;
import frostnox.nightfall.block.block.LogBlock;
import frostnox.nightfall.block.block.SidingBlock;
import frostnox.nightfall.block.block.SlabBlockNF;
import frostnox.nightfall.block.block.StairBlockNF;
import frostnox.nightfall.block.block.barrel.BarrelBlockNF;
import frostnox.nightfall.block.block.chest.ChestBlockNF;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.item.item.ArmorStandDummyItem;
import frostnox.nightfall.item.item.DyeableTieredArmorItem;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.StructuresNF;
import frostnox.nightfall.registry.vanilla.LootTablesNF;
import frostnox.nightfall.util.math.noise.FractalSimplexNoiseFast;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.generation.structure.StructurePieceNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class SlayerRuinsPiece
extends StructurePieceNF {
    public static final int X_SIZE = 15;
    public static final int Z_SIZE = 13;
    public static final int ITEM_COLOR = 0x844545;
    private static final Direction[] BARREL_DIRECTIONS = new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.SOUTH};
    protected static FractalSimplexNoiseFast heightNoise;
    protected long lastSeed;

    public SlayerRuinsPiece(Random random, int x, int z) {
        this(x, z, SlayerRuinsPiece.m_163580_((Random)random));
    }

    public SlayerRuinsPiece(int x, int z, Direction orientation) {
        super(StructuresNF.SLAYER_RUINS_PIECE, 0, SlayerRuinsPiece.m_163541_((int)x, (int)0, (int)z, (Direction)orientation, (int)15, (int)5, (int)13));
        this.m_73519_(orientation);
    }

    public SlayerRuinsPiece(CompoundTag pTag) {
        super(StructuresNF.SLAYER_RUINS_PIECE, pTag);
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag pTag) {
    }

    public void m_183269_(WorldGenLevel level, StructureFeatureManager pStructureFeatureManager, ChunkGenerator gen, Random random, BoundingBox box, ChunkPos pChunkPos, BlockPos centerPos) {
        if (this.updateHeightAverage((LevelAccessor)level, 0)) {
            int y;
            int y2;
            int x;
            int z;
            int y3;
            float height;
            int x2;
            Stone stone;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            long seed = level.m_7328_();
            if (heightNoise == null || this.lastSeed != seed) {
                heightNoise = new FractalSimplexNoiseFast(seed, 0.09f, 2, 0.5f, 2.0f);
                this.lastSeed = seed;
            }
            Tree tree = Tree.IRONWOOD;
            if (gen instanceof ContinentalChunkGenerator) {
                ContinentalChunkGenerator contGen = (ContinentalChunkGenerator)gen;
                stone = (Stone)contGen.getCachedStoneGroup((ChunkPos)pChunkPos).igneousType;
                if (stone == Stone.GRANITE) {
                    stone = Stone.BASALT;
                } else if (stone == Stone.STYGFEL) {
                    stone = Stone.DEEPSLATE;
                }
            } else {
                stone = Stone.DEEPSLATE;
            }
            BlockState stoneBrick = ((Block)BlocksNF.STONE_BRICK_BLOCKS.get(stone).get()).m_49966_();
            BlockState stoneBrickSiding = ((SidingBlock)BlocksNF.STONE_BRICK_SIDINGS.get(stone).get()).m_49966_();
            BlockState stoneBrickSidingInner = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.POSITIVE_INNER));
            BlockState stoneBrickSlabTop = (BlockState)((SlabBlockNF)BlocksNF.STONE_BRICK_SLABS.get(stone).get()).m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
            BlockState planks = ((Block)BlocksNF.PLANK_BLOCKS.get(tree).get()).m_49966_();
            BlockState plankStairs = ((StairBlockNF)BlocksNF.PLANK_STAIRS.get(tree).get()).m_49966_();
            this.placeAirBox(level, pos, 2, 0, 2, 12, 3, 6, box);
            this.placeAirBox(level, pos, 5, 0, 7, 9, 3, 10, box);
            this.placeAirBox(level, pos, 6, -1, 8, 8, -1, 10, box);
            for (x2 = 1; x2 <= 13; ++x2) {
                height = this.getHeight(x2, 1);
                int n = y3 = x2 == 7 ? 2 : -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, x2, y3, 1, box);
                    ++y3;
                }
            }
            for (z = 2; z <= 7; ++z) {
                height = this.getHeight(1, z);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, 1, y3, z, box);
                    ++y3;
                }
                height = this.getHeight(13, z);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, 13, y3, z, box);
                    ++y3;
                }
            }
            for (x2 = 1; x2 <= 4; ++x2) {
                height = this.getHeight(x2, 7);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, x2, y3, 7, box);
                    ++y3;
                }
            }
            for (x2 = 10; x2 <= 12; ++x2) {
                height = this.getHeight(x2, 1);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, x2, y3, 7, box);
                    ++y3;
                }
            }
            for (z = 8; z <= 11; ++z) {
                height = this.getHeight(4, z);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, 4, y3, z, box);
                    ++y3;
                }
                height = this.getHeight(10, z);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, 10, y3, z, box);
                    ++y3;
                }
            }
            for (x2 = 5; x2 <= 9; ++x2) {
                height = this.getHeight(x2, 11);
                y3 = -1;
                while ((float)y3 <= height) {
                    this.placeBlock(level, SlayerRuinsPiece.pickBrick(stone, y3, height, random), pos, x2, y3, 11, box);
                    ++y3;
                }
            }
            this.placeBlock(level, stoneBrickSlabTop, pos, 3, 1, 1, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 5, 1, 1, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 9, 1, 1, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 11, 1, 1, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 1, 1, 4, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 13, 1, 4, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 4, 1, 10, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 10, 1, 10, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 5, 1, 11, box);
            this.placeBlock(level, stoneBrickSlabTop, pos, 9, 1, 11, box);
            for (x2 = 0; x2 <= 14; ++x2) {
                if (x2 == 3 || x2 == 5 || x2 == 7 || x2 == 9 || x2 == 11) continue;
                BlockState siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.NORTH));
                if (x2 == 0) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.POSITIVE_QUARTET));
                } else if (x2 == 14) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.NEGATIVE_QUARTET));
                }
                y3 = -1;
                while ((float)y3 <= this.getHeight(x2, 0)) {
                    this.tryReplaceBlock(level, siding, pos, x2, y3, 0, box);
                    ++y3;
                }
            }
            for (z = 1; z <= 7; ++z) {
                if (z == 2 || z == 4 || z == 6) continue;
                int y4 = -1;
                while ((float)y4 <= this.getHeight(0, z)) {
                    this.tryReplaceBlock(level, (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.EAST)), pos, 0, y4, z, box);
                    ++y4;
                }
                y4 = -1;
                while ((float)y4 <= this.getHeight(14, z)) {
                    this.tryReplaceBlock(level, (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.WEST)), pos, 14, y4, z, box);
                    ++y4;
                }
            }
            BlockState innerSiding = (BlockState)stoneBrickSidingInner.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.EAST));
            int y5 = -1;
            while ((float)y5 <= this.getHeight(3, 8)) {
                this.tryReplaceBlock(level, innerSiding, pos, 3, y5, 8, box);
                ++y5;
            }
            for (x = 0; x <= 2; ++x) {
                BlockState siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.SOUTH));
                if (x == 0) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.NEGATIVE_QUARTET));
                }
                y2 = -1;
                while ((float)y2 <= this.getHeight(x, 8)) {
                    this.tryReplaceBlock(level, siding, pos, x, y2, 8, box);
                    ++y2;
                }
            }
            innerSiding = (BlockState)stoneBrickSidingInner.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.SOUTH));
            y5 = -1;
            while ((float)y5 <= this.getHeight(11, 8)) {
                this.tryReplaceBlock(level, innerSiding, pos, 11, y5, 8, box);
                ++y5;
            }
            for (x = 12; x <= 14; ++x) {
                BlockState siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.SOUTH));
                if (x == 14) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.POSITIVE_QUARTET));
                }
                y2 = -1;
                while ((float)y2 <= this.getHeight(x, 8)) {
                    this.tryReplaceBlock(level, siding, pos, x, y2, 8, box);
                    ++y2;
                }
            }
            for (int z2 = 9; z2 <= 12; ++z2) {
                if (z2 == 10) continue;
                BlockState siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.EAST));
                if (z2 == 12) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.POSITIVE_QUARTET));
                }
                y2 = -1;
                while ((float)y2 <= this.getHeight(3, z2)) {
                    this.tryReplaceBlock(level, siding, pos, 3, y2, z2, box);
                    ++y2;
                }
                siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.WEST));
                if (z2 == 12) {
                    siding = (BlockState)siding.m_61124_(SidingBlock.SHAPE, (Comparable)((Object)SidingBlock.Shape.NEGATIVE_QUARTET));
                }
                y2 = -1;
                while ((float)y2 <= this.getHeight(11, z2)) {
                    this.tryReplaceBlock(level, siding, pos, 11, y2, z2, box);
                    ++y2;
                }
            }
            for (x = 4; x <= 10; ++x) {
                if (x == 5 || x == 7 || x == 9) continue;
                BlockState siding = (BlockState)stoneBrickSiding.m_61124_(SidingBlock.TYPE, (Comparable)((Object)SidingBlock.Type.SOUTH));
                y2 = -1;
                while ((float)y2 <= this.getHeight(x, 12)) {
                    this.tryReplaceBlock(level, siding, pos, x, y2, 12, box);
                    ++y2;
                }
            }
            this.placeBlock(level, planks, pos, 7, -1, 1, box);
            for (x = 2; x <= 12; ++x) {
                for (int z3 = 2; z3 <= 6; ++z3) {
                    this.placeBlock(level, planks, pos, x, -1, z3, box);
                }
            }
            for (x = 5; x <= 9; ++x) {
                this.placeBlock(level, planks, pos, x, -1, 7, box);
            }
            this.placeBlock(level, planks, pos, 5, -1, 8, box);
            this.placeBlock(level, planks, pos, 5, -1, 9, box);
            this.placeBlock(level, planks, pos, 5, -1, 10, box);
            this.placeBlock(level, planks, pos, 9, -1, 8, box);
            this.placeBlock(level, planks, pos, 9, -1, 9, box);
            this.placeBlock(level, planks, pos, 9, -1, 10, box);
            this.placeBlock(level, planks, pos, 6, -1, 8, box);
            this.placeBlock(level, planks, pos, 7, -1, 8, box);
            for (x = 2; x <= 12; ++x) {
                for (int z4 = 2; z4 <= 6; ++z4) {
                    float height2 = this.getRubbleHeight(x, z4);
                    y = 0;
                    while ((float)y <= height2) {
                        this.placeBlock(level, SlayerRuinsPiece.pickRubble(stone, y, height2, random), pos, x, y, z4, box);
                        ++y;
                    }
                }
            }
            for (x = 5; x <= 9; ++x) {
                for (int z5 = 7; z5 <= 10; ++z5) {
                    float height3 = this.getRubbleHeight(x, z5);
                    y = 0;
                    while ((float)y <= height3) {
                        this.placeBlock(level, SlayerRuinsPiece.pickRubble(stone, y, height3, random), pos, x, y, z5, box);
                        ++y;
                    }
                }
            }
            for (x = 6; x <= 8; ++x) {
                for (int z6 = 2; z6 <= 10; ++z6) {
                    for (int y6 = -4; y6 <= -2; ++y6) {
                        this.placeBlock(level, Blocks.f_50016_.m_49966_(), pos, x, y6, z6, box);
                    }
                    this.placeBlock(level, ((Block)BlocksNF.STACKED_STONE.get(stone).get()).m_49966_(), pos, x, -5, z6, box);
                }
            }
            for (y5 = -4; y5 <= -1; ++y5) {
                this.placeBlock(level, ((LogBlock)((Object)BlocksNF.LOGS.get(tree).get())).m_49966_(), pos, 7, y5, 9, box);
            }
            this.placeBlock(level, (BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), pos, 8, -1, 8, box);
            this.placeBlock(level, (BlockState)((BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP), pos, 8, -2, 8, box);
            this.placeBlock(level, (BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), pos, 8, -2, 9, box);
            this.placeBlock(level, (BlockState)((BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP), pos, 8, -3, 9, box);
            this.placeBlock(level, planks, pos, 8, -3, 10, box);
            this.placeBlock(level, (BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST), pos, 7, -3, 10, box);
            this.placeBlock(level, (BlockState)((BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP), pos, 7, -4, 10, box);
            this.placeBlock(level, planks, pos, 6, -4, 10, box);
            this.placeBlock(level, (BlockState)plankStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH), pos, 6, -4, 9, box);
            BlockState cobble = ((Block)BlocksNF.COBBLED_STONE.get(stone).get()).m_49966_();
            this.placeBlock(level, cobble, pos, 8, -1, 9, box);
            this.placeBlock(level, cobble, pos, 8, -1, 10, box);
            this.placeBlock(level, cobble, pos, 8, -2, 10, box);
            this.placeBlock(level, cobble, pos, 7, -1, 10, box);
            this.placeBlock(level, cobble, pos, 7, -2, 10, box);
            this.placeBlock(level, cobble, pos, 6, -1, 10, box);
            this.placeBlock(level, cobble, pos, 6, -2, 10, box);
            this.placeBlock(level, cobble, pos, 6, -3, 10, box);
            this.placeBlock(level, cobble, pos, 6, -1, 9, box);
            this.placeBlock(level, cobble, pos, 6, -2, 9, box);
            this.placeBlock(level, cobble, pos, 6, -3, 9, box);
            for (int x3 = 6; x3 <= 8; ++x3) {
                for (int y7 = -4; y7 <= -2; ++y7) {
                    this.placeBlock(level, stoneBrick, pos, x3, y7, 1, box);
                    this.placeBlock(level, stoneBrick, pos, x3, y7, 11, box);
                }
            }
            for (int z7 = 1; z7 <= 11; ++z7) {
                for (int y8 = -4; y8 <= -2; ++y8) {
                    this.placeBlock(level, stoneBrick, pos, 5, y8, z7, box);
                    this.placeBlock(level, stoneBrick, pos, 9, y8, z7, box);
                }
            }
            for (int i = 0; i < (random.nextBoolean() ? 1 : 2); ++i) {
                int z8 = 3 + random.nextInt(4);
                this.placeContainer(level, box, random, 6, -4, z8, (BlockState)((BarrelBlockNF)BlocksNF.BARRELS.get(Tree.LARCH).get()).m_49966_().m_61124_((Property)BarrelBlockNF.FACING, (Comparable)BARREL_DIRECTIONS[random.nextInt(4)]), LootTablesNF.SLAYER_RUINS_BARREL_LOOT, false);
            }
            int chestZ = 3 + random.nextInt(4);
            this.placeContainer(level, box, random, 8, -4, chestZ, (BlockState)((ChestBlockNF)BlocksNF.CHESTS.get(Tree.LARCH).get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.WEST), LootTablesNF.SLAYER_RUINS_CHEST_LOOT, false);
            for (int x4 = 6; x4 <= 8; ++x4) {
                for (int z9 = 3; z9 <= 10; ++z9) {
                    pos.m_122178_(this.m_73392_(x4, z9), this.m_73544_(-4), this.m_73525_(x4, z9));
                    if (!level.m_8055_((BlockPos)pos).m_60795_() || random.nextInt() % 3 != 0) continue;
                    this.placeBlock(level, (BlockState)((ClusterBlock)BlocksNF.ROCK_CLUSTERS.get(stone).get()).m_49966_().m_61124_((Property)ClusterBlock.COUNT, (Comparable)Integer.valueOf(1 + random.nextInt(4))), (BlockPos)pos, box, false);
                }
            }
            BlockPos.MutableBlockPos entityPos = this.m_163582_(7, -4, 2);
            if (box.m_71051_((Vec3i)entityPos)) {
                ArmorStandDummyEntity armorStand = (ArmorStandDummyEntity)((EntityType)EntitiesNF.ARMOR_STAND.get()).m_20615_((Level)level.m_6018_());
                armorStand.setMaterial(((ArmorStandDummyItem)((Object)ItemsNF.ARMOR_STANDS.get((Object)Tree.LARCH).get())).sourceMaterial);
                armorStand.m_7678_((double)entityPos.m_123341_() + 0.5, entityPos.m_123342_(), (double)entityPos.m_123343_() + 0.5, this.m_73549_().m_122435_(), 0.0f);
                float f = random.nextFloat();
                TieredArmorMaterial material = f < 0.33f ? TieredArmorMaterial.IRON_CHAINMAIL_SLAYER : (f < 0.66f ? TieredArmorMaterial.IRON_SCALE_SLAYER : TieredArmorMaterial.IRON_PLATE_SLAYER);
                ItemStack helmet = new ItemStack((ItemLike)ItemsNF.HELMETS.get(material).get());
                DyeableTieredArmorItem armorItem = (DyeableTieredArmorItem)helmet.m_41720_();
                armorItem.m_41115_(helmet, 0x844545);
                helmet.m_41721_((int)((float)helmet.m_41776_() * (1.0f - random.nextFloat() * 0.05f)));
                armorStand.m_8061_(EquipmentSlot.HEAD, helmet);
                if (random.nextFloat() < 0.3f) {
                    ItemStack chestPlate = new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(material).get());
                    armorItem.m_41115_(chestPlate, 0x844545);
                    chestPlate.m_41721_((int)((float)chestPlate.m_41776_() * (1.0f - random.nextFloat() * 0.05f)));
                    armorStand.m_8061_(EquipmentSlot.CHEST, chestPlate);
                }
                if (random.nextFloat() < 0.3f) {
                    ItemStack leggings = new ItemStack((ItemLike)ItemsNF.LEGGINGS.get(material).get());
                    armorItem.m_41115_(leggings, 0x844545);
                    leggings.m_41721_((int)((float)leggings.m_41776_() * (1.0f - random.nextFloat() * 0.05f)));
                    armorStand.m_8061_(EquipmentSlot.LEGS, leggings);
                }
                if (random.nextFloat() < 0.3f) {
                    ItemStack boots = new ItemStack((ItemLike)ItemsNF.BOOTS.get(material).get());
                    armorItem.m_41115_(boots, 0x844545);
                    boots.m_41721_((int)((float)boots.m_41776_() * (1.0f - random.nextFloat() * 0.05f)));
                    armorStand.m_8061_(EquipmentSlot.FEET, boots);
                }
                level.m_47205_((Entity)armorStand);
            }
        }
    }

    private float getHeight(int x, int z) {
        return 1.2f + Math.abs(heightNoise.noise2D(this.m_73392_(x, z), this.m_73525_(x, z))) * 1.6f;
    }

    private float getRubbleHeight(int x, int z) {
        return -0.25f + Math.abs(heightNoise.noise2D(this.m_73392_(x, z), this.m_73525_(x, z))) * 1.8f;
    }

    private static BlockState pickBrick(Stone stone, int y, float height, Random random) {
        if (y < (int)height) {
            return ((Block)BlocksNF.STONE_BRICK_BLOCKS.get(stone).get()).m_49966_();
        }
        float fraction = height % 1.0f;
        if (fraction < 0.5f) {
            return ((SlabBlockNF)BlocksNF.STONE_BRICK_SLABS.get(stone).get()).m_49966_();
        }
        return (BlockState)((StairBlockNF)BlocksNF.STONE_BRICK_STAIRS.get(stone).get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
    }

    private static BlockState pickRubble(Stone stone, int y, float height, Random random) {
        if (y < (int)height) {
            return ((Block)BlocksNF.COBBLED_STONE.get(stone).get()).m_49966_();
        }
        float fraction = height % 1.0f;
        if (fraction < 0.5f) {
            return ((SlabBlockNF)BlocksNF.COBBLED_STONE_SLABS.get(stone).get()).m_49966_();
        }
        return (BlockState)((StairBlockNF)BlocksNF.COBBLED_STONE_STAIRS.get(stone).get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
    }
}

