/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.structure;

import frostnox.nightfall.block.block.CoveredSoilBlock;
import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.SoilBlock;
import frostnox.nightfall.block.block.strangesoil.StrangeSoilBlockEntity;
import frostnox.nightfall.data.TagsNF;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class StructurePieceNF
extends StructurePiece {
    protected StructurePieceNF(StructurePieceType pType, int pGenDepth, BoundingBox pBox) {
        super(pType, pGenDepth, pBox);
    }

    public StructurePieceNF(StructurePieceType pType, CompoundTag pTag) {
        super(pType, pTag);
    }

    protected void m_73434_(WorldGenLevel level, BlockState block, int x, int y, int z, BoundingBox box) {
        BlockPos.MutableBlockPos worldPos = this.m_163582_(x, y, z);
        if (box.m_71051_((Vec3i)worldPos)) {
            if (this.m_163587_() != Mirror.NONE) {
                block = block.m_60715_(this.m_163587_());
            }
            if (this.m_6830_() != Rotation.NONE) {
                block = block.m_60717_(this.m_6830_());
            }
            level.m_7731_((BlockPos)worldPos, block, 2);
            FluidState fluidstate = level.m_6425_((BlockPos)worldPos);
            if (!fluidstate.m_76178_()) {
                level.m_186469_((BlockPos)worldPos, fluidstate.m_76152_(), 0);
            }
            if (block.m_204336_(TagsNF.STRUCTURE_POST_PROCESS)) {
                level.m_46865_((BlockPos)worldPos).m_8113_((BlockPos)worldPos);
            }
        }
    }

    protected void placeAirBox(WorldGenLevel level, BlockPos.MutableBlockPos pos, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BoundingBox box) {
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.placeBlock(level, Blocks.f_50016_.m_49966_(), pos, x, y, z, box);
                }
            }
        }
    }

    protected void placeBlock(WorldGenLevel level, BlockState block, BlockPos.MutableBlockPos pos, int x, int y, int z, BoundingBox box, boolean againstSurface) {
        this.placeBlock(level, block, (BlockPos)pos.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z)), box, againstSurface);
    }

    protected void placeBlock(WorldGenLevel level, BlockState block, BlockPos.MutableBlockPos pos, int x, int y, int z, BoundingBox box) {
        this.placeBlock(level, block, (BlockPos)pos.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z)), box, false);
    }

    protected void tryReplaceBlock(WorldGenLevel level, BlockState block, BlockPos.MutableBlockPos pos, int x, int y, int z, BoundingBox box, boolean againstSurface) {
        pos.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z));
        BlockState currentBlock = level.m_8055_((BlockPos)pos);
        if (currentBlock.m_60795_() || currentBlock.m_60767_().m_76336_()) {
            this.placeBlock(level, block, (BlockPos)pos, box, againstSurface);
        }
    }

    protected void tryReplaceBlock(WorldGenLevel level, BlockState block, BlockPos.MutableBlockPos pos, int x, int y, int z, BoundingBox box) {
        this.tryReplaceBlock(level, block, pos, x, y, z, box, false);
    }

    protected void placeBlock(WorldGenLevel level, BlockState block, BlockPos worldPos, BoundingBox box, boolean againstSurface) {
        if (box.m_71051_((Vec3i)worldPos)) {
            BlockPos surfacePos;
            Block block2;
            if (this.m_163587_() != Mirror.NONE) {
                block = block.m_60715_(this.m_163587_());
            }
            if (this.m_6830_() != Rotation.NONE) {
                block = block.m_60717_(this.m_6830_());
            }
            level.m_7731_(worldPos, block, 2);
            FluidState fluidstate = level.m_6425_(worldPos);
            if (!fluidstate.m_76178_()) {
                level.m_186469_(worldPos, fluidstate.m_76152_(), 0);
            }
            if (block.m_204336_(TagsNF.STRUCTURE_POST_PROCESS)) {
                level.m_46865_(worldPos).m_8113_(worldPos);
            }
            if (againstSurface && (block2 = level.m_8055_(surfacePos = worldPos.m_7495_()).m_60734_()) instanceof CoveredSoilBlock) {
                CoveredSoilBlock coveredSoil = (CoveredSoilBlock)block2;
                int light = 15;
                if (block.m_60815_()) {
                    if (block.m_60787_()) {
                        if (Block.m_49918_((VoxelShape)block.m_60768_((BlockGetter)level, worldPos), (Direction)Direction.DOWN)) {
                            light = 0;
                        }
                    } else {
                        light -= block.m_60739_((BlockGetter)level, worldPos);
                    }
                }
                if (!coveredSoil.soilCover.canGrow(light)) {
                    level.m_7731_(surfacePos, ((SoilBlock)coveredSoil.soilBlock.get()).m_49966_(), 2);
                }
            }
        }
    }

    protected void stackSurfaceBlocks(WorldGenLevel level, BlockState pBlockstate, BlockPos.MutableBlockPos pos, int x, int amount, int z, BoundingBox pBoundingbox) {
        int surfaceY = this.getSurfaceY(level, x, z);
        pos.m_142451_(this.m_73392_(x, z)).m_142443_(this.m_73525_(x, z));
        for (int y = 0; y < amount; ++y) {
            this.placeBlock(level, pBlockstate, (BlockPos)pos.m_142448_(surfaceY + y), pBoundingbox, y == 0);
        }
    }

    protected void stackSurfaceBlocks(WorldGenLevel level, BlockPos.MutableBlockPos pos, int x, int z, BoundingBox pBoundingbox, BlockState ... blocks) {
        int surfaceY = this.getSurfaceY(level, x, z);
        pos.m_142451_(this.m_73392_(x, z)).m_142443_(this.m_73525_(x, z));
        for (int y = 0; y < blocks.length; ++y) {
            this.placeBlock(level, blocks[y], (BlockPos)pos.m_142448_(surfaceY + y), pBoundingbox, y == 0);
        }
    }

    protected void embedSurfaceBlocks(WorldGenLevel level, BlockState pBlockstate, BlockPos.MutableBlockPos pos, int x, int yOff, int z, int amount, BoundingBox box) {
        int surfaceY = this.getSurfaceY(level, x, z);
        pos.m_142451_(this.m_73392_(x, z)).m_142443_(this.m_73525_(x, z));
        BoundingBox adjustedBox = new BoundingBox(box.m_162395_(), Math.max(1, box.m_162396_() + yOff - amount), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
        for (int y = 0; y < amount; ++y) {
            this.placeBlock(level, pBlockstate, (BlockPos)pos.m_142448_(surfaceY - 1 - y + yOff), adjustedBox, false);
        }
    }

    protected void embedSurfaceBlocks(WorldGenLevel level, BlockPos.MutableBlockPos pos, int x, int yOff, int z, BoundingBox box, BlockState ... blocks) {
        int surfaceY = this.getSurfaceY(level, x, z);
        pos.m_142451_(this.m_73392_(x, z)).m_142443_(this.m_73525_(x, z));
        BoundingBox adjustedBox = new BoundingBox(box.m_162395_(), Math.max(1, box.m_162396_() + yOff - blocks.length), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
        for (int y = 0; y < blocks.length; ++y) {
            this.placeBlock(level, blocks[y], (BlockPos)pos.m_142448_(surfaceY - 1 - y + yOff), adjustedBox, false);
        }
    }

    protected int getSurfaceY(WorldGenLevel level, int x, int z) {
        return level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_73392_(x, z), this.m_73525_(x, z));
    }

    protected static int getWorldSurfaceY(WorldGenLevel level, int worldX, int worldZ) {
        return level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ);
    }

    protected BoundingBox getSurfaceBox(WorldGenLevel level, BoundingBox box) {
        return new BoundingBox(box.m_162395_(), Math.min(Math.min(StructurePieceNF.getWorldSurfaceY(level, box.m_162395_(), box.m_162398_()), StructurePieceNF.getWorldSurfaceY(level, box.m_162395_(), box.m_162401_())), Math.min(StructurePieceNF.getWorldSurfaceY(level, box.m_162399_(), box.m_162398_()), StructurePieceNF.getWorldSurfaceY(level, box.m_162399_(), box.m_162401_()))), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
    }

    protected BoundingBox adjustBoxMinY(BoundingBox box, int y) {
        if (y < 0) {
            return new BoundingBox(box.m_162395_(), Math.max(1, box.m_162396_() + y), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
        }
        return box;
    }

    protected void placeSurfaceBlock(WorldGenLevel level, BlockState pBlockstate, BlockPos.MutableBlockPos pos, int x, int y, int z, BoundingBox box) {
        int worldX = this.m_73392_(x, z);
        int worldZ = this.m_73525_(x, z);
        this.placeBlock(level, pBlockstate, (BlockPos)pos.m_122178_(worldX, y + level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, worldX, worldZ), worldZ), this.adjustBoxMinY(box, y), y == 0);
    }

    protected void placeStrangeSoil(WorldGenLevel level, BoundingBox box, Random random, BlockPos worldPos, BlockState strangeSoilBlock, ResourceLocation lootTable) {
        BlockState block;
        if (box.m_71051_((Vec3i)worldPos) && (block = level.m_8055_(worldPos)).m_204336_(TagsNF.STRUCTURE_REPLACEABLE)) {
            level.m_7731_(worldPos, strangeSoilBlock, 2);
            BlockEntity blockEntity = level.m_7702_(worldPos);
            if (blockEntity instanceof StrangeSoilBlockEntity) {
                StrangeSoilBlockEntity entity = (StrangeSoilBlockEntity)blockEntity;
                entity.lootTableSeed = random.nextLong();
                entity.lootTableLoc = lootTable;
            }
        }
    }

    protected void placeContainer(WorldGenLevel level, BoundingBox box, Random random, int x, int y, int z, BlockState block, ResourceLocation lootTable, boolean orderedLoot) {
        BlockPos.MutableBlockPos worldPos = this.m_163582_(x, y, z);
        if (box.m_71051_((Vec3i)worldPos) && level.m_7702_((BlockPos)worldPos) == null) {
            if (this.m_163587_() != Mirror.NONE) {
                block = block.m_60715_(this.m_163587_());
            }
            if (this.m_6830_() != Rotation.NONE) {
                block = block.m_60717_(this.m_6830_());
            }
            level.m_7731_((BlockPos)worldPos, block, 2);
            BlockEntity blockEntity = level.m_7702_((BlockPos)worldPos);
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity entity = (RandomizableContainerBlockEntity)blockEntity;
                entity.m_59626_(lootTable, random.nextLong());
                if (entity instanceof MenuContainerBlockEntity) {
                    MenuContainerBlockEntity menuEntity = (MenuContainerBlockEntity)entity;
                    menuEntity.orderedLoot = orderedLoot;
                }
            }
        }
    }

    protected boolean updateHeightAverage(LevelAccessor level, int pHeight) {
        int sum = 0;
        int count = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int z = this.f_73383_.m_162398_(); z <= this.f_73383_.m_162401_(); ++z) {
            for (int x = this.f_73383_.m_162395_(); x <= this.f_73383_.m_162399_(); ++x) {
                blockpos$mutableblockpos.m_122178_(x, 0, z);
                sum += level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_();
                ++count;
            }
        }
        if (count == 0) {
            return false;
        }
        this.f_73383_.m_162367_(0, sum / count - this.f_73383_.m_162396_() + pHeight, 0);
        return true;
    }

    protected boolean updateHeightMin(LevelAccessor level, int yOffset) {
        int minHeight = level.m_151558_();
        boolean foundAny = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int j = this.f_73383_.m_162398_(); j <= this.f_73383_.m_162401_(); ++j) {
            for (int k = this.f_73383_.m_162395_(); k <= this.f_73383_.m_162399_(); ++k) {
                pos.m_122178_(k, 0, j);
                minHeight = Math.min(minHeight, level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)pos).m_123342_());
                foundAny = true;
            }
        }
        if (!foundAny) {
            return false;
        }
        this.f_73383_.m_162367_(0, minHeight - this.f_73383_.m_162396_() + yOffset, 0);
        return true;
    }
}

