/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class CaedtarTreeGenerator
extends TreeGenerator {
    public CaedtarTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius);
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        if (lastDirections != null) {
            directions.removeAll(lastDirections);
        }
        while (directions.size() > 2) {
            directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        }
        if (random.nextBoolean()) {
            directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        }
        return directions;
    }

    @Override
    public boolean canPlaceOnBlock(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(TagsNF.TILLABLE_OR_AQUATIC_SOIL);
    }

    @Override
    protected void tickBranches(TreeGenerator.Data d, Random random) {
        super.tickBranches(d, random);
        if (d.height >= this.baseHeight - 1) {
            BlockPos.MutableBlockPos pos = d.trunkPos.m_122032_();
            EnumMap<Direction, BlockPos> growPositions = new EnumMap<Direction, BlockPos>(Direction.class);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pos.m_122159_((Vec3i)d.trunkPos, dir);
                Integer bestY = null;
                int i = 0;
                while (true) {
                    BlockState block = d.level.m_8055_((BlockPos)pos);
                    if (i == 2) {
                        if (block.m_204336_(TagsNF.NATURAL_SOIL)) break;
                        bestY = null;
                        break;
                    }
                    if (block.m_60713_((Block)d.trunk.stemBlock)) {
                        d.otherWood.add((Object)pos.m_7949_());
                    } else {
                        if (!block.m_204336_(TagsNF.TREE_REPLACEABLE)) {
                            if (block.m_204336_(TagsNF.NATURAL_SOIL)) break;
                            bestY = null;
                            break;
                        }
                        if (bestY == null || d.ticks > 1 || d.simulateDetection) {
                            if (d.simulateDetection) {
                                d.otherWood.add((Object)pos.m_7949_());
                            } else if (d.noPlacement) break;
                            bestY = pos.m_123342_();
                        }
                    }
                    pos.m_142448_(pos.m_123342_() - 1);
                    ++i;
                }
                if (bestY == null) continue;
                growPositions.put(dir, new BlockPos(pos.m_123341_(), bestY.intValue(), pos.m_123343_()));
            }
            if (d.stemsPlaced > 0) {
                for (Map.Entry entry : growPositions.entrySet()) {
                    BlockPos growPos = (BlockPos)entry.getValue();
                    d.otherWood.add((Object)growPos);
                    if (growPos.m_123342_() == d.trunkPos.m_123342_()) {
                        d.level.m_7731_(growPos, d.createStem(TreeStemBlock.Type.END, Direction.Axis.Y), 19);
                        continue;
                    }
                    d.level.m_7731_(growPos, d.createStem(TreeStemBlock.Type.TOP, Direction.Axis.Y), 19);
                    d.level.m_7731_(growPos.m_7494_(), d.createStem(TreeStemBlock.Type.BOTTOM, Direction.Axis.Y), 19);
                }
            }
        }
    }
}

