/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class CurvedTreeGenerator
extends TreeGenerator {
    protected final double curveChance;
    protected final boolean doubleCurve;

    protected CurvedTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius, double curveChance, boolean doubleCurve) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius);
        this.curveChance = curveChance;
        this.doubleCurve = doubleCurve;
    }

    @Override
    protected int getMaxDistXZ() {
        return super.getMaxDistXZ() + (this.doubleCurve ? 2 : 1);
    }

    @Override
    protected void tickTrunk(TreeGenerator.Data d, Random random, int maxHeightReached) {
        boolean hasCurve1;
        boolean positive;
        int curve1 = this.getFirstCurveHeight(d.maxHeight, random);
        int curve2 = this.getSecondCurveHeight(curve1, d.maxHeight, random);
        Direction curveDirection = Direction.Plane.HORIZONTAL.m_122560_(random);
        Direction.Axis axis = curveDirection.m_122434_();
        boolean bl = positive = curveDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (axis == Direction.Axis.Z) {
            positive = !positive;
        }
        boolean bl2 = hasCurve1 = random.nextDouble() <= this.curveChance;
        boolean hasCurve2 = this.doubleCurve ? random.nextDouble() <= this.curveChance : false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(d.trunkPos.m_123341_(), d.trunkPos.m_123342_(), d.trunkPos.m_123343_());
        BlockState lastState = null;
        for (int i = 0; i < (d.simulateDetection ? maxHeightReached : d.maxHeight); ++i) {
            boolean curve;
            boolean bl3 = curve = hasCurve1 && i == curve1 || hasCurve2 && i == curve2;
            if (curve) {
                pos.m_122173_(curveDirection);
            }
            pos.m_142448_(pos.m_123342_() + 1);
            BlockState centerState = d.level.m_8055_((BlockPos)pos);
            if (d.isTreeWood(centerState)) {
                if (curve) {
                    belowPos = pos.m_7495_();
                    if (!d.isTreeWood(d.level.m_8055_(belowPos))) break;
                    d.otherWood.add((Object)belowPos);
                }
                d.trunkWood.get(0).add(pos.m_7949_());
                ++d.height;
            } else if (d.canPlaceWood(centerState, lastState)) {
                d.trunkWood.get(0).add(pos.m_7949_());
                d.level.m_7731_((BlockPos)pos, d.createStem(TreeStemBlock.Type.END), 19);
                if (d.height != 0) {
                    belowPos = pos.m_7495_();
                    if (curve) {
                        d.otherWood.add((Object)belowPos);
                        d.level.m_7731_(belowPos.m_142300_(curveDirection.m_122424_()), d.createStem(positive ? TreeStemBlock.Type.ROTATED_TOP : TreeStemBlock.Type.ROTATED_BOTTOM, axis), 19);
                    }
                    d.level.m_7731_(belowPos, d.trunk.stemBlock.m_49966_(), 19);
                }
                ++d.height;
                ++d.stemsPlaced;
                if (d.stemsPlaced >= d.ticks) {
                    break;
                }
            } else {
                if (!curve || !d.isTreeWood(d.level.m_8055_(belowPos = pos.m_7495_()))) break;
                d.otherWood.add((Object)belowPos);
                break;
            }
            lastState = centerState;
        }
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        Direction direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        BlockPos newPos = centerPos.m_142300_(direction);
        while (lastDirections != null && lastDirections.contains(direction) || d.hasTrunkWood(newPos.m_7494_()) || d.hasTrunkWood(newPos.m_7495_())) {
            direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
            newPos = centerPos.m_142300_(direction);
        }
        return List.of(direction);
    }

    protected int getFirstCurveHeight(int maxHeight, Random random) {
        return Math.max(1, maxHeight / (this.doubleCurve ? 3 : 2) + (random.nextInt() & Integer.MAX_VALUE) % 3 - 2);
    }

    protected int getSecondCurveHeight(int curveHeight, int maxHeight, Random random) {
        return Math.min(maxHeight, curveHeight + (random.nextInt() & Integer.MAX_VALUE) % 3 + 1);
    }
}

