/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class IronwoodTreeGenerator
extends TreeGenerator {
    public IronwoodTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius);
    }

    @Override
    protected int getTrunkLeavesCutoff(int height) {
        return height > this.averageHeight - 2 ? 2 : 1;
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        Direction direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        if (lastDirections != null) {
            while (lastDirections.contains(direction)) {
                direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
            }
        }
        if (lastLastDirections != null) {
            while (lastLastDirections.contains(direction)) {
                direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
            }
        }
        return List.of(direction);
    }

    @Override
    protected Direction selectBranchDirection(TreeGenerator.Data d, Random random, BlockPos pos, int length, Direction startDirection, Direction lastDirection) {
        return startDirection;
    }

    @Override
    protected OctalDirection[] getBranchLeavesDirections(TreeGenerator.Data d) {
        return OctalDirection.CARDINALS_UP;
    }

    @Override
    protected int getBranchLength(TreeGenerator.Data d, BlockPos stemPos, Random random) {
        int length = this.baseBranchLength + (this.randBranchLength > 0 ? (random.nextInt() & Integer.MAX_VALUE) % this.randBranchLength : 0);
        if (length == this.baseBranchLength + this.randBranchLength - 1) {
            length -= random.nextInt(3);
        }
        if (d.height < this.averageHeight / 2 && length > 2) {
            --length;
        }
        return length;
    }

    @Override
    protected int getMinBranchHeight(int maxHeight, Random random) {
        return this.baseHeight / 2 - 1 + random.nextInt(3);
    }

    @Override
    protected int getMaxBranchHeight(int height, int minBranchHeight) {
        return Math.max(0, height - (height > this.averageHeight - 2 ? 3 : 2));
    }

    @Override
    protected void tickBranchLeaves(TreeGenerator.Data d, BlockPos branchPos, BlockPos stemPos, int radius, int minShortestPlacedSqr, boolean placeOriginLeaves, OctalDirection[] directions) {
        if (branchPos.m_123333_((Vec3i)stemPos) >= 2) {
            super.tickBranchLeaves(d, branchPos, stemPos, radius, minShortestPlacedSqr, placeOriginLeaves, directions);
        }
    }
}

