/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.world.generation.tree.SpruceTreeGenerator;
import frostnox.nightfall.world.generation.tree.TreeGenerator;

public class LarchTreeGenerator
extends SpruceTreeGenerator {
    public LarchTreeGenerator(int baseHeight, int randHeight, int leavesRadius) {
        super(baseHeight, randHeight, leavesRadius);
    }

    @Override
    protected int getBranchLengthReduction() {
        return 2;
    }

    @Override
    protected boolean branchAt(TreeGenerator.Data d, int y) {
        return y == 0 || y == d.maxHeight / 4 + 1 || y == d.maxHeight / 2 + 1 || y == d.maxHeight * 3 / 4 + 1;
    }

    @Override
    protected int getBranchRadius(int y, int height, int maxHeight, int cutoff) {
        if (y == height) {
            return 1;
        }
        int section1 = maxHeight / 4 + 1;
        int section2 = maxHeight / 2 + 1;
        int section3 = maxHeight * 3 / 4 + 1;
        if (y == section3 + 1) {
            return Math.max(2, this.getLeavesRadius(height) - 1 - (y - section3));
        }
        if (y >= 1 && y < section1) {
            return Math.max(1, this.getLeavesRadius(height) - (y - 1));
        }
        if (y >= section1 && y <= section2) {
            return Math.max(1, this.getLeavesRadius(height) - (y - section1));
        }
        if (y > section2 && y <= section3) {
            return Math.max(1, this.getLeavesRadius(height) - (y - section2));
        }
        if (y > section3 && y < maxHeight) {
            return Math.max(0, this.getLeavesRadius(height) - 1 - (y - section3));
        }
        return 1;
    }
}

