/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.CurvedTreeGenerator;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import org.jetbrains.annotations.Nullable;

public class PalmTreeGenerator
extends CurvedTreeGenerator {
    protected static int TOP_FRONDS_INDEX = 0;
    protected static int TOP_FRONDS = 1;

    public PalmTreeGenerator(int baseHeight, int randHeight, double curveChance, boolean doubleCurve) {
        super(baseHeight, randHeight, 1, 0, 5, curveChance, doubleCurve);
    }

    @Override
    public void tryFruit(WorldGenLevel level, TreeGenerator.Data d, TreeTrunkBlockEntity entity) {
        int minY = Integer.MAX_VALUE;
        for (BlockPos pos : d.trunkLeaves) {
            if (pos.m_123342_() >= minY) continue;
            minY = pos.m_123342_();
        }
        ObjectArrayList leaves = new ObjectArrayList();
        for (BlockPos pos : d.trunkLeaves) {
            if (pos.m_123342_() != minY) continue;
            leaves.add((Object)pos);
        }
        this.tryFruitBranchLeaves(level, d, entity, 3, (List<BlockPos>)leaves);
    }

    @Override
    protected int getMaxPossibleHeight() {
        return super.getMaxPossibleHeight() + 1;
    }

    @Override
    protected int getTrunkLeavesCutoff(int height) {
        return 1;
    }

    @Override
    protected OctalDirection[] getInitialTrunkLeavesDirections(int y, int height) {
        return OctalDirection.OCTALS_UP;
    }

    @Override
    protected int getLeavesRadius(int height) {
        return 0;
    }

    @Override
    protected int getMinBranchHeight(int maxHeight, Random random) {
        return maxHeight - 2;
    }

    @Override
    protected int getMaxBranchHeight(int height, int minBranchHeight) {
        return super.getMaxBranchHeight(height, minBranchHeight);
    }

    @Override
    protected int getTrunkLeavesRadius(int y, int height, int maxHeight, int cutoff) {
        int radius = y < this.averageHeight / 2 ? 1 : (y > this.averageHeight - 1 && y >= maxHeight - 3 ? 3 : 2);
        if (y == maxHeight - 1 && y > this.maxPossibleHeight - 4) {
            ++radius;
        }
        return radius;
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        return Direction.Plane.HORIZONTAL.m_122557_().collect(Collectors.toList());
    }

    @Override
    protected boolean isAltLeaves(TreeGenerator.Data d, BlockPos pos) {
        return pos.m_123342_() != d.trunkPos.m_123342_() + d.height;
    }

    @Override
    protected void setupData(TreeGenerator.Data d, Random random) {
        (d.intData = new int[1])[PalmTreeGenerator.TOP_FRONDS_INDEX] = random.nextFloat() > 0.4f ? TOP_FRONDS : -1;
    }

    @Override
    protected void tickTrunkLeaves(TreeGenerator.Data d, boolean old) {
        int cutoff = this.getTrunkLeavesCutoff(d.height);
        WrappedInt shortestPlaced = new WrappedInt(Integer.MAX_VALUE);
        int minShortestPlaced = !d.oldTrunkLeaves.isEmpty() ? this.maxLeavesRadius : d.ticks;
        int y = d.height - cutoff;
        if (y < 0 || y >= d.trunkWood.get(0).size()) {
            return;
        }
        BlockPos pos = d.trunkWood.get(0).get(y);
        int radius = this.getTrunkLeavesRadius(y, d.height, d.maxHeight, cutoff);
        if (radius == 1) {
            for (OctalDirection dir : this.getInitialTrunkLeavesDirections(y, d.height)) {
                this.setTrunkLeavesBlock(d, dir.move(pos), old, 1, minShortestPlaced, shortestPlaced);
            }
        } else {
            radius = Math.max(1, radius - 1);
            int diagonalRadius = radius / 2;
            for (OctalDirection dir : this.getInitialTrunkLeavesDirections(y, d.height)) {
                this.tickTrunkLeaves(d, pos, dir.move(pos), dir.isDiagonal() ? diagonalRadius : radius, old, 1, minShortestPlaced, shortestPlaced, dir.getOpposite());
            }
        }
    }

    @Override
    protected void tickTrunkLeaves(TreeGenerator.Data d, BlockPos lastPos, BlockPos pos, int radius, boolean old, int dist, int minShortestPlaced, WrappedInt shortestPlaced, OctalDirection originDir) {
        block16: {
            block15: {
                if (dist <= radius) {
                    if (!this.setTrunkLeavesBlock(d, pos, old, dist, minShortestPlaced, shortestPlaced) && originDir == OctalDirection.DOWN) {
                        return;
                    }
                    if (radius == 3 && originDir != OctalDirection.DOWN) {
                        this.setTrunkLeavesBlock(d, originDir.getOpposite().move(pos), old, dist + 1, minShortestPlaced, shortestPlaced);
                    }
                }
                if (originDir != OctalDirection.DOWN) break block15;
                if (d.intData[TOP_FRONDS_INDEX] != TOP_FRONDS) break block16;
                this.setTrunkLeavesBlock(d, pos.m_7494_(), old, dist + 1, minShortestPlaced, shortestPlaced);
                for (OctalDirection dir : OctalDirection.CARDINALS) {
                    BlockPos movePos = pos;
                    int length = radius == 3 ? 3 : 2;
                    for (int i = 1; i <= length && this.setTrunkLeavesBlock(d, movePos = dir.move(movePos), old, dist + i, minShortestPlaced, shortestPlaced); ++i) {
                        if (i != length || radius < 2) continue;
                        this.setTrunkLeavesBlock(d, movePos.m_7494_(), old, dist + i, minShortestPlaced, shortestPlaced);
                    }
                }
                break block16;
            }
            BlockPos movePos = pos.m_7495_();
            OctalDirection dir = originDir.getOpposite();
            if (dir.isDiagonal() && radius > 0) {
                if (!this.setTrunkLeavesBlock(d, movePos, old, dist, minShortestPlaced, shortestPlaced)) {
                    return;
                }
                boolean x = this.setTrunkLeavesBlock(d, movePos.m_142082_(dir.xStepInt, 0, 0), old, dist + 1, minShortestPlaced, shortestPlaced);
                boolean z = this.setTrunkLeavesBlock(d, movePos.m_142082_(0, 0, dir.zStepInt), old, dist + 1, minShortestPlaced, shortestPlaced);
                if (!x && !z) {
                    return;
                }
                movePos = pos.m_7495_();
            } else if (dir.isCardinal()) {
                if (radius >= 2) {
                    this.setTrunkLeavesBlock(d, movePos.m_7495_(), old, dist, minShortestPlaced, shortestPlaced);
                } else {
                    this.setTrunkLeavesBlock(d, movePos, old, dist, minShortestPlaced, shortestPlaced);
                }
            }
            if (radius == 0) {
                this.setTrunkLeavesBlock(d, movePos, old, dist, minShortestPlaced, shortestPlaced);
            } else {
                for (int i = 1; i <= radius && this.setTrunkLeavesBlock(d, movePos = dir.move(movePos), old, dist + i - 1, minShortestPlaced, shortestPlaced); ++i) {
                    if (i != radius) continue;
                    this.setTrunkLeavesBlock(d, movePos.m_7495_(), old, dist + i, minShortestPlaced, shortestPlaced);
                }
            }
        }
    }
}

