/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class RedwoodTreeGenerator
extends TreeGenerator {
    public RedwoodTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius);
    }

    @Override
    protected int getTrunkLeavesCutoff(int height) {
        return 1;
    }

    @Override
    protected OctalDirection[] getBranchLeavesDirections(TreeGenerator.Data d) {
        return OctalDirection.CARDINALS_UP;
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        int y = d.trunkPos.m_123342_() + d.maxHeight - 1 - centerPos.m_123342_();
        if (y % 3 != 0) {
            return List.of();
        }
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        if (random.nextFloat() < 0.35f) {
            directions.remove(random.nextInt(directions.size()));
        }
        return directions;
    }

    @Override
    protected Direction selectBranchDirection(TreeGenerator.Data d, Random random, BlockPos pos, int length, Direction startDirection, Direction lastDirection) {
        return startDirection;
    }

    @Override
    protected int getMinBranchHeight(int maxHeight, Random random) {
        return this.baseHeight / 2;
    }

    @Override
    protected int getBranchLength(TreeGenerator.Data d, BlockPos stemPos, Random random) {
        if (d.height < this.baseHeight + (d.maxHeight - this.baseHeight) / 2 || d.trunkPos.m_123342_() + d.maxHeight - 1 == stemPos.m_123342_()) {
            return 1;
        }
        return super.getBranchLength(d, stemPos, random);
    }
}

