/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class SplitTreeGenerator
extends TreeGenerator {
    protected final int minSplits;
    protected final int maxSplits;
    protected final float curveChance;
    protected final boolean curveRoot;

    public SplitTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius, int minSplits, int maxSplits, float curveChance, boolean curveRoot) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius);
        this.minSplits = minSplits;
        this.maxSplits = maxSplits;
        this.curveChance = curveChance;
        this.curveRoot = curveRoot;
    }

    protected int getSplitHeight(TreeGenerator.Data d, Random random) {
        return d.maxHeight / 3 + 1 + random.nextInt(2);
    }

    @Override
    protected int getMaxDistXZ() {
        return super.getMaxDistXZ() + this.maxPossibleHeight;
    }

    @Override
    protected void tickTrunk(TreeGenerator.Data d, Random random, int maxHeightReached) {
        boolean positive;
        Direction curveDirection = Direction.Plane.HORIZONTAL.m_122560_(random);
        Direction.Axis axis = curveDirection.m_122434_();
        boolean bl = positive = curveDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (axis == Direction.Axis.Z) {
            positive = !positive;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(d.trunkPos.m_123341_(), d.trunkPos.m_123342_(), d.trunkPos.m_123343_());
        BlockState lastState = null;
        int splits = this.minSplits + random.nextInt(this.maxSplits - this.minSplits + 1);
        ArrayList splitDirections = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        while (splitDirections.size() > splits) {
            splitDirections.remove(random.nextInt(splitDirections.size()));
        }
        EnumMap<Direction, Random> splitRandoms = new EnumMap<Direction, Random>(Direction.class);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            splitRandoms.put(dir, new Random(random.nextLong()));
        }
        int splitHeight = this.getSplitHeight(d, random);
        for (int i = 0; i < Math.min(splitHeight, d.simulateDetection ? maxHeightReached : d.maxHeight); ++i) {
            boolean curve;
            boolean bl2 = curve = this.curveRoot && i > 0 && i < splitHeight - 1 && random.nextFloat() < this.curveChance;
            if (curve) {
                pos.m_122173_(curveDirection);
            }
            pos.m_142448_(pos.m_123342_() + 1);
            BlockState centerState = d.level.m_8055_((BlockPos)pos);
            if (d.isTreeWood(centerState)) {
                if (curve) {
                    belowPos = pos.m_7495_();
                    if (d.isTreeWood(d.level.m_8055_(belowPos))) {
                        d.otherWood.add((Object)belowPos);
                    } else {
                        return;
                    }
                }
                d.trunkWood.get(0).add(pos.m_7949_());
                ++d.height;
            } else if (d.canPlaceWood(centerState, lastState)) {
                d.trunkWood.get(0).add(pos.m_7949_());
                d.level.m_7731_(pos.m_7949_(), d.createStem(TreeStemBlock.Type.END), 19);
                if (d.height != 0) {
                    belowPos = pos.m_7495_();
                    if (curve) {
                        d.otherWood.add((Object)belowPos);
                        d.level.m_7731_(belowPos.m_142300_(curveDirection.m_122424_()), d.createStem(positive ? TreeStemBlock.Type.ROTATED_TOP : TreeStemBlock.Type.ROTATED_BOTTOM, axis), 19);
                    }
                    d.level.m_7731_(belowPos, d.trunk.stemBlock.m_49966_(), 19);
                }
                ++d.height;
                ++d.stemsPlaced;
                if (d.stemsPlaced >= d.ticks) {
                    return;
                }
            } else {
                if (curve && d.isTreeWood(d.level.m_8055_(belowPos = pos.m_7495_()))) {
                    d.otherWood.add((Object)belowPos);
                }
                return;
            }
            lastState = centerState;
        }
        int trunkIndex = 1;
        boolean convertedCenter = false;
        int tallestPlacedHeight = 0;
        int mostStemsPlaced = 0;
        for (Direction splitDir : splitDirections) {
            d.trunkWood.add((List<BlockPos>)new ObjectArrayList());
            BlockState lastSplitState = lastState;
            BlockPos lastSplitPos = null;
            BlockPos.MutableBlockPos splitPos = pos.m_122032_();
            float splitCurveChance = this.curveChance;
            int placedHeight = 0;
            int stemsPlaced = 0;
            for (int i = splitHeight; i < (d.simulateDetection ? maxHeightReached : d.maxHeight); ++i) {
                boolean moveUp;
                boolean bl3 = moveUp = i > splitHeight + 1 && ((Random)splitRandoms.get(splitDir)).nextFloat() > splitCurveChance;
                if (moveUp) {
                    splitPos.m_142448_(splitPos.m_123342_() + 1);
                    splitCurveChance = this.curveChance;
                } else {
                    splitPos.m_122173_(splitDir);
                    splitCurveChance /= 2.0f;
                }
                BlockState splitState = d.level.m_8055_((BlockPos)splitPos);
                if (d.isTreeWood(splitState)) {
                    ++placedHeight;
                    d.trunkWood.get(trunkIndex).add(splitPos.m_7949_());
                } else {
                    if (!d.canPlaceWood(splitState, lastSplitState)) break;
                    d.level.m_7731_(splitPos.m_7949_(), d.createStem(TreeStemBlock.Type.END, moveUp ? Direction.Axis.Y : splitDir.m_122434_()), 19);
                    if (i > splitHeight) {
                        d.level.m_7731_(lastSplitPos, d.createBranch(moveUp ? Direction.UP : splitDir), 19);
                    } else if (!convertedCenter) {
                        convertedCenter = true;
                        d.level.m_7731_((BlockPos)pos, d.createStem(TreeStemBlock.Type.FAKE_END), 19);
                    }
                    ++placedHeight;
                    d.trunkWood.get(trunkIndex).add(splitPos.m_7949_());
                    if (++stemsPlaced >= d.ticks) break;
                }
                lastSplitPos = splitPos.m_7949_();
                lastSplitState = splitState;
            }
            ++trunkIndex;
            if (placedHeight > tallestPlacedHeight) {
                tallestPlacedHeight = placedHeight;
            }
            if (stemsPlaced <= mostStemsPlaced) continue;
            mostStemsPlaced = stemsPlaced;
        }
        d.height += tallestPlacedHeight;
        d.stemsPlaced += mostStemsPlaced;
    }

    @Override
    protected OctalDirection[] getInitialTrunkLeavesDirections(int y, int height) {
        return OctalDirection.STRAIGHTS;
    }

    @Override
    protected List<Direction> getBranchStartDirections(TreeGenerator.Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        Direction direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        Direction rootDir = Direction.m_122372_((float)(d.trunkPos.m_123341_() - centerPos.m_123341_()), (float)0.0f, (float)(d.trunkPos.m_123343_() - centerPos.m_123343_()));
        while (lastDirections != null && lastDirections.contains(direction) || direction == rootDir || direction == rootDir.m_122424_()) {
            if (directions.isEmpty()) {
                return List.of();
            }
            direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        }
        return List.of(direction);
    }

    @Override
    protected int getTrunkLeavesRadius(int y, int height, int maxHeight, int cutoff) {
        return height < this.baseHeight ? Math.max(1, this.maxLeavesRadius - 1) : this.maxLeavesRadius;
    }
}

