/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpruceTreeGenerator
extends TreeGenerator {
    public SpruceTreeGenerator(int baseHeight, int randHeight, int leavesRadius) {
        super(baseHeight, randHeight, 0, 0, leavesRadius);
    }

    protected boolean branchAt(TreeGenerator.Data d, int y) {
        if (d.maxHeight >= this.maxPossibleHeight - 2 && y == d.maxHeight * 2 / 3 - 1) {
            return true;
        }
        return y == 0 || y == d.maxHeight / 3 || y == d.maxHeight * 2 / 3 + 1;
    }

    protected int getBranchLengthReduction() {
        return 2;
    }

    protected int getBranchRadius(int y, int height, int maxHeight, int cutoff) {
        if (y >= height) {
            return 1;
        }
        int section1 = maxHeight / 3 + 1;
        int section2 = maxHeight * 2 / 3 + 1;
        if (y == section2 + 1) {
            return Math.max(2, this.getLeavesRadius(height) - 1 - (y - section2));
        }
        if (y >= 1 && y < section1) {
            return Math.max(1, this.getLeavesRadius(height) - (y - 1));
        }
        if (y >= section1 && y <= section2) {
            return Math.max(1, this.getLeavesRadius(height) - (y - section1));
        }
        if (y > section2 && y < maxHeight) {
            return Math.max(0, this.getLeavesRadius(height) - 1 - (y - section2));
        }
        return 1;
    }

    @Override
    protected void tickBranches(TreeGenerator.Data d, Random random) {
        if (d.trunkWood.get(0).isEmpty() || d.height < 3) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < d.height - 1; ++i) {
            if (i >= d.trunkWood.get(0).size()) continue;
            BlockPos stemPos = d.trunkWood.get(0).get(i);
            if (!this.branchAt(d, i)) continue;
            int radius = Math.max(0, this.getBranchRadius(i + 1, d.height, d.maxHeight, 0) - this.getBranchLengthReduction());
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                pos.m_122159_((Vec3i)stemPos, direction);
                BlockState branchState = d.level.m_8055_((BlockPos)pos);
                if (d.stemsPlaced > 0 && d.canPlaceWood(branchState)) {
                    d.otherWood.add((Object)pos.m_7949_());
                    d.level.m_7731_((BlockPos)pos, d.createStem(TreeStemBlock.Type.END, direction.m_122434_()), 19);
                    this.tickBranch(d, random, (BlockPos)pos, stemPos, radius, direction);
                    continue;
                }
                if (!d.isTreeWood(branchState)) continue;
                d.otherWood.add((Object)pos.m_7949_());
                this.tickBranch(d, random, (BlockPos)pos, stemPos, radius, direction);
            }
        }
    }

    @Override
    protected void tickBranch(TreeGenerator.Data d, Random random, BlockPos startPos, BlockPos stemPos, int radius, Direction startDirection) {
        BlockState startState;
        int minShortestPlacedSqr = d.ticks * d.ticks;
        BlockState lastState = startState = d.level.m_8055_(startPos);
        BlockPos pos = startPos;
        int placed = 0;
        Direction.Axis axis = startDirection.m_122434_();
        OctalDirection[] branchDirections = axis == Direction.Axis.X ? new OctalDirection[]{OctalDirection.SOUTH, OctalDirection.NORTH} : new OctalDirection[]{OctalDirection.EAST, OctalDirection.WEST};
        int maxLeavesRadius = 1;
        if (!d.woodOnly) {
            BlockPos.MutableBlockPos measurePos = startPos.m_122032_();
            for (int i = 0; i < radius; ++i) {
                measurePos.m_122173_(startDirection);
                BlockState state = d.level.m_8055_((BlockPos)measurePos);
                if (i == radius - 1) {
                    ++maxLeavesRadius;
                } else {
                    if (!d.isTreeWood(state) && !d.canPlaceWood(state, lastState)) break;
                    ++maxLeavesRadius;
                }
                lastState = state;
            }
            lastState = startState;
            BlockPos growPos = startPos;
            this.tickBranchLeaves(d, pos, stemPos, maxLeavesRadius, minShortestPlacedSqr);
            for (int r = maxLeavesRadius - 1; r >= 0; --r) {
                growPos = growPos.m_142300_(Direction.UP);
                if (r == 0) {
                    this.setBranchLeavesBlock(d, growPos, growPos, 1.0f, new WrappedInt(Integer.MAX_VALUE), minShortestPlacedSqr, OctalDirection.DOWN, OctalDirection.DOWN, 1);
                    continue;
                }
                this.tickBranchLeaves(d, growPos, stemPos, r, minShortestPlacedSqr, true, branchDirections);
            }
        }
        for (int i = 0; i < radius; ++i) {
            BlockPos lastPos = pos;
            pos = pos.m_142300_(startDirection);
            BlockState state = d.level.m_8055_(pos);
            if (i == radius - 1) {
                if (!d.woodOnly) {
                    if (!d.noPlacement && lastState.m_60713_((Block)d.trunk.stemBlock) && lastState.m_61143_(TreeStemBlock.TYPE) == TreeStemBlock.Type.END) {
                        d.level.m_7731_(pos, d.createLeaves(this.isAltLeaves(d, pos)), 19);
                        ++placed;
                    } else if (!d.simulateDetection && !state.m_60713_((Block)d.trunk.leavesBlock)) break;
                    d.branchLeaves.add((Object)pos);
                }
            } else {
                if (d.canPlaceWood(state, lastState)) {
                    d.level.m_7731_(pos, d.createStem(TreeStemBlock.Type.END, axis), 19);
                    d.level.m_7731_(lastPos, d.createBranch(startDirection), 19);
                    d.branchLeaves.remove((Object)pos);
                    ++placed;
                } else if (!d.isTreeWood(state)) break;
                d.otherWood.add((Object)pos);
            }
            if (!d.woodOnly) {
                int leavesRadius = Math.max(1, maxLeavesRadius - i - 1);
                BlockPos growPos = pos;
                this.tickBranchLeaves(d, pos, stemPos, leavesRadius, minShortestPlacedSqr);
                for (int r = leavesRadius - 1; r >= 0; --r) {
                    growPos = growPos.m_142300_(Direction.UP);
                    if (r == 0) {
                        this.setBranchLeavesBlock(d, growPos, growPos, 1.0f, new WrappedInt(Integer.MAX_VALUE), minShortestPlacedSqr, OctalDirection.DOWN, OctalDirection.DOWN, 1);
                        continue;
                    }
                    this.tickBranchLeaves(d, growPos, stemPos, r, minShortestPlacedSqr, true, branchDirections);
                }
            }
            if (placed > 0 && placed >= d.ticks) break;
            lastState = state;
        }
    }

    @Override
    protected OctalDirection[] getBranchLeavesDirections(TreeGenerator.Data d) {
        return OctalDirection.CARDINALS;
    }

    @Override
    protected boolean cancelBranchLeavesDirection(OctalDirection newDir, OctalDirection backDir, OctalDirection originDir) {
        return newDir != originDir.getOpposite();
    }

    @Override
    protected int getTrunkLeavesRadius(int y, int height, int maxHeight, int cutoff) {
        return 1;
    }

    @Override
    protected int getTrunkLeavesCutoff(int height) {
        return 1;
    }

    @Override
    protected int getLeavesRadius(int height) {
        if (height < this.baseHeight - 2) {
            return Math.max(1, this.maxLeavesRadius - 1);
        }
        if (height < this.baseHeight) {
            return Math.max(1, this.maxLeavesRadius);
        }
        if (height <= this.averageHeight) {
            return Math.max(1, this.maxLeavesRadius + 1);
        }
        return this.maxLeavesRadius + 2;
    }

    @Override
    protected float squareBranchLeavesRadius(int radius) {
        return radius * radius;
    }
}

