/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.block.block.tree.TreeBranchesBlock;
import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlock;
import frostnox.nightfall.block.block.tree.TreeTrunkBlockEntity;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.world.UpdateBlockToClient;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.Season;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class TreeGenerator {
    public final int baseHeight;
    public final int randHeight;
    public final int maxPossibleHeight;
    public final int averageHeight;
    public final int baseBranchLength;
    public final int randBranchLength;
    public final int maxLeavesRadius;
    public final int maxLength;
    public final int maxDistXZ;
    public final int maxLeavesDistXZ;
    protected static final int BLOCK_SET_FLAG = 19;

    public TreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int maxLeavesRadius) {
        this.baseHeight = baseHeight;
        this.randHeight = randHeight;
        this.baseBranchLength = baseBranchLength;
        this.randBranchLength = randBranchLength;
        this.maxLeavesRadius = maxLeavesRadius;
        this.maxPossibleHeight = this.getMaxPossibleHeight();
        this.averageHeight = baseHeight + Math.max(0, randHeight - 1) / 2;
        this.maxLength = this.maxPossibleHeight + baseBranchLength + Math.max(0, randBranchLength - 1);
        this.maxDistXZ = this.getMaxDistXZ();
        this.maxLeavesDistXZ = this.maxDistXZ + maxLeavesRadius;
    }

    protected int getMaxPossibleHeight() {
        return this.baseHeight + Math.max(0, this.randHeight - 1);
    }

    protected int getMaxDistXZ() {
        return this.baseBranchLength + Math.max(0, this.randBranchLength - 1);
    }

    public boolean canPlaceOnBlock(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(TagsNF.TILLABLE_SOIL);
    }

    public boolean canGrowAt(BlockAndTintGetter level, BlockPos pos) {
        return this.canPlaceOnBlock((BlockGetter)level, pos.m_7495_()) && level.m_45524_(pos, 0) >= 7 && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    public Data grow(ServerLevel level, TreeTrunkBlockEntity entity, boolean forceGrowth) {
        return this.grow((WorldGenLevel)level, entity, 1, forceGrowth);
    }

    public Data grow(WorldGenLevel level, TreeTrunkBlockEntity entity, int ticks, boolean forceGrowth) {
        ticks = Math.max(1, ticks);
        return this.tick(level, entity, ticks, LevelData.isPresent((Level)level.m_6018_()) ? LevelData.get((Level)level.m_6018_()).getSeasonTime() : 0L, false, false, forceGrowth);
    }

    public Data grow(WorldGenLevel level, TreeTrunkBlockEntity entity, int ticks, long seasonTime, boolean forceGrowth) {
        ticks = Math.max(1, ticks);
        return this.tick(level, entity, ticks, seasonTime, false, false, forceGrowth);
    }

    public Data getTree(WorldGenLevel level, TreeTrunkBlockEntity entity, boolean simulateDetection) {
        return this.tick(level, entity, 0, 0L, simulateDetection, false, false);
    }

    public Data getWood(WorldGenLevel level, TreeTrunkBlockEntity entity, boolean simulateDetection) {
        return this.tick(level, entity, 0, 0L, simulateDetection, true, false);
    }

    protected Data tick(WorldGenLevel level, TreeTrunkBlockEntity entity, int ticks, long seasonTime, boolean simulateDetection, boolean woodOnly, boolean forceGrowth) {
        Season season;
        TreeTrunkBlock trunkBlock = (TreeTrunkBlock)entity.m_58900_().m_60734_();
        boolean decaying = ticks > 0 && trunkBlock.type.isDeciduous() ? ((season = Season.get(seasonTime)) == Season.FALL ? season.getProgress(seasonTime) > 0.5f : season == Season.WINTER) : false;
        Data d = new Data(level, trunkBlock, entity.m_58899_(), ticks, decaying, 0, 0, 0, simulateDetection, woodOnly, forceGrowth);
        Random random = new Random(entity.getSeed());
        d.maxHeight = this.baseHeight + (random.nextInt() & Integer.MAX_VALUE) % this.randHeight;
        this.setupData(d, new Random(random.nextLong()));
        this.tickTrunk(d, new Random(random.nextLong()), entity.maxHeight);
        d.height = Math.max(entity.maxHeight, d.height);
        this.tickBranches(d, new Random(random.nextLong()));
        if (!d.woodOnly) {
            if (!d.generating && d.height > 1 && d.stemsPlaced > 0) {
                d.height -= d.stemsPlaced;
                this.tickTrunkLeaves(d, true);
                d.height += d.stemsPlaced;
            }
            if (d.height >= entity.maxHeight) {
                this.tickTrunkLeaves(d, false);
            } else if (d.decaying) {
                boolean noPlacement = d.noPlacement;
                d.noPlacement = true;
                this.tickTrunkLeaves(d, false);
                d.noPlacement = noPlacement;
            }
        }
        if (!d.oldTrunkLeaves.isEmpty()) {
            List<TreeTrunkBlockEntity> nearbyTrunks = TreeTrunkBlockEntity.getNearbyTrunks((Level)level.m_6018_(), trunkBlock.type, entity.m_58899_(), d.oldTrunkLeaves);
            ObjectOpenHashSet nearbyTrees = new ObjectOpenHashSet(60 * nearbyTrunks.size());
            for (TreeTrunkBlockEntity nearbyTrunk : nearbyTrunks) {
                if (nearbyTrunk == entity) continue;
                nearbyTrees.addAll(nearbyTrunk.getTree());
            }
            for (BlockPos pos : d.oldTrunkLeaves) {
                if (!d.trunkLeaves.contains((Object)pos)) {
                    if (nearbyTrees.contains((Object)pos)) continue;
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 19);
                    continue;
                }
                this.updateLeaves(d, d.level.m_8055_(pos), pos);
            }
        }
        if (ticks > 0 && !d.generating && !d.changingLeaves.isEmpty()) {
            if (d.decaying) {
                for (BlockPos pos : d.changingLeaves) {
                    state = level.m_8055_(pos);
                    if (!d.isTreeLeaves(state)) continue;
                    LevelUtil.uncheckedDropDestroyBlockNoSound((Level)level, pos, state, d.createLeaves(this.isAltLeaves(d, pos)), null, 19);
                }
            } else {
                for (BlockPos pos : d.changingLeaves) {
                    state = level.m_8055_(pos);
                    if (!d.isTreeLeaves(state)) continue;
                    level.m_7731_(pos, d.createLeaves(this.isAltLeaves(d, pos)), 19);
                }
            }
        }
        if (!d.noPlacement) {
            if (!d.generating) {
                ObjectOpenHashSet accessedSections = new ObjectOpenHashSet(8);
                for (BlockPos leavesPos : d.branchLeaves) {
                    TreeGenerator.updateClientSection((ObjectSet<SectionPos>)accessedSections, level.m_6018_(), leavesPos);
                }
                for (BlockPos leavesPos : d.trunkLeaves) {
                    TreeGenerator.updateClientSection((ObjectSet<SectionPos>)accessedSections, level.m_6018_(), leavesPos);
                }
            }
            if (d.stemsPlaced > 0) {
                entity.maxHeight = d.height;
            }
        }
        entity.lastTick = level.m_6106_().m_6793_();
        entity.m_6596_();
        return d;
    }

    private static void updateClientSection(ObjectSet<SectionPos> accessedSections, ServerLevel level, BlockPos pos) {
        if (accessedSections.add((Object)SectionPos.m_123199_((BlockPos)pos))) {
            NetworkHandler.toAllTrackingChunk(level.m_46745_(pos), new UpdateBlockToClient(pos));
        }
    }

    protected void setupData(Data d, Random random) {
    }

    public void tryFruit(WorldGenLevel level, Data d, TreeTrunkBlockEntity entity) {
    }

    protected void tryFruitBranchLeaves(WorldGenLevel level, Data d, TreeTrunkBlockEntity entity, int maxFruit, List<BlockPos> leaves) {
        int limit = Math.min(leaves.size(), 1 + level.m_5822_().nextInt(maxFruit));
        for (int i = 0; i < limit; ++i) {
            BlockPos pos = leaves.remove(level.m_5822_().nextInt(leaves.size()));
            level.m_7731_(pos, (BlockState)d.trunk.fruitBlock.m_49966_().m_61124_((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(this.isAltLeaves(d, pos))), 19);
        }
        entity.hasFruited = true;
        entity.m_6596_();
    }

    protected void tickTrunk(Data d, Random random, int maxHeightReached) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(d.trunkPos.m_123341_(), d.trunkPos.m_123342_(), d.trunkPos.m_123343_());
        BlockState lastState = null;
        for (int i = 0; i < (d.simulateDetection ? maxHeightReached : d.maxHeight); ++i) {
            pos.m_142448_(pos.m_123342_() + 1);
            BlockState centerState = d.level.m_8055_((BlockPos)pos);
            if (d.isTreeWood(centerState)) {
                ++d.height;
                d.trunkWood.get(0).add(pos.m_7949_());
            } else {
                if (!d.canPlaceWood(centerState, lastState)) break;
                d.level.m_7731_(pos.m_7949_(), d.createStem(TreeStemBlock.Type.END), 19);
                if (d.height != 0) {
                    d.level.m_7731_(pos.m_7495_(), d.trunk.stemBlock.m_49966_(), 19);
                }
                ++d.height;
                ++d.stemsPlaced;
                d.trunkWood.get(0).add(pos.m_7949_());
                if (d.stemsPlaced >= d.ticks) break;
            }
            lastState = centerState;
        }
    }

    protected void tickBranches(Data d, Random random) {
        int j;
        if (this.baseBranchLength == 0) {
            return;
        }
        int minBranchHeight = this.getMinBranchHeight(d.maxHeight, random);
        int maxBranchHeight = this.getMaxBranchHeight(d.height, minBranchHeight);
        int maxRadius = this.getLeavesRadius(d.maxHeight);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int n = j = d.trunkWood.size() > 1 ? 1 : 0;
        while (j < d.trunkWood.size()) {
            List<BlockPos> trunkWood = d.trunkWood.get(j);
            Random trunkRandom = new Random(random.nextLong());
            if (!trunkWood.isEmpty()) {
                int index;
                List<Direction> lastDirections = null;
                List<Direction> lastLastDirections = null;
                int minBranchHeightOffset = minBranchHeight + d.trunkPos.m_123342_();
                BlockPos centerPos = trunkWood.get(0);
                for (index = 1; centerPos.m_123342_() < minBranchHeightOffset && index < trunkWood.size(); ++index) {
                    centerPos = trunkWood.get(index);
                }
                for (int i = minBranchHeight; i < maxBranchHeight; ++i) {
                    Random branchRandom = new Random(trunkRandom.nextLong());
                    if (index >= trunkWood.size()) break;
                    centerPos = trunkWood.get(index);
                    ++index;
                    List<Direction> branchDirections = this.getBranchStartDirections(d, centerPos, branchRandom, lastDirections, lastLastDirections);
                    for (Direction direction : branchDirections) {
                        Random dirRandom = new Random(branchRandom.nextLong());
                        pos.m_122190_((Vec3i)centerPos);
                        pos.m_122173_(direction);
                        BlockState branchState = d.level.m_8055_((BlockPos)pos);
                        if (d.stemsPlaced > 0 && d.canPlaceWood(branchState)) {
                            d.otherWood.add((Object)pos.m_7949_());
                            d.level.m_7731_(pos.m_7949_(), d.createStem(TreeStemBlock.Type.END, direction.m_122434_()), 19);
                            if (d.ticks > 1) {
                                this.tickBranch(d, dirRandom, (BlockPos)pos, centerPos, maxRadius, direction);
                                continue;
                            }
                            this.tickBranchLeaves(d, (BlockPos)pos, centerPos, maxRadius, d.ticks * d.ticks);
                            continue;
                        }
                        if (!d.isTreeWood(branchState)) continue;
                        d.otherWood.add((Object)pos.m_7949_());
                        this.tickBranch(d, dirRandom, (BlockPos)pos, centerPos, maxRadius, direction);
                    }
                    lastLastDirections = lastDirections;
                    lastDirections = branchDirections;
                }
            }
            ++j;
        }
    }

    protected List<Direction> getBranchStartDirections(Data d, BlockPos centerPos, Random random, @Nullable List<Direction> lastDirections, @Nullable List<Direction> lastLastDirections) {
        ArrayList directions = Lists.newArrayList((Iterator)Direction.Plane.HORIZONTAL.iterator());
        Direction direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
        if (lastDirections != null) {
            while (lastDirections.contains(direction)) {
                direction = (Direction)directions.remove((random.nextInt() & Integer.MAX_VALUE) % directions.size());
            }
        }
        return List.of(direction);
    }

    protected int getMinBranchHeight(int maxHeight, Random random) {
        return this.baseHeight / 2 + random.nextInt(2);
    }

    protected int getMaxBranchHeight(int height, int minBranchHeight) {
        return Math.max(0, height - 1);
    }

    protected int getBranchLength(Data d, BlockPos stemPos, Random random) {
        int length = this.baseBranchLength + (this.randBranchLength > 0 ? (random.nextInt() & Integer.MAX_VALUE) % this.randBranchLength : 0);
        if (d.height < this.averageHeight / 2 && length > 2) {
            --length;
        }
        return length;
    }

    protected void tickBranch(Data d, Random random, BlockPos startPos, BlockPos stemPos, int radius, Direction startDirection) {
        if (this.baseBranchLength == 0) {
            return;
        }
        int minShortestPlacedSqr = d.ticks * d.ticks;
        BlockState lastState = d.level.m_8055_(startPos);
        Direction lastDirection = startDirection;
        BlockPos pos = startPos;
        int placed = 0;
        int branchLength = this.getBranchLength(d, stemPos, random);
        for (int i = 2; i <= branchLength; ++i) {
            Direction direction;
            lastDirection = direction = this.selectBranchDirection(d, new Random(random.nextLong()), pos, i, startDirection, lastDirection);
            BlockPos lastPos = pos.m_7949_();
            BlockState state = d.level.m_8055_(pos = pos.m_142300_(direction));
            if (d.canPlaceWood(state, lastState)) {
                d.otherWood.add((Object)pos);
                d.level.m_7731_(pos.m_7949_(), d.createStem(TreeStemBlock.Type.END, direction.m_122434_()), 19);
                d.level.m_7731_(lastPos, d.createBranch(direction), 19);
                d.branchLeaves.remove((Object)pos);
                ++placed;
            } else if (!d.isTreeWood(state)) break;
            d.otherWood.add((Object)pos);
            this.tickBranchLeaves(d, pos, stemPos, radius, minShortestPlacedSqr);
            if (placed > 0 && placed >= d.ticks) break;
            lastState = state;
        }
        this.tickBranchLeaves(d, startPos, stemPos, radius, minShortestPlacedSqr);
    }

    protected Direction selectBranchDirection(Data d, Random random, BlockPos pos, int length, Direction startDirection, Direction lastDirection) {
        if (length != 2) {
            if (lastDirection == startDirection || random.nextFloat() < 0.2f) {
                Direction dir;
                Direction direction = dir = random.nextBoolean() ? lastDirection.m_122427_() : lastDirection.m_122428_();
                if (dir == startDirection.m_122424_()) {
                    return startDirection;
                }
                return dir;
            }
            return startDirection;
        }
        return lastDirection;
    }

    protected float squareBranchLeavesRadius(int radius) {
        return radius > 1 ? ((float)radius - 0.5f) * ((float)radius - 0.5f) : 1.0f;
    }

    protected void tickBranchLeaves(Data d, BlockPos branchPos, BlockPos stemPos, int radius, int minShortestPlacedSqr) {
        this.tickBranchLeaves(d, branchPos, stemPos, radius, minShortestPlacedSqr, false, this.getBranchLeavesDirections(d));
    }

    protected void tickBranchLeaves(Data d, BlockPos branchPos, BlockPos stemPos, int radius, int minShortestPlacedSqr, boolean placeOriginLeaves, OctalDirection[] directions) {
        if (d.woodOnly) {
            return;
        }
        float radiusSqr = this.squareBranchLeavesRadius(radius);
        WrappedInt shortestPlaced = new WrappedInt(Integer.MAX_VALUE);
        if (!placeOriginLeaves || this.setBranchLeavesBlock(d, branchPos, branchPos, radiusSqr, shortestPlaced, minShortestPlacedSqr, OctalDirection.CENTER, OctalDirection.CENTER, 1)) {
            if (radius == 0) {
                return;
            }
            for (OctalDirection dir : directions) {
                this.tickBranchLeaves(d, branchPos, branchPos.m_142082_(dir.xStepInt, dir.yStepInt, dir.zStepInt), radiusSqr, shortestPlaced, minShortestPlacedSqr, dir.getOpposite(), dir.getOpposite(), 1);
            }
        }
    }

    protected void tickBranchLeaves(Data d, BlockPos branchPos, BlockPos pos, float radiusSqr, WrappedInt shortestPlaced, int minShortestPlacedSqr, OctalDirection backDir, OctalDirection originDir, int dist) {
        if (!this.setBranchLeavesBlock(d, branchPos, pos, radiusSqr, shortestPlaced, minShortestPlacedSqr, backDir, originDir, dist)) {
            return;
        }
        for (OctalDirection newDir : this.getBranchLeavesDirections(d)) {
            if (this.cancelBranchLeavesDirection(newDir, backDir, originDir)) continue;
            this.tickBranchLeaves(d, branchPos, pos.m_142082_(newDir.xStepInt, newDir.yStepInt, newDir.zStepInt), radiusSqr, shortestPlaced, minShortestPlacedSqr, newDir.getOpposite(), originDir, dist + 1);
        }
    }

    protected boolean checkBranchLeaves(Data d, BlockPos branchPos, BlockPos pos, float radiusSqr, WrappedInt shortestPlaced, int minShortestPlacedSqr, OctalDirection backDir, OctalDirection originDir, int dist) {
        if ((float)(dist * dist) > radiusSqr) {
            return false;
        }
        double distSqr = branchPos.m_123331_((Vec3i)pos);
        return distSqr <= (double)radiusSqr;
    }

    protected boolean setBranchLeavesBlock(Data d, BlockPos branchPos, BlockPos pos, float radiusSqr, WrappedInt shortestPlaced, int minShortestPlacedSqr, OctalDirection backDir, OctalDirection originDir, int dist) {
        if (!this.checkBranchLeaves(d, branchPos, pos, radiusSqr, shortestPlaced, minShortestPlacedSqr, backDir, originDir, dist)) {
            return false;
        }
        if (d.simulateDetection) {
            d.branchLeaves.add((Object)pos);
        } else {
            BlockState state = d.level.m_8055_(pos);
            int roundedDistSqr = Mth.m_14165_((double)branchPos.m_123331_((Vec3i)pos));
            if (!d.generating && roundedDistSqr > shortestPlaced.val) {
                if (d.isTreeLeaves(state)) {
                    d.collectChangingLeaves(pos, state);
                }
                return false;
            }
            if (d.isTreeLeaves(state)) {
                d.branchLeaves.add((Object)pos);
                d.collectChangingLeaves(pos, state);
            } else if (state.m_60795_() && !d.noPlacement) {
                d.branchLeaves.add((Object)pos);
                d.level.m_7731_(pos, d.createLeaves(this.isAltLeaves(d, pos)), 19);
                if (!d.generating && roundedDistSqr >= minShortestPlacedSqr) {
                    shortestPlaced.val = roundedDistSqr;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean cancelBranchLeavesDirection(OctalDirection newDir, OctalDirection backDir, OctalDirection originDir) {
        return newDir == originDir || newDir == backDir.getOpposite();
    }

    protected void tickTrunkLeaves(Data d, boolean old) {
        int cutoff = this.getTrunkLeavesCutoff(d.height);
        WrappedInt shortestPlaced = new WrappedInt(Integer.MAX_VALUE);
        int minShortestPlaced = !d.oldTrunkLeaves.isEmpty() ? this.maxLeavesRadius : d.ticks;
        for (int j = 0; j < d.trunkWood.size(); ++j) {
            List<BlockPos> trunkWood = d.trunkWood.get(j);
            for (int i = 0; i <= Math.min(trunkWood.size() - 1, d.height); ++i) {
                BlockPos pos = trunkWood.get(i);
                int y = pos.m_123342_() - d.trunkPos.m_123342_();
                if ((j > 0 ? d.trunkWood.get(0).size() + i : i) < d.height - cutoff) continue;
                int radius = this.getTrunkLeavesRadius(y, d.height, d.maxHeight, cutoff);
                WrappedInt diagonalRadius = new WrappedInt(-1);
                for (OctalDirection dir : this.getInitialTrunkLeavesDirections(y, d.height)) {
                    this.tickTrunkLeaves(d, pos, dir.move(pos), dir.isDiagonal() ? (diagonalRadius.val == -1 ? diagonalRadius.setAndGet((radius + 1) / 2) : diagonalRadius.val) : radius, old, 1, minShortestPlaced, shortestPlaced, dir.getOpposite());
                }
            }
        }
    }

    protected void tickTrunkLeaves(Data d, BlockPos centerPos, BlockPos pos, int radius, boolean old, int dist, int minShortestPlaced, WrappedInt shortestPlaced, OctalDirection originDir) {
        if (dist > radius) {
            return;
        }
        if (!this.setTrunkLeavesBlock(d, pos, old, dist, minShortestPlaced, shortestPlaced)) {
            return;
        }
        for (OctalDirection dir : this.getTrunkLeavesDirections(pos.m_123342_() - d.trunkPos.m_123342_(), d.height)) {
            if (dir == originDir) continue;
            this.tickTrunkLeaves(d, centerPos, dir.move(pos), radius, old, dist + 1, minShortestPlaced, shortestPlaced, originDir);
        }
    }

    protected boolean setTrunkLeavesBlock(Data d, BlockPos pos, boolean old, int dist, int minShortestPlaced, WrappedInt shortestPlaced) {
        if (old) {
            BlockState state;
            if (!d.branchLeaves.contains((Object)pos) && d.isTreeLeaves(state = d.level.m_8055_(pos))) {
                d.oldTrunkLeaves.add((Object)pos);
            }
            return true;
        }
        if (d.simulateDetection) {
            d.trunkLeaves.add((Object)pos);
            return true;
        }
        BlockState state = d.level.m_8055_(pos);
        if (!d.generating && !d.noPlacement && dist > shortestPlaced.val) {
            if (d.isTreeLeaves(state)) {
                d.collectChangingLeaves(pos, state);
            }
            return false;
        }
        if (state.m_60795_()) {
            if (!d.noPlacement) {
                d.level.m_7731_(pos, d.createLeaves(this.isAltLeaves(d, pos)), 19);
                d.trunkLeaves.add((Object)pos);
                if (!d.generating && dist >= minShortestPlaced) {
                    shortestPlaced.val = dist;
                }
                return true;
            }
            return false;
        }
        if (d.isTreeLeaves(state)) {
            d.trunkLeaves.add((Object)pos);
            d.collectChangingLeaves(pos, state);
            return true;
        }
        return false;
    }

    protected void updateLeaves(Data d, BlockState state, BlockPos pos) {
        if (!d.noPlacement) {
            boolean alt = this.isAltLeaves(d, pos);
            if ((Boolean)state.m_61143_((Property)TreeBranchesBlock.ALTERNATE) != alt) {
                d.level.m_7731_(pos, (BlockState)state.m_61124_((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(alt)), 19);
            }
        }
    }

    protected boolean isAltLeaves(Data d, BlockPos pos) {
        return pos.m_123342_() % 2 == 0;
    }

    protected OctalDirection[] getInitialTrunkLeavesDirections(int y, int height) {
        return y == height ? OctalDirection.CARDINALS_UP : OctalDirection.CARDINALS;
    }

    protected OctalDirection[] getTrunkLeavesDirections(int y, int height) {
        return OctalDirection.CARDINALS;
    }

    protected OctalDirection[] getBranchLeavesDirections(Data d) {
        return OctalDirection.STRAIGHTS;
    }

    protected int getTrunkLeavesCutoff(int height) {
        return height / 2 + 1;
    }

    protected int getTrunkLeavesRadius(int y, int height, int maxHeight, int cutoff) {
        return height < this.baseHeight && y == height || y == height - cutoff + 1 ? Math.max(1, this.maxLeavesRadius - 1) : this.maxLeavesRadius;
    }

    protected int getLeavesRadius(int height) {
        if (height < this.averageHeight) {
            return Math.max(1, this.maxLeavesRadius - 1);
        }
        return this.maxLeavesRadius;
    }

    public static class Data {
        public final List<List<BlockPos>> trunkWood;
        public final ObjectSet<BlockPos> trunkLeaves;
        public final ObjectSet<BlockPos> otherWood;
        public final ObjectSet<BlockPos> branchLeaves;
        public final ObjectSet<BlockPos> oldTrunkLeaves;
        public final ObjectSet<BlockPos> changingLeaves;
        protected final WorldGenLevel level;
        protected final TreeTrunkBlock trunk;
        protected final BlockPos trunkPos;
        protected final BlockState newLeaves;
        public final boolean generating;
        public final boolean decaying;
        public final boolean woodOnly;
        public final boolean forceGrowth;
        public final boolean simulateDetection;
        public boolean noPlacement;
        public int ticks;
        public int stemsPlaced;
        public int height;
        public int maxHeight;
        public int[] intData = null;

        protected Data(WorldGenLevel level, TreeTrunkBlock trunk, BlockPos trunkPos, int ticks, boolean decaying, int stemsPlaced, int height, int maxHeight, boolean simulateDetection, boolean woodOnly, boolean forceGrowth) {
            this.level = level;
            this.trunk = trunk;
            this.trunkPos = trunkPos;
            this.ticks = ticks;
            this.stemsPlaced = stemsPlaced;
            this.height = height;
            this.maxHeight = maxHeight;
            this.simulateDetection = simulateDetection;
            this.woodOnly = woodOnly;
            this.forceGrowth = forceGrowth;
            this.trunkWood = new ObjectArrayList(5);
            this.trunkWood.add((List<BlockPos>)new ObjectArrayList());
            this.trunkLeaves = new ObjectArraySet();
            this.otherWood = new ObjectArraySet();
            this.branchLeaves = new ObjectArraySet();
            this.oldTrunkLeaves = new ObjectArraySet();
            this.decaying = decaying;
            this.changingLeaves = new ObjectArraySet();
            this.noPlacement = ticks == 0;
            boolean bl = this.generating = ticks == Integer.MAX_VALUE;
            this.newLeaves = (decaying ? (trunk.branchesBlock == null ? trunk.leavesBlock : trunk.branchesBlock) : trunk.leavesBlock).m_49966_();
        }

        public ObjectSet<BlockPos> collectLeaves() {
            return new ObjectOpenHashSet((Collection)Stream.of(this.trunkLeaves, this.branchLeaves).flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        public ObjectSet<BlockPos> collectWood() {
            return new ObjectOpenHashSet((Collection)Stream.concat(this.trunkWood.stream(), Stream.of(this.otherWood)).flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        public ObjectSet<BlockPos> collectTree() {
            return new ObjectOpenHashSet((Collection)Stream.concat(this.trunkWood.stream(), Stream.of(this.otherWood, this.trunkLeaves, this.branchLeaves)).flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        public boolean hasTrunkWood(BlockPos pos) {
            for (List<BlockPos> positions : this.trunkWood) {
                if (!positions.contains(pos)) continue;
                return true;
            }
            return false;
        }

        protected boolean visitedTrunkLeaves(BlockPos pos, boolean old) {
            if (old) {
                return this.oldTrunkLeaves.contains((Object)pos);
            }
            return this.trunkLeaves.contains((Object)pos);
        }

        protected void collectChangingLeaves(BlockPos pos, BlockState state) {
            if (!this.generating) {
                if (this.decaying) {
                    if (state.m_60713_((Block)this.trunk.leavesBlock) || state.m_60713_((Block)this.trunk.fruitBlock)) {
                        this.changingLeaves.add((Object)pos);
                    }
                } else if (state.m_60713_((Block)this.trunk.branchesBlock)) {
                    this.changingLeaves.add((Object)pos);
                }
            }
        }

        protected boolean isTreeWood(BlockState state) {
            return this.simulateDetection || this.trunk.isTreeBase(state);
        }

        protected boolean isTreeLeaves(BlockState state) {
            return state.m_60713_((Block)this.trunk.leavesBlock) || state.m_60713_((Block)this.trunk.branchesBlock) || state.m_60713_((Block)this.trunk.fruitBlock);
        }

        protected boolean canPlaceWood(BlockState state) {
            if (this.noPlacement) {
                return false;
            }
            return state.m_60795_() || this.isTreeLeaves(state);
        }

        protected boolean canPlaceWood(BlockState state, @Nullable BlockState lastState) {
            if (this.noPlacement) {
                return false;
            }
            if (state.m_60795_() || this.isTreeLeaves(state)) {
                if (lastState == null || !lastState.m_60713_((Block)this.trunk.stemBlock)) {
                    return this.forceGrowth;
                }
                if (lastState.m_61143_(TreeStemBlock.TYPE) == TreeStemBlock.Type.END) {
                    return true;
                }
                return this.forceGrowth;
            }
            return false;
        }

        protected BlockState createLeaves(boolean alt) {
            return (BlockState)this.newLeaves.m_61124_((Property)TreeBranchesBlock.ALTERNATE, (Comparable)Boolean.valueOf(alt));
        }

        protected BlockState createStem(TreeStemBlock.Type type) {
            return (BlockState)this.trunk.stemBlock.m_49966_().m_61124_(TreeStemBlock.TYPE, (Comparable)((Object)type));
        }

        protected BlockState createStem(TreeStemBlock.Type type, Direction.Axis axis) {
            return (BlockState)((BlockState)this.trunk.stemBlock.m_49966_().m_61124_(TreeStemBlock.TYPE, (Comparable)((Object)type))).m_61124_((Property)TreeStemBlock.f_55923_, (Comparable)axis);
        }

        protected BlockState createBranch(Direction newDir) {
            boolean positive;
            Direction.Axis axis = newDir.m_122434_();
            boolean bl = positive = newDir.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (axis == Direction.Axis.Z) {
                positive = !positive;
            }
            return (BlockState)((BlockState)this.trunk.stemBlock.m_49966_().m_61124_(TreeStemBlock.TYPE, (Comparable)((Object)(positive ? TreeStemBlock.Type.TOP : TreeStemBlock.Type.BOTTOM)))).m_61124_((Property)TreeStemBlock.f_55923_, (Comparable)axis);
        }
    }
}

