/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.generation.tree;

import frostnox.nightfall.util.data.WrappedInt;
import frostnox.nightfall.util.math.OctalDirection;
import frostnox.nightfall.world.generation.tree.SplitTreeGenerator;
import frostnox.nightfall.world.generation.tree.TreeGenerator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class WillowTreeGenerator
extends SplitTreeGenerator {
    protected static final int DROOP_ARRAY_SIZE_INDEX = 0;
    protected static final int DROOP_LENGTH_INDEX = 1;

    public WillowTreeGenerator(int baseHeight, int randHeight, int baseBranchLength, int randBranchLength, int leavesRadius, int minSplits, int maxSplits, float curveChance, boolean curveRoot) {
        super(baseHeight, randHeight, baseBranchLength, randBranchLength, leavesRadius, minSplits, maxSplits, curveChance, curveRoot);
    }

    protected int getDroopDist(TreeGenerator.Data d, BlockPos trunkPos, BlockPos leavesPos) {
        int x = d.intData[0] / 2 + trunkPos.m_123341_() - leavesPos.m_123341_();
        int z = (d.intData[0] / 2 + trunkPos.m_123343_() - leavesPos.m_123343_()) * d.intData[0];
        return d.intData[2 + x + z];
    }

    @Override
    protected void setupData(TreeGenerator.Data d, Random random) {
        int droopDist;
        int size = this.maxLeavesDistXZ + 1;
        d.intData = new int[2 + size * size];
        d.intData[0] = size;
        d.intData[1] = droopDist = 1 + this.maxLeavesRadius * 2;
        for (int i = 2; i < d.intData.length; ++i) {
            d.intData[i] = random.nextInt(droopDist);
        }
    }

    @Override
    protected int getMaxDistXZ() {
        return super.getMaxDistXZ() + 1;
    }

    @Override
    protected int getTrunkLeavesRadius(int y, int height, int maxHeight, int cutoff) {
        return height < this.baseHeight || maxHeight <= this.averageHeight ? Math.max(1, this.maxLeavesRadius - 1) : this.maxLeavesRadius;
    }

    @Override
    protected int getTrunkLeavesCutoff(int height) {
        return Math.max(1, height * 3 / 4);
    }

    @Override
    protected boolean checkBranchLeaves(TreeGenerator.Data d, BlockPos branchPos, BlockPos pos, float radiusSqr, WrappedInt shortestPlaced, int minShortestPlacedSqr, OctalDirection backDir, OctalDirection originDir, int dist) {
        if (backDir == OctalDirection.UP && dist <= this.getDroopDist(d, d.trunkPos, pos)) {
            return true;
        }
        return super.checkBranchLeaves(d, branchPos, pos, radiusSqr, shortestPlaced, minShortestPlacedSqr, backDir, originDir, dist);
    }

    @Override
    protected void tickBranchLeaves(TreeGenerator.Data d, BlockPos branchPos, BlockPos pos, float radiusSqr, WrappedInt shortestPlaced, int minShortestPlacedSqr, OctalDirection backDir, OctalDirection originDir, int dist) {
        super.tickBranchLeaves(d, branchPos, pos, radiusSqr, shortestPlaced, minShortestPlacedSqr, backDir, originDir, dist);
        if (backDir == OctalDirection.UP && dist <= d.intData[1] && d.branchLeaves.contains((Object)pos) && !d.trunkWood.get(0).contains(pos)) {
            this.tickBranchLeaves(d, branchPos, pos.m_7495_(), radiusSqr, shortestPlaced, minShortestPlacedSqr, OctalDirection.UP, OctalDirection.UP, dist + 1);
        }
    }

    @Override
    protected Direction selectBranchDirection(TreeGenerator.Data d, Random random, BlockPos pos, int length, Direction startDirection, Direction lastDirection) {
        if (length != 2) {
            if (lastDirection == startDirection || random.nextBoolean()) {
                Direction dir = random.nextBoolean() ? lastDirection.m_122427_() : lastDirection.m_122428_();
                Direction rootDir = Direction.m_122372_((float)(d.trunkPos.m_123341_() - pos.m_123341_()), (float)0.0f, (float)(d.trunkPos.m_123343_() - pos.m_123343_()));
                if (dir == startDirection.m_122424_() || rootDir.m_122434_() == dir.m_122434_()) {
                    return startDirection;
                }
                return dir;
            }
            return startDirection;
        }
        return lastDirection;
    }

    @Override
    protected int getMinBranchHeight(int maxHeight, Random random) {
        return this.baseHeight / 2 + 2 + random.nextInt(2);
    }
}

