/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import frostnox.nightfall.world.inventory.AccessorySlot;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;

public class AccessoryInventory
implements Container {
    public static final int SIZE = 3;
    public final NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public Player player;

    public void tick() {
        for (int i = 0; i < 3; ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.m_41619_()) continue;
            item.onArmorTick(this.player.f_19853_, this.player);
        }
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("slot", (byte)i);
            ((ItemStack)this.items.get(i)).m_41739_(tag);
            listTag.add((Object)tag);
        }
        return listTag;
    }

    public void load(ListTag listTag) {
        this.items.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int index = tag.m_128445_("slot") & 0xFF;
            ItemStack item = ItemStack.m_41712_((CompoundTag)tag);
            if (item.m_41619_() || index >= 3) continue;
            this.items.set(index, (Object)item);
        }
    }

    public void dropAll() {
        for (int i = 0; i < 3; ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.m_41619_()) continue;
            this.player.m_7197_(item, true, false);
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void replaceWith(AccessoryInventory inventory) {
        for (int i = 0; i < 3; ++i) {
            this.m_6836_(i, inventory.m_8020_(i));
        }
    }

    public ItemStack getItem(AccessorySlot slot) {
        return (ItemStack)this.items.get(slot.ordinal());
    }

    public void setItem(AccessorySlot slot, ItemStack item) {
        this.m_6836_(slot.ordinal(), item);
    }

    public boolean contains(ItemStack searchItem) {
        for (ItemStack item : this.items) {
            if (item.m_41619_() || !item.m_41656_(searchItem)) continue;
            return true;
        }
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= 3) {
            return null;
        }
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index < 0 || index >= 3) {
            return ItemStack.f_41583_;
        }
        return !((ItemStack)this.items.get(index)).m_41619_() ? ContainerHelper.m_18969_(this.items, (int)index, (int)count) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        if (index < 0 || index >= 3) {
            return ItemStack.f_41583_;
        }
        if (!((ItemStack)this.items.get(index)).m_41619_()) {
            ItemStack item = (ItemStack)this.items.get(index);
            this.items.set(index, (Object)ItemStack.f_41583_);
            return item;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack item) {
        SoundEvent sound;
        if (index < 0 || index >= 3) {
            return;
        }
        if (item.m_41783_() != null) {
            item.m_41720_().m_142312_(item.m_41783_());
        }
        if (!item.m_41619_() && !this.player.m_5833_() && (sound = item.m_150920_()) != null) {
            this.player.m_146850_(GameEvent.f_157811_);
            this.player.m_5496_(sound, 1.0f, 1.0f);
        }
        this.items.set(index, (Object)item);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.player == null || this.player.m_146910_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this.player) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

