/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import frostnox.nightfall.data.TagsNF;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum AccessorySlot {
    FACE(TagsNF.ACCESSORY_FACE),
    NECK(TagsNF.ACCESSORY_NECK),
    WAIST(TagsNF.ACCESSORY_WAIST);

    public final TagKey<Item> acceptedItems;

    private AccessorySlot(TagKey<Item> acceptedItems) {
        this.acceptedItems = acceptedItems;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean acceptsItem(ItemStack item) {
        return item.m_204117_(this.acceptedItems);
    }

    @Nullable
    public static AccessorySlot getSlotFor(ItemStack item) {
        if (FACE.acceptsItem(item)) {
            return FACE;
        }
        if (NECK.acceptsItem(item)) {
            return NECK;
        }
        if (WAIST.acceptsItem(item)) {
            return WAIST;
        }
        return null;
    }
}

