/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import frostnox.nightfall.item.item.EmptyBucketItem;
import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.registry.forge.FluidsNF;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FluidSlot
extends SlotItemHandler {
    protected final AbstractContainerMenu menu;
    protected final Player player;
    protected final int index;
    protected final boolean fluidOnly;
    private static boolean inInsert;

    public FluidSlot(IItemHandler itemHandler, AbstractContainerMenu menu, Player player, int index, int xPosition, int yPosition, boolean fluidOnly) {
        super(itemHandler, index, xPosition, yPosition);
        this.menu = menu;
        this.player = player;
        this.index = index;
        this.fluidOnly = fluidOnly;
    }

    public Fluid getFluid() {
        return FluidsNF.getAsFluid(this.m_7993_().m_41720_());
    }

    public boolean addFluid(Fluid fluid) {
        if (!this.m_6657_()) {
            Item item = FluidsNF.getAsItem(fluid);
            if (item != null) {
                this.m_5852_(new ItemStack((ItemLike)item));
                return true;
            }
        } else {
            ItemStack stack = this.m_7993_();
            if (stack.m_41613_() < this.m_5866_(stack)) {
                stack.m_41769_(1);
                this.m_5852_(stack);
                return true;
            }
        }
        return false;
    }

    public boolean removeFluid(Fluid fluid) {
        if (fluid != FluidsNF.getAsFluid(this.m_7993_().m_41720_())) {
            return false;
        }
        this.m_6201_(1);
        return true;
    }

    public void m_142406_(Player pPlayer, ItemStack pStack) {
        super.m_142406_(pPlayer, pStack);
        if (FluidsNF.getAsFluid(pStack.m_41720_()) != Fluids.f_76191_) {
            pStack.m_41764_(0);
        }
    }

    public boolean m_5857_(ItemStack pStack) {
        Fluid fluid = this.getFluid();
        Item item = pStack.m_41720_();
        if (item instanceof EmptyBucketItem) {
            EmptyBucketItem bucket = (EmptyBucketItem)item;
            return fluid != Fluids.f_76191_ && FluidsNF.getFilledBucket(bucket, fluid) != null;
        }
        item = pStack.m_41720_();
        if (item instanceof FilledBucketItem) {
            FilledBucketItem bucket = (FilledBucketItem)item;
            ItemStack item2 = this.m_7993_();
            return item2.m_41619_() || bucket.getFluid() == fluid && item2.m_41613_() < Math.min(this.m_6641_(), item2.m_41741_());
        }
        return !this.fluidOnly;
    }

    public void m_5852_(ItemStack pStack) {
        Fluid fluid = this.getFluid();
        Item item = pStack.m_41720_();
        if (item instanceof EmptyBucketItem) {
            EmptyBucketItem emptyBucket = (EmptyBucketItem)item;
            ItemStack filledBucket = FluidsNF.getFilledBucket(emptyBucket, fluid);
            if (!filledBucket.m_41619_() && this.removeFluid(fluid)) {
                if (pStack.m_41613_() > 1) {
                    pStack.m_41774_(1);
                    this.player.m_150109_().m_150079_(filledBucket);
                    this.menu.m_142503_(pStack);
                } else {
                    pStack = filledBucket;
                    this.menu.m_142503_(pStack);
                }
                return;
            }
        } else {
            FilledBucketItem filledBucket;
            item = pStack.m_41720_();
            if (item instanceof FilledBucketItem && this.addFluid((filledBucket = (FilledBucketItem)item).getFluid())) {
                pStack.m_41774_(1);
                pStack = filledBucket.getContainerItem(pStack);
                if (!inInsert && this.menu.m_142621_().m_41619_()) {
                    this.player.m_150109_().m_150079_(pStack);
                } else {
                    this.menu.m_142503_(filledBucket.getContainerItem(pStack));
                }
                return;
            }
        }
        super.m_5852_(pStack);
    }

    public ItemStack m_150656_(ItemStack pStack, int pIncrement) {
        inInsert = true;
        ItemStack originalCarry = this.menu.m_142621_().m_41777_();
        ItemStack newCarry = super.m_150656_(pStack, pIncrement);
        inInsert = false;
        Item item = originalCarry.m_41720_();
        if (item instanceof FilledBucketItem) {
            FilledBucketItem filledBucket = (FilledBucketItem)item;
            if (!originalCarry.equals(newCarry, false)) {
                return filledBucket.getContainerItem(originalCarry);
            }
        }
        return newCarry;
    }
}

