/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerNF
extends ItemStackHandler {
    public ItemStackHandlerNF() {
    }

    public ItemStackHandlerNF(int size) {
        super(size);
    }

    public ItemStackHandlerNF(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public ItemStackHandlerNF(ItemStack item) {
        this((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{item}));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            this.stacks.set(slot, (Object)ItemStack.f_41583_);
            this.onContentsChanged(slot);
            this.stacks.set(slot, (Object)existing);
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        } else {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
            this.stacks.set(slot, (Object)existing);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public boolean contains(Ingredient ingredient) {
        for (ItemStack stack : this.stacks) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.stacks.clear();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.stacks.set(slot, (Object)ItemStack.f_41583_);
            this.onContentsChanged(slot);
        }
    }

    public void transferToPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.m_6084_() || serverPlayer.m_9232_()) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    player.m_36176_(this.extractItemNoUpdate(i), false);
                }
            } else {
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < this.stacks.size(); ++i) {
                    inventory.m_150079_(this.extractItemNoUpdate(i));
                }
                serverPlayer.f_36095_.m_38946_();
            }
        }
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public boolean isFull() {
        return this.hasItemsUpTo(this.stacks.size() - 1);
    }

    public boolean hasItemsUpTo(int slot) {
        for (int i = 0; i <= slot; ++i) {
            if (!((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack extractItemNoUpdate(int slot) {
        this.validateSlotIndex(slot);
        ItemStack item = (ItemStack)this.stacks.get(slot);
        this.stacks.set(slot, (Object)ItemStack.f_41583_);
        return item;
    }

    public NonNullList<ItemStack> copyItems() {
        return NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])this.stacks.toArray((Object[])new ItemStack[0])));
    }
}

