/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import frostnox.nightfall.item.item.FilledBucketItem;
import frostnox.nightfall.registry.forge.FluidsNF;
import frostnox.nightfall.world.inventory.CapacitySlot;
import frostnox.nightfall.world.inventory.FluidSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class PartialInventoryContainer
extends AbstractContainerMenu {
    protected final boolean quickMoveSingleItem;

    protected PartialInventoryContainer(@Nullable MenuType<?> pMenuType, Inventory playerInv, int pContainerId, boolean quickMoveSingleItem) {
        this(pMenuType, playerInv, pContainerId, 8, 84, quickMoveSingleItem);
    }

    protected PartialInventoryContainer(@Nullable MenuType<?> pMenuType, Inventory playerInv, int pContainerId, int xOff, int yOff, boolean quickMoveSingleItem) {
        super(pMenuType, pContainerId);
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                if (c < 5) {
                    this.m_38897_(new Slot((Container)playerInv, c + r * 9 + 9, xOff + c * 18, yOff + r * 18));
                    continue;
                }
                this.m_38897_(new CapacitySlot(r * 4 + c - 5, playerInv, c + r * 9 + 9, xOff + c * 18, yOff + r * 18));
            }
        }
        for (int c = 0; c < 9; ++c) {
            this.m_38897_(new Slot((Container)playerInv, c, xOff + c * 18, yOff + 58));
        }
        this.quickMoveSingleItem = quickMoveSingleItem;
    }

    protected boolean moveBucketTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot instanceof FluidSlot && slot.m_5857_(pStack)) {
                slot.m_5852_(pStack);
            }
            if (pReverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(pStack)) {
                    if (pStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(pStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemCopy = slotItem.m_41777_();
            slot.m_142406_(player, slotItem);
            if (slotItem.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (index < 36) {
                if (slotItem.m_41720_() instanceof FilledBucketItem) {
                    if (!this.moveBucketTo(slotItem, 36, this.f_38839_.size(), false)) {
                        return ItemStack.f_41583_;
                    }
                    if (this.quickMoveSingleItem) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    if (!this.m_38903_(slotItem, 36, this.f_38839_.size(), false)) {
                        return ItemStack.f_41583_;
                    }
                    if (this.quickMoveSingleItem) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(slotItem, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_6654_();
        }
        return itemCopy;
    }

    public void m_142503_(ItemStack pStack) {
        if (FluidsNF.getAsFluid(pStack.m_41720_()) == Fluids.f_76191_) {
            super.m_142503_(pStack);
        }
    }
}

