/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import com.mojang.datafixers.util.Pair;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.CraftingRecipeNF;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import frostnox.nightfall.world.inventory.CapacitySlot;
import frostnox.nightfall.world.inventory.SearchSlot;
import frostnox.nightfall.world.inventory.SingleContainer;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class PlayerInventoryContainer
extends InventoryMenu {
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_FACE = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"item/empty_accessory_slot_face");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_NECK = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"item/empty_accessory_slot_neck");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_WAIST = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"item/empty_accessory_slot_waist");
    public static final ResourceLocation EMPTY_RECIPE_SEARCH_SLOT = ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"item/empty_recipe_search_slot");
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{f_39696_, f_39695_, f_39694_, f_39693_, EMPTY_ACCESSORY_SLOT_FACE, EMPTY_ACCESSORY_SLOT_NECK, EMPTY_ACCESSORY_SLOT_WAIST};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final CraftingContainer craftSlots = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    public final SingleContainer searchSlots = new SingleContainer();
    private final Player owner;

    public PlayerInventoryContainer(Inventory playerInv, boolean serverSide) {
        super(playerInv, serverSide, playerInv.f_35978_);
        this.f_38839_.clear();
        this.f_38841_.clear();
        this.f_150394_.clear();
        this.owner = playerInv.f_35978_;
        this.m_38897_((Slot)new ResultSlot(playerInv.f_35978_, this.craftSlots, (Container)this.resultSlots, 0, 151, 44){

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                this.m_5845_(pStack);
                ForgeHooks.setCraftingPlayer((Player)pPlayer);
                NonNullList remainders = pPlayer.f_19853_.m_7465_().m_44069_(CraftingRecipeNF.TYPE, (Container)this.f_40162_, pPlayer.f_19853_);
                ForgeHooks.setCraftingPlayer(null);
                for (int i = 0; i < remainders.size(); ++i) {
                    ItemStack input = this.f_40162_.m_8020_(i);
                    ItemStack remainder = (ItemStack)remainders.get(i);
                    if (!input.m_41619_()) {
                        if (input.m_41783_() != null && input.m_41783_().m_128441_("Damage")) {
                            input.m_41629_(1, pPlayer.f_19853_.m_5822_(), null);
                            if (input.m_41773_() >= input.m_41776_()) {
                                this.f_40162_.m_7407_(i, 1);
                            }
                        } else {
                            this.f_40162_.m_7407_(i, 1);
                        }
                        input = this.f_40162_.m_8020_(i);
                    }
                    if (remainder.m_41619_()) continue;
                    if (input.m_41619_()) {
                        this.f_40162_.m_6836_(i, remainder);
                        continue;
                    }
                    if (ItemStack.m_41746_((ItemStack)input, (ItemStack)remainder) && ItemStack.m_41658_((ItemStack)input, (ItemStack)remainder)) {
                        remainder.m_41769_(input.m_41613_());
                        this.f_40162_.m_6836_(i, remainder);
                        continue;
                    }
                    if (pPlayer.m_150109_().m_36054_(remainder)) continue;
                    pPlayer.m_36176_(remainder, false);
                }
            }
        });
        int craftX = 96;
        int craftY = 26;
        this.m_38897_(new Slot((Container)this.craftSlots, 0, craftX, craftY));
        this.m_38897_(new Slot((Container)this.craftSlots, 1, craftX + 18, craftY));
        this.m_38897_(new Slot((Container)this.craftSlots, 3, craftX, craftY + 18));
        this.m_38897_(new Slot((Container)this.craftSlots, 4, craftX + 18, craftY + 18));
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot((Container)playerInv, 39 - k, 8, 8 + k * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (Entity)PlayerInventoryContainer.this.owner);
                }

                public boolean m_8010_(Player p_39744_) {
                    ItemStack item = this.m_7993_();
                    return !item.m_41619_() && !p_39744_.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)item) ? false : super.m_8010_(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (j < 5) {
                    this.m_38897_(new Slot((Container)playerInv, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
                    continue;
                }
                this.m_38897_(new CapacitySlot(i * 4 + j - 5, playerInv, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInv, i1, 8 + i1 * 18, 142));
        }
        this.m_38897_(new Slot((Container)playerInv, 40, 75, 62){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        AccessoryInventory accessoryInventory = PlayerData.get(this.owner).getAccessoryInventory();
        for (int i = 0; i < 3; ++i) {
            final AccessorySlot accessorySlot = AccessorySlot.values()[i];
            this.m_38897_(new Slot(accessoryInventory, i, 75, 8 + 18 * i){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack p_39746_) {
                    return accessorySlot.acceptsItem(p_39746_);
                }

                public boolean m_8010_(Player p_39744_) {
                    ItemStack item = this.m_7993_();
                    return !item.m_41619_() && !p_39744_.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)item) ? false : super.m_8010_(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[4 + accessorySlot.ordinal()]);
                }
            });
        }
        this.m_38897_(new Slot((Container)this.craftSlots, 2, craftX + 36, craftY + 0));
        this.m_38897_(new Slot((Container)this.craftSlots, 5, craftX + 36, craftY + 18));
        this.m_38897_(new Slot((Container)this.craftSlots, 6, craftX + 0, craftY + 36));
        this.m_38897_(new Slot((Container)this.craftSlots, 7, craftX + 18, craftY + 36));
        this.m_38897_(new Slot((Container)this.craftSlots, 8, craftX + 36, craftY + 36));
        this.m_38897_(new SearchSlot(this.searchSlots, !serverSide, 0, -104, -16){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_RECIPE_SEARCH_SLOT);
            }
        });
    }

    public ItemStack getSearchItem() {
        return this.searchSlots.m_8020_(0);
    }

    public void m_5816_(StackedContents pItemHelper) {
        this.craftSlots.m_5809_(pItemHelper);
    }

    public void m_6650_() {
        this.resultSlots.m_6211_();
        this.craftSlots.m_6211_();
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> pRecipe) {
        return pRecipe.m_5818_((Container)this.craftSlots, this.owner.f_19853_);
    }

    public void m_6199_(Container pInventory) {
        ForgeHooks.setCraftingPlayer((Player)this.owner);
        PlayerInventoryContainer.slotChangedCraftingGrid((AbstractContainerMenu)this, this.owner.f_19853_, this.owner, this.craftSlots, this.resultSlots);
        ForgeHooks.setCraftingPlayer(null);
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu p_150547_, Level p_150548_, Player p_150549_, CraftingContainer p_150550_, ResultContainer p_150551_) {
        if (!p_150548_.f_46443_) {
            CraftingRecipe craftingrecipe;
            ServerPlayer serverplayer = (ServerPlayer)p_150549_;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = p_150548_.m_142572_().m_129894_().m_44015_(CraftingRecipeNF.TYPE, (Container)p_150550_, p_150548_);
            if (optional.isPresent() && p_150551_.m_40135_(p_150548_, serverplayer, (Recipe)(craftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = craftingrecipe.m_5874_((Container)p_150550_);
            }
            p_150551_.m_6836_(0, itemstack);
            p_150547_.m_150404_(0, itemstack);
            serverplayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(p_150547_.f_38840_, p_150547_.m_182425_(), 0, itemstack));
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.resultSlots.m_6211_();
        if (!pPlayer.f_19853_.f_46443_) {
            this.m_150411_(pPlayer, (Container)this.craftSlots);
            this.m_150411_(pPlayer, this.searchSlots);
        }
    }

    public void clearSearchSlot() {
        this.m_150411_(this.owner, this.searchSlots);
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (pIndex == 0) {
                if (!this.m_38903_(itemstack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex >= 1 && pIndex < 9 || pIndex >= 46 && pIndex <= 50 ? !this.m_38903_(itemstack1, 9, 45, false) : (equipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(8 - equipmentslot.m_20749_())).m_6657_() ? !this.m_38903_(itemstack1, i = 8 - equipmentslot.m_20749_(), i + 1, false) : (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(45)).m_6657_() ? !this.m_38903_(itemstack1, 45, 46, false) : (itemstack.m_204117_(TagsNF.ACCESSORY_FACE) && !((Slot)this.f_38839_.get(46)).m_6657_() ? !this.m_38903_(itemstack1, 46, 47, false) : (itemstack.m_204117_(TagsNF.ACCESSORY_NECK) && !((Slot)this.f_38839_.get(47)).m_6657_() ? !this.m_38903_(itemstack1, 47, 48, false) : (itemstack.m_204117_(TagsNF.ACCESSORY_WAIST) && !((Slot)this.f_38839_.get(48)).m_6657_() ? !this.m_38903_(itemstack1, 48, 49, false) : (pIndex >= 9 && pIndex < 36 ? !this.m_38903_(itemstack1, 36, 45, false) : (pIndex >= 36 && pIndex < 45 ? !this.m_38903_(itemstack1, 9, 36, false) : !this.m_38903_(itemstack1, 9, 45, false))))))))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            if (pIndex == 0) {
                pPlayer.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultSlots && super.m_5882_(pStack, pSlot);
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return this.craftSlots.m_39347_();
    }

    public int m_6656_() {
        return this.craftSlots.m_39346_();
    }

    public int m_6653_() {
        return 10;
    }

    public CraftingContainer m_39730_() {
        return this.craftSlots;
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int p_150591_) {
        return p_150591_ != this.m_6636_();
    }
}

