/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.inventory;

import frostnox.nightfall.block.block.MenuContainerBlockEntity;
import frostnox.nightfall.block.block.barrel.BarrelBlockEntityNF;
import frostnox.nightfall.block.block.cauldron.CauldronBlockEntity;
import frostnox.nightfall.block.block.pot.PotBlockEntity;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.registry.forge.ContainersNF;
import frostnox.nightfall.world.inventory.FluidSlot;
import frostnox.nightfall.world.inventory.ItemStackHandlerNF;
import frostnox.nightfall.world.inventory.PartialInventoryContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public class StorageContainer
extends PartialInventoryContainer {
    public final MenuContainerBlockEntity entity;

    protected StorageContainer(@Nullable MenuType<?> pMenuType, Inventory playerInv, int pContainerId, MenuContainerBlockEntity entity, int rows, int columns, int xOff, int yOff) {
        this(pMenuType, playerInv, pContainerId, entity, (inventory, menu, player, index, xPosition, yPosition) -> new SlotItemHandler((IItemHandler)inventory, index, xPosition, yPosition), rows, columns, xOff, yOff, 8, 84, false);
    }

    protected StorageContainer(@Nullable MenuType<?> pMenuType, Inventory playerInv, int pContainerId, MenuContainerBlockEntity entity, ISlotFactory slotFactory, int rows, int columns, int xOff, int yOff) {
        this(pMenuType, playerInv, pContainerId, entity, slotFactory, rows, columns, xOff, yOff, 8, 84, false);
    }

    protected StorageContainer(@Nullable MenuType<?> pMenuType, Inventory playerInv, int pContainerId, MenuContainerBlockEntity entity, ISlotFactory slotFactory, int rows, int columns, int xOff, int yOff, int invXOff, int invYOff, boolean quickMoveSingleItem) {
        super(pMenuType, playerInv, pContainerId, invXOff, invYOff, quickMoveSingleItem);
        this.entity = entity;
        ItemStackHandlerNF inv = entity.getInventory();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                this.m_38897_(slotFactory.create(inv, this, playerInv.f_35978_, c + r * columns, xOff + c * 18, yOff + r * 18));
            }
        }
        entity.m_5856_(playerInv.f_35978_);
        if (entity.getData() != null) {
            this.m_38884_(entity.getData());
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.entity.m_5785_(pPlayer);
    }

    public boolean m_6875_(Player pPlayer) {
        return this.entity.m_6542_(pPlayer);
    }

    public static StorageContainer createBarrelContainer(int windowID, Inventory playerInv, FriendlyByteBuf extraData) {
        return StorageContainer.createBarrelContainer(windowID, playerInv, playerInv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public static StorageContainer createBarrelContainer(int windowID, Inventory playerInv, BlockEntity entity) {
        if (entity instanceof BarrelBlockEntityNF) {
            BarrelBlockEntityNF containerEntity = (BarrelBlockEntityNF)entity;
            return new StorageContainer((MenuType)ContainersNF.BARREL.get(), playerInv, windowID, containerEntity, (inventory, menu, player, index, xPosition, yPosition) -> new FluidSlot((IItemHandler)inventory, menu, player, index, xPosition, yPosition, false), 4, 3, 62, 28, 8, 104, false);
        }
        return StorageContainer.createContainerException(entity);
    }

    public static StorageContainer createCauldronContainer(int windowID, Inventory playerInv, FriendlyByteBuf extraData) {
        return StorageContainer.createCauldronContainer(windowID, playerInv, playerInv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public static StorageContainer createCauldronContainer(int windowID, Inventory playerInv, BlockEntity entity) {
        if (entity instanceof CauldronBlockEntity) {
            final CauldronBlockEntity containerEntity = (CauldronBlockEntity)entity;
            return new StorageContainer((MenuType)ContainersNF.CAULDRON.get(), playerInv, windowID, containerEntity, (inventory, menu, player, index, xPosition, yPosition) -> new FluidSlot((IItemHandler)inventory, menu, player, index, xPosition, yPosition, true){

                @Override
                public boolean m_5857_(ItemStack pStack) {
                    return pStack.m_204117_(TagsNF.FOOD_INGREDIENT) || super.m_5857_(pStack);
                }

                public int m_5866_(ItemStack pStack) {
                    return 1;
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_6659_() {
                    return !containerEntity.hasMeal();
                }
            }, 2, 2, 71, 19);
        }
        return StorageContainer.createContainerException(entity);
    }

    public static StorageContainer createPotContainer(int windowID, Inventory playerInv, FriendlyByteBuf extraData) {
        return StorageContainer.createPotContainer(windowID, playerInv, playerInv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public static StorageContainer createPotContainer(int windowID, Inventory playerInv, BlockEntity entity) {
        if (entity instanceof PotBlockEntity) {
            PotBlockEntity containerEntity = (PotBlockEntity)entity;
            return new StorageContainer((MenuType)ContainersNF.POT.get(), playerInv, windowID, containerEntity, 4, 4, 53, 8);
        }
        return StorageContainer.createContainerException(entity);
    }

    private static StorageContainer createContainerException(@Nullable BlockEntity entity) {
        if (entity == null) {
            throw new IllegalStateException("Null storage container entity");
        }
        throw new IllegalStateException("Invalid storage container entity " + entity.m_58903_() + " at " + entity.m_58899_());
    }

    public static interface ISlotFactory {
        public Slot create(ItemStackHandlerNF var1, StorageContainer var2, Player var3, int var4, int var5, int var6);
    }
}

