/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.spawngroup;

import frostnox.nightfall.world.spawngroup.SpawnGroup;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BiomeTagSpawnGroup
extends SpawnGroup {
    protected final EntityType<?> type;
    protected final int yMin;
    protected final int yMax;
    protected final int lightMin;
    protected final int lightMax;
    protected final int sizeMin;
    protected final int sizeRand;
    protected final TagKey<Biome> biomeTag;

    public BiomeTagSpawnGroup(int weight, boolean friendly, EntityType<?> type, int yMin, int yMax, int lightMin, int lightMax, int sizeMin, int sizeMax, TagKey<Biome> biomeTag) {
        super(weight, friendly);
        this.type = type;
        this.yMin = yMin;
        this.yMax = yMax;
        this.lightMin = lightMin;
        this.lightMax = lightMax;
        this.sizeMin = sizeMin;
        this.biomeTag = biomeTag;
        this.sizeRand = sizeMax - sizeMin + 1;
    }

    @Override
    public boolean canSpawnAt(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        return pos.m_123342_() >= this.yMin && pos.m_123342_() <= this.yMax && skyLight >= this.lightMin && skyLight <= this.lightMax && level.m_204166_(pos).m_203656_(this.biomeTag);
    }

    @Override
    public EntityType<?>[] createGroup(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        Object[] group = new EntityType[this.sizeRand == 1 ? this.sizeMin : this.sizeMin + level.f_46441_.nextInt(this.sizeRand)];
        Arrays.fill(group, this.type);
        return group;
    }

    @Override
    @Nullable
    public SpawnGroupData getGroupData(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity, int groupSize) {
        return null;
    }
}

