/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.spawngroup;

import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.spawngroup.VariedLandSpawnGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DrakefowlSpawnGroup
extends VariedLandSpawnGroup {
    public DrakefowlSpawnGroup(int weight, boolean friendly, int yMin, int yMax, int lightMin, int lightMax, float tempMin, float tempMax, float humidityMin, float humidityMax, TagKey<Block> spawnBlocks) {
        super(weight, friendly, yMin, yMax, lightMin, lightMax, tempMin, tempMax, humidityMin, humidityMax, spawnBlocks);
    }

    @Override
    public EntityType<?>[] createGroup(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        EntityType[] group;
        switch (Season.get((Level)level)) {
            case SPRING: {
                if (level.f_46441_.nextInt() % 3 == 0) {
                    if (level.f_46441_.nextInt() % 10 == 0) {
                        group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_HEN.get()};
                        break;
                    }
                    group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get()};
                    break;
                }
                group = new EntityType[2 + level.f_46441_.nextInt(3)];
                group[0] = (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get();
                for (int i = 1; i < group.length; ++i) {
                    group[i] = (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                }
                break;
            }
            case SUMMER: {
                if (level.f_46441_.nextInt() % 5 == 0) {
                    if (level.f_46441_.nextBoolean()) {
                        group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_HEN.get()};
                        break;
                    }
                    group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get()};
                    break;
                }
                if (level.f_46441_.nextBoolean()) {
                    group = new EntityType[1 + level.f_46441_.nextInt(4)];
                    group[0] = (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                    for (int i = 1; i < group.length; ++i) {
                        group[i] = level.f_46441_.nextBoolean() ? (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get() : (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                    }
                } else {
                    group = new EntityType[2 + level.f_46441_.nextInt(4)];
                    group[0] = (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                    group[1] = (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get();
                    for (int i = 2; i < group.length; ++i) {
                        group[i] = level.f_46441_.nextBoolean() ? (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get() : (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                    }
                }
                break;
            }
            default: {
                if (level.f_46441_.nextInt() % 10 == 0) {
                    if (level.f_46441_.nextBoolean()) {
                        group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_HEN.get()};
                        break;
                    }
                    group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get()};
                    break;
                }
                group = new EntityType[2 + level.f_46441_.nextInt(3)];
                group[0] = (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                group[1] = (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get();
                for (int i = 2; i < group.length; ++i) {
                    group[i] = level.f_46441_.nextInt() % 3 == 0 ? (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get() : (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                }
                break;
            }
            case WINTER: {
                if (level.f_46441_.nextInt() % 20 == 0) {
                    if (level.f_46441_.nextBoolean()) {
                        group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_HEN.get()};
                        break;
                    }
                    group = new EntityType[]{(EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get()};
                    break;
                }
                group = new EntityType[2 + level.f_46441_.nextInt(3)];
                group[0] = (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                group[1] = (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get();
                for (int i = 2; i < group.length; ++i) {
                    group[i] = level.f_46441_.nextInt() % 8 == 0 ? (EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get() : (EntityType)EntitiesNF.DRAKEFOWL_HEN.get();
                }
            }
        }
        return group;
    }
}

