/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.spawngroup;

import frostnox.nightfall.entity.entity.ambient.JellyfishEntity;
import frostnox.nightfall.world.MoonPhase;
import frostnox.nightfall.world.spawngroup.OceanSpawnGroup;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.block.state.BlockState;

public class JellyfishSpawnGroup
extends OceanSpawnGroup {
    public JellyfishSpawnGroup(int weight, boolean friendly, EntityType<?> type, int yMin, int yMax, int lightMin, int lightMax, int sizeMin, int sizeMax, float tempMin, float tempMax, float humidityMin, float humidityMax) {
        super(weight, friendly, type, yMin, yMax, lightMin, lightMax, sizeMin, sizeMax, tempMin, tempMax, humidityMin, humidityMax);
    }

    @Override
    public EntityType<?>[] createGroup(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        int adjustedRand = this.sizeRand - (int)((1.0f - temperature) * 5.0f);
        Object[] group = new EntityType[adjustedRand <= 1 ? this.sizeMin : this.sizeMin + level.f_46441_.nextInt(adjustedRand)];
        Arrays.fill(group, this.type);
        return group;
    }

    @Override
    @Nullable
    public SpawnGroupData getGroupData(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity, int groupSize) {
        int[] weight = new int[]{1, 1, 1, 1};
        MoonPhase moonPhase = MoonPhase.get((LevelTimeAccess)level);
        if (temperature < 0.4f) {
            weight[0] = weight[0] + 1;
        }
        if (moonPhase == MoonPhase.FULL) {
            weight[0] = weight[0] + 2;
        } else if (moonPhase.fullness >= 0.75f) {
            weight[0] = weight[0] + 1;
        }
        if (temperature < 0.55f) {
            weight[1] = weight[1] + 1;
        }
        if (temperature > 0.75f) {
            weight[2] = weight[2] + 1;
        }
        if (temperature > 0.6f) {
            weight[3] = weight[3] + 1;
        }
        int sum = 0;
        for (int w : weight) {
            sum += w;
        }
        int rand = level.f_46441_.nextInt(sum);
        int cumulativeWeight = 0;
        JellyfishEntity.Type type = JellyfishEntity.Type.MOON;
        for (int i = 0; i < weight.length; ++i) {
            if (rand >= (cumulativeWeight += weight[i])) continue;
            type = JellyfishEntity.Type.values()[i];
            break;
        }
        return new JellyfishEntity.GroupData(type, level.f_46441_.nextInt());
    }
}

