/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.world.spawngroup;

import frostnox.nightfall.world.spawngroup.SpawnGroup;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SimpleSpawnGroup
extends SpawnGroup {
    protected final EntityType<?> type;
    protected final int yMin;
    protected final int yMax;
    protected final int lightMin;
    protected final int lightMax;
    protected final int sizeMin;
    protected final int sizeRand;
    protected final float tempMin;
    protected final float tempMax;
    protected final float humidityMin;
    protected final float humidityMax;

    public SimpleSpawnGroup(int weight, boolean friendly, EntityType<?> type, int yMin, int yMax, int lightMin, int lightMax, int sizeMin, int sizeMax, float tempMin, float tempMax, float humidityMin, float humidityMax) {
        super(weight, friendly);
        this.type = type;
        this.yMin = yMin;
        this.yMax = yMax;
        this.lightMin = lightMin;
        this.lightMax = lightMax;
        this.sizeMin = sizeMin;
        this.sizeRand = sizeMax - sizeMin + 1;
        this.tempMin = tempMin;
        this.tempMax = tempMax;
        this.humidityMin = humidityMin;
        this.humidityMax = humidityMax;
    }

    @Override
    public boolean canSpawnAt(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        return pos.m_123342_() >= this.yMin && pos.m_123342_() <= this.yMax && temperature >= this.tempMin && temperature <= this.tempMax && skyLight >= this.lightMin && skyLight <= this.lightMax && humidity >= this.humidityMin && humidity <= this.humidityMax;
    }

    @Override
    public EntityType<?>[] createGroup(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity) {
        Object[] group = new EntityType[this.sizeRand == 1 ? this.sizeMin : this.sizeMin + level.f_46441_.nextInt(this.sizeRand)];
        Arrays.fill(group, this.type);
        return group;
    }

    @Override
    @Nullable
    public SpawnGroupData getGroupData(ServerLevel level, BlockPos pos, BlockState block, int skyLight, float temperature, float humidity, int groupSize) {
        return null;
    }
}

