/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.block.custom;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class RNBBlock
extends class_2248 {
    private static final Vector3f[] HELLISH_COLORS = new Vector3f[]{new Vector3f(1.0f, 0.2f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(0.3f, 0.1f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 0.5f)};

    public RNBBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608()) {
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14703, class_3419.field_15245, 1.2f, 0.7f);
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15102, class_3419.field_15245, 1.0f, 0.5f);
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14576, class_3419.field_15245, 0.8f, 1.5f);
            this.executeEffects(world, pos);
        } else {
            this.spawnActivationParticles(world, pos);
        }
        return class_1269.field_5812;
    }

    private void executeEffects(class_1937 world, class_2338 centerPos) {
        this.convertNetherrackToRedGlass(world, centerPos);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.clearLayerWithDelay(serverWorld, centerPos.method_10086(2), 0, 0);
        }
    }

    private void clearLayerWithDelay(class_3218 world, class_2338 layerCenter, int delayTicks, int layerIndex) {
        world.method_8503().execute(() -> {
            try {
                Thread.sleep((long)delayTicks * 50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.clearLayerImmediately(world, layerCenter, layerIndex, false);
            if (layerIndex < 10) {
                class_2338 nextLayer = layerCenter.method_10087(1);
                this.clearLayerWithDelay(world, nextLayer, 10, layerIndex + 1);
            } else {
                this.clearGlassLayersWithEffects(world, layerCenter.method_10087(1));
            }
        });
    }

    private void clearGlassLayersWithEffects(class_3218 world, class_2338 centerPos) {
        this.spawnGlassWarningEffects(world, centerPos);
        world.method_8503().execute(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            for (int yOffset = -8; yOffset <= 2; ++yOffset) {
                class_2338 layerCenter = centerPos.method_10086(yOffset);
                this.clearLayerImmediately(world, layerCenter, 0, true);
            }
            world.method_8501(centerPos, class_2246.field_10124.method_9564());
            this.spawnFinalExplosion(world, centerPos);
        });
    }

    private void spawnGlassWarningEffects(class_3218 world, class_2338 center) {
        for (int i = 0; i < 50; ++i) {
            class_2338 randomPos = center.method_10069(world.field_9229.method_43048(5) - 2, world.field_9229.method_43048(11) - 8, world.field_9229.method_43048(5) - 2);
            if (world.method_8320(randomPos).method_26204() != class_2246.field_10272) continue;
            world.method_14199((class_2394)class_2398.field_29644, (double)randomPos.method_10263() + 0.5, (double)randomPos.method_10264() + 0.5, (double)randomPos.method_10260() + 0.5, 3, 0.1, 0.1, 0.1, 0.05);
        }
        world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), class_3417.field_14583, class_3419.field_15245, 1.5f, 0.5f);
        world.method_43128(null, (double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), class_3417.field_17265, class_3419.field_15245, 1.0f, 0.8f);
    }

    private void clearLayerImmediately(class_3218 world, class_2338 layerCenter, int layerIndex, boolean clearOnlyGlass) {
        class_2338.method_20437((class_2338)layerCenter.method_10069(-2, 0, -2), (class_2338)layerCenter.method_10069(2, 0, 2)).forEach(pos -> {
            class_2680 state = world.method_8320(pos);
            if (!clearOnlyGlass && !state.method_26215() && state.method_26204() != class_2246.field_10272 || clearOnlyGlass && state.method_26204() == class_2246.field_10272) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
                this.addEnhancedDestructionParticles(world, (class_2338)pos, layerIndex, clearOnlyGlass);
                this.playDestructionSound(world, (class_2338)pos, clearOnlyGlass);
            }
        });
    }

    private void addEnhancedDestructionParticles(class_3218 world, class_2338 pos, int layerIndex, boolean isGlass) {
        Vector3f color = HELLISH_COLORS[layerIndex % HELLISH_COLORS.length];
        world.method_14199((class_2394)new class_2390(color, isGlass ? 2.0f : 1.0f), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, isGlass ? 15 : 5, 0.3, 0.3, 0.3, 0.1);
        world.method_14199((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, isGlass ? 8 : 3, 0.2, 0.2, 0.2, 0.1);
        if (isGlass) {
            world.method_14199((class_2394)class_2398.field_28479, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.2, 0.2, 0.2, 0.2);
        }
        if (world.field_9229.method_43048(isGlass ? 2 : 4) == 0) {
            world.method_14199((class_2394)class_2398.field_11236, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, isGlass ? 3 : 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void playDestructionSound(class_3218 world, class_2338 pos, boolean isGlass) {
        if (isGlass) {
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15081, class_3419.field_15245, 1.2f, 0.6f);
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_26980, class_3419.field_15245, 0.8f, 1.5f);
        } else {
            switch (world.field_9229.method_43048(3)) {
                case 0: {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15026, class_3419.field_15245, 0.7f, 0.6f);
                    break;
                }
                case 1: {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_21882, class_3419.field_15245, 0.8f, 0.7f);
                    break;
                }
                case 2: {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14576, class_3419.field_15245, 1.0f, 1.2f);
                }
            }
        }
    }

    private void convertNetherrackToRedGlass(class_1937 world, class_2338 centerPos) {
        class_2338.method_20437((class_2338)centerPos.method_10069(-2, -2, -2), (class_2338)centerPos.method_10069(2, 2, 2)).forEach(pos -> {
            if (world.method_8320(pos).method_26204() == class_2246.field_10515) {
                world.method_8501(pos, class_2246.field_10272.method_9564());
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    this.addConversionParticles(serverWorld, (class_2338)pos);
                }
            }
        });
    }

    private void addConversionParticles(class_3218 world, class_2338 pos) {
        world.method_14199((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.2, 0.2, 0.2, 0.1);
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            double x = (double)pos.method_10263() + 0.5 + Math.cos(angle) * 0.7;
            double z = (double)pos.method_10260() + 0.5 + Math.sin(angle) * 0.7;
            world.method_14199((class_2394)class_2398.field_11240, x, (double)pos.method_10264() + 0.3, z, 3, 0.05, 0.2, 0.05, 0.05);
        }
        world.method_14199((class_2394)class_2398.field_11237, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 5, 0.2, 0.2, 0.2, 0.05);
        world.method_14199((class_2394)class_2398.field_17909, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnActivationParticles(class_1937 world, class_2338 pos) {
        int i;
        for (i = 0; i < 30; ++i) {
            double theta = world.field_9229.method_43058() * Math.PI * 2.0;
            double r = world.field_9229.method_43058() * 1.2 + 0.3;
            double x = (double)pos.method_10263() + 0.5 + Math.cos(theta) * r;
            double z = (double)pos.method_10260() + 0.5 + Math.sin(theta) * r;
            world.method_8406((class_2394)class_2398.field_11240, x, (double)pos.method_10264() + 0.5, z, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 15; ++i) {
            world.method_8406((class_2394)class_2398.field_11223, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, world.field_9229.method_43059() * 0.1, 0.3 + (double)world.field_9229.method_43057() * 0.3, world.field_9229.method_43059() * 0.1);
        }
        for (i = 0; i < 10; ++i) {
            world.method_8406((class_2394)class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, world.field_9229.method_43059() * 0.2, (double)world.field_9229.method_43057() * -0.1, world.field_9229.method_43059() * 0.2);
        }
    }

    private void spawnFinalExplosion(class_3218 world, class_2338 pos) {
        int i;
        world.method_14199((class_2394)class_2398.field_11221, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 20, 1.0, 1.0, 1.0, 1.0);
        for (i = 0; i < HELLISH_COLORS.length; ++i) {
            Vector3f color = HELLISH_COLORS[i];
            world.method_14199((class_2394)new class_2390(color, 3.0f), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 50, 1.5, 1.5, 1.5, 0.5);
        }
        for (i = 0; i < 36; ++i) {
            double angle = Math.PI * 2 * (double)i / 36.0;
            double x = (double)pos.method_10263() + 0.5 + Math.cos(angle) * 3.0;
            double z = (double)pos.method_10260() + 0.5 + Math.sin(angle) * 3.0;
            world.method_14199((class_2394)class_2398.field_11240, x, (double)pos.method_10264() + 0.1, z, 5, 0.1, 0.0, 0.1, 0.1);
        }
        world.method_60511(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_6880)class_3417.field_15152, class_3419.field_15245, 2.0f, 0.8f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14671, class_3419.field_15245, 1.5f, 1.2f);
        world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_17265, class_3419.field_15245, 2.0f, 0.5f);
    }
}

