/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import s22.new_mod.entity.custom.HematicSerenityEntity;
import s22.new_mod.entity.custom.HimEntity;

public class HimCommand {
    private static final List<String> ENTITY_TYPES = Arrays.asList("him", "hematic_serenity");
    private static final List<String> HIM_SKILLS = Arrays.asList("dark_pulse", "shadow_rend", "summon_minions", "curse", "invisible", "enrage", "fly", "start_death_animation", "enrage_dark_pulse", "enrage_summon", "enrage_teleport", "enrage_explosion", "teleport_to_target");
    private static final List<String> HEMATIC_SKILLS = Arrays.asList("void_nova", "tentacle_lash", "cosmic_pool", "eldritch_gaze", "ritual_of_the_deep", "void_gaze", "void_rage", "start_death_animation", "void_rage_nova", "void_rage_tentacles", "void_rage_teleport", "void_rage_vortex", "void_rage_explosion");
    private static final SuggestionProvider<class_2168> ENTITY_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(ENTITY_TYPES, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> HIM_SKILL_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(HIM_SKILLS, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> HEMATIC_SKILL_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(HEMATIC_SKILLS, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"new-mod").then(class_2170.method_9247((String)"anger").then(class_2170.method_9244((String)"attacker", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).executes(HimCommand::executeAngerCommand))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entityType", (ArgumentType)StringArgumentType.word()).suggests(ENTITY_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String entityType = (String)context.getArgument("entityType", String.class);
            if ("hematic_serenity".equals(entityType)) {
                return HEMATIC_SKILL_SUGGESTION_PROVIDER.getSuggestions(context, builder);
            }
            return HIM_SKILL_SUGGESTION_PROVIDER.getSuggestions(context, builder);
        }).then(class_2170.method_9244((String)"tick", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(HimCommand::executeEntitySkill))))));
    }

    private static int executeAngerCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_2300 attackerSelector = (class_2300)class_2186.method_9317(context, (String)"attacker");
        class_2300 targetSelector = (class_2300)class_2186.method_9317(context, (String)"target");
        List attackers = attackerSelector.method_9816(source);
        List targets = targetSelector.method_9816(source);
        if (attackers.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u672a\u627e\u5230\u653b\u51fb\u8005\u5b9e\u4f53").method_27692(class_124.field_1061));
            return 0;
        }
        if (targets.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u672a\u627e\u5230\u76ee\u6807\u5b9e\u4f53").method_27692(class_124.field_1061));
            return 0;
        }
        int successCount = 0;
        for (class_1297 attackerEntity : attackers) {
            if (!(attackerEntity instanceof class_1308)) continue;
            class_1308 attacker = (class_1308)attackerEntity;
            for (class_1297 targetEntity : targets) {
                if (!(targetEntity instanceof class_1309)) continue;
                class_1309 target = (class_1309)targetEntity;
                attacker.method_5980(target);
                ++successCount;
                source.method_9226(() -> class_2561.method_43470((String)("\u8bbe\u7f6e " + attacker.method_5476().getString() + " \u4ec7\u6068\u76ee\u6807\u4e3a " + target.method_5476().getString())).method_27692(class_124.field_1060), false);
            }
        }
        if (successCount == 0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u672a\u80fd\u8bbe\u7f6e\u4efb\u4f55\u4ec7\u6068\u5173\u7cfb\uff08\u653b\u51fb\u8005\u5fc5\u987b\u662f\u53ef\u653b\u51fb\u7684\u751f\u7269\u5b9e\u4f53\uff09").method_27692(class_124.field_1061));
            return 0;
        }
        int finalSuccessCount = successCount;
        source.method_9226(() -> class_2561.method_43470((String)("\u6210\u529f\u8bbe\u7f6e " + finalSuccessCount + " \u4e2a\u4ec7\u6068\u5173\u7cfb")).method_27692(class_124.field_1060), true);
        return successCount;
    }

    private static int executeEntitySkill(CommandContext<class_2168> context) throws CommandSyntaxException {
        String entityType = StringArgumentType.getString(context, (String)"entityType");
        String skill = StringArgumentType.getString(context, (String)"skill");
        int delay = IntegerArgumentType.getInteger(context, (String)"tick");
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        if ("him".equals(entityType)) {
            return HimCommand.executeHimSkill(world, skill, delay, source);
        }
        if ("hematic_serenity".equals(entityType)) {
            return HimCommand.executeHematicSerenitySkill(world, skill, delay, source);
        }
        source.method_9213((class_2561)class_2561.method_43470((String)("\u672a\u77e5\u7684\u5b9e\u4f53\u7c7b\u578b: " + entityType)).method_27692(class_124.field_1061));
        return 0;
    }

    private static int executeHimSkill(class_3218 world, String skill, int delay, class_2168 source) {
        if (!HIM_SKILLS.contains(skill)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Him\u5b9e\u4f53\u672a\u77e5\u7684\u6280\u80fd: " + skill + "\u3002\u53ef\u7528\u6280\u80fd: " + String.join((CharSequence)", ", HIM_SKILLS))).method_27692(class_124.field_1061));
            return 0;
        }
        HimEntity himEntity = HimCommand.findNearestHimEntity(world, (class_1657)source.method_44023());
        if (himEntity == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u9644\u8fd1\u6ca1\u6709\u627e\u5230Him\u5b9e\u4f53").method_27692(class_124.field_1061));
            return 0;
        }
        if (delay == 0) {
            HimCommand.executeHimSkillImmediately(himEntity, skill, source);
        } else {
            HimCommand.scheduleDelayedHimSkill(world, himEntity, skill, delay, source);
        }
        return 1;
    }

    private static int executeHematicSerenitySkill(class_3218 world, String skill, int delay, class_2168 source) {
        if (!HEMATIC_SKILLS.contains(skill)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("HematicSerenity\u5b9e\u4f53\u672a\u77e5\u7684\u6280\u80fd: " + skill + "\u3002\u53ef\u7528\u6280\u80fd: " + String.join((CharSequence)", ", HEMATIC_SKILLS))).method_27692(class_124.field_1061));
            return 0;
        }
        HematicSerenityEntity hematicEntity = HimCommand.findNearestHematicSerenityEntity(world, (class_1657)source.method_44023());
        if (hematicEntity == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u9644\u8fd1\u6ca1\u6709\u627e\u5230HematicSerenity\u5b9e\u4f53").method_27692(class_124.field_1061));
            return 0;
        }
        if (delay == 0) {
            HimCommand.executeHematicSkillImmediately(hematicEntity, skill, source);
        } else {
            HimCommand.scheduleDelayedHematicSkill(world, hematicEntity, skill, delay, source);
        }
        return 1;
    }

    private static HimEntity findNearestHimEntity(class_3218 world, class_1657 player) {
        List entities = world.method_8390(HimEntity.class, player.method_5829().method_1014(100.0), entity -> true);
        if (entities.isEmpty()) {
            return null;
        }
        entities.sort((e1, e2) -> Double.compare(e1.method_5858((class_1297)player), e2.method_5858((class_1297)player)));
        return (HimEntity)((Object)entities.get(0));
    }

    private static HematicSerenityEntity findNearestHematicSerenityEntity(class_3218 world, class_1657 player) {
        List entities = world.method_8390(HematicSerenityEntity.class, player.method_5829().method_1014(100.0), entity -> true);
        if (entities.isEmpty()) {
            return null;
        }
        entities.sort((e1, e2) -> Double.compare(e1.method_5858((class_1297)player), e2.method_5858((class_1297)player)));
        return (HematicSerenityEntity)((Object)entities.get(0));
    }

    private static void executeHimSkillImmediately(HimEntity himEntity, String skill, class_2168 source) {
        boolean success = HimCommand.triggerHimSkill(himEntity, skill);
        if (success) {
            source.method_9226(() -> class_2561.method_43470((String)("Him\u5b9e\u4f53\u5df2\u7acb\u5373\u6267\u884c\u6280\u80fd: " + skill)).method_27692(class_124.field_1060), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)("Him\u5b9e\u4f53\u6280\u80fd\u6267\u884c\u5931\u8d25: " + skill)).method_27692(class_124.field_1061));
        }
    }

    private static void executeHematicSkillImmediately(HematicSerenityEntity hematicEntity, String skill, class_2168 source) {
        boolean success = HimCommand.triggerHematicSkill(hematicEntity, skill);
        if (success) {
            source.method_9226(() -> class_2561.method_43470((String)("HematicSerenity\u5b9e\u4f53\u5df2\u7acb\u5373\u6267\u884c\u6280\u80fd: " + skill)).method_27692(class_124.field_1060), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)("HematicSerenity\u5b9e\u4f53\u6280\u80fd\u6267\u884c\u5931\u8d25: " + skill)).method_27692(class_124.field_1061));
        }
    }

    private static void scheduleDelayedHimSkill(class_3218 world, HimEntity himEntity, String skill, int delay, class_2168 source) {
        world.method_8503().execute(() -> {
            try {
                Thread.sleep((long)delay * 50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            world.method_8503().execute(() -> {
                boolean success = HimCommand.triggerHimSkill(himEntity, skill);
                if (success) {
                    source.method_9226(() -> class_2561.method_43470((String)("Him\u5b9e\u4f53\u5728 " + delay + " \u523b\u540e\u6267\u884c\u4e86\u6280\u80fd: " + skill)).method_27692(class_124.field_1060), false);
                } else {
                    source.method_9213((class_2561)class_2561.method_43470((String)("Him\u5b9e\u4f53\u6280\u80fd\u6267\u884c\u5931\u8d25: " + skill)).method_27692(class_124.field_1061));
                }
            });
        });
        source.method_9226(() -> class_2561.method_43470((String)("\u5df2\u5b89\u6392Him\u5b9e\u4f53\u5728 " + delay + " \u523b\u540e\u6267\u884c\u6280\u80fd: " + skill)).method_27692(class_124.field_1054), false);
    }

    private static void scheduleDelayedHematicSkill(class_3218 world, HematicSerenityEntity hematicEntity, String skill, int delay, class_2168 source) {
        world.method_8503().execute(() -> {
            try {
                Thread.sleep((long)delay * 50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            world.method_8503().execute(() -> {
                boolean success = HimCommand.triggerHematicSkill(hematicEntity, skill);
                if (success) {
                    source.method_9226(() -> class_2561.method_43470((String)("HematicSerenity\u5b9e\u4f53\u5728 " + delay + " \u523b\u540e\u6267\u884c\u4e86\u6280\u80fd: " + skill)).method_27692(class_124.field_1060), false);
                } else {
                    source.method_9213((class_2561)class_2561.method_43470((String)("HematicSerenity\u5b9e\u4f53\u6280\u80fd\u6267\u884c\u5931\u8d25: " + skill)).method_27692(class_124.field_1061));
                }
            });
        });
        source.method_9226(() -> class_2561.method_43470((String)("\u5df2\u5b89\u6392HematicSerenity\u5b9e\u4f53\u5728 " + delay + " \u523b\u540e\u6267\u884c\u6280\u80fd: " + skill)).method_27692(class_124.field_1054), false);
    }

    private static boolean triggerHimSkill(HimEntity himEntity, String skill) {
        try {
            switch (skill) {
                case "dark_pulse": {
                    if (himEntity.method_5968() == null) break;
                    himEntity.darkPulseAttack(himEntity.method_5968());
                    break;
                }
                case "shadow_rend": {
                    if (himEntity.method_5968() == null) break;
                    himEntity.shadowRendAttack(himEntity.method_5968());
                    break;
                }
                case "summon_minions": {
                    himEntity.summonMinions();
                    break;
                }
                case "curse": {
                    if (himEntity.method_5968() == null) break;
                    himEntity.castCurse(himEntity.method_5968());
                    break;
                }
                case "invisible": {
                    himEntity.activateInvisibility();
                    break;
                }
                case "enrage": {
                    himEntity.triggerEnrage();
                    break;
                }
                case "fly": {
                    himEntity.startFlying();
                    break;
                }
                case "start_death_animation": {
                    himEntity.startDeathAnimation();
                    break;
                }
                case "enrage_dark_pulse": {
                    if (!himEntity.isEnraged() || himEntity.method_5968() == null) break;
                    himEntity.enrageDarkPulse();
                    break;
                }
                case "enrage_summon": {
                    if (!himEntity.isEnraged()) break;
                    himEntity.enrageSummon();
                    break;
                }
                case "enrage_teleport": {
                    if (!himEntity.isEnraged() || himEntity.method_5968() == null) break;
                    himEntity.enrageTeleport();
                    break;
                }
                case "enrage_explosion": {
                    if (!himEntity.isEnraged()) break;
                    himEntity.enrageSkillExplosion();
                    break;
                }
                case "teleport_to_target": {
                    if (himEntity.method_5968() == null) break;
                    HimEntity himEntity2 = himEntity;
                    Objects.requireNonNull(himEntity2);
                    HimEntity.TeleportToTargetGoal teleportGoal = new HimEntity.TeleportToTargetGoal(himEntity2, himEntity);
                    if (!teleportGoal.method_6264()) break;
                    teleportGoal.method_6269();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean triggerHematicSkill(HematicSerenityEntity hematicEntity, String skill) {
        try {
            switch (skill) {
                case "void_nova": {
                    hematicEntity.voidNovaAttack();
                    break;
                }
                case "tentacle_lash": {
                    if (hematicEntity.method_5968() == null) break;
                    hematicEntity.tentacleLashAttack(hematicEntity.method_5968());
                    break;
                }
                case "cosmic_pool": {
                    hematicEntity.createCosmicPool();
                    break;
                }
                case "eldritch_gaze": {
                    if (hematicEntity.method_5968() == null) break;
                    hematicEntity.castEldritchGaze(hematicEntity.method_5968());
                    break;
                }
                case "ritual_of_the_deep": {
                    hematicEntity.performRitualOfTheDeep();
                    break;
                }
                case "void_gaze": {
                    hematicEntity.castVoidGaze();
                    break;
                }
                case "void_rage": {
                    hematicEntity.triggerVoidRage();
                    break;
                }
                case "start_death_animation": {
                    hematicEntity.startDeathAnimation();
                    break;
                }
                case "void_rage_nova": {
                    if (!hematicEntity.isVoidRage()) break;
                    hematicEntity.voidRageNova();
                    break;
                }
                case "void_rage_tentacles": {
                    if (!hematicEntity.isVoidRage() || hematicEntity.method_5968() == null) break;
                    hematicEntity.voidRageTentacles();
                    break;
                }
                case "void_rage_teleport": {
                    if (!hematicEntity.isVoidRage() || hematicEntity.method_5968() == null) break;
                    hematicEntity.voidRageTeleport();
                    break;
                }
                case "void_rage_vortex": {
                    if (!hematicEntity.isVoidRage()) break;
                    hematicEntity.voidRageVortex();
                    break;
                }
                case "void_rage_explosion": {
                    if (!hematicEntity.isVoidRage()) break;
                    hematicEntity.voidRageExplosion();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

