/*
 * Decompiled with CFR 0.152.
 */
package s22.new_mod.entity.client;

import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import s22.new_mod.entity.custom.HematicSerenityEntity;

public class HematicSerenityModel<T extends HematicSerenityEntity>
extends class_5597<T> {
    private final class_630 root;
    private final class_630 head;
    private final class_630 body0;
    private final class_630 body1;
    private final class_630 leg0;
    private final class_630 leg1;
    private final class_630 leg2;
    private final class_630 leg3;
    private final class_630 leg4;
    private final class_630 leg5;
    private final class_630 leg6;
    private final class_630 leg7;

    public HematicSerenityModel(class_630 root) {
        this.root = root;
        this.head = root.method_32086("head");
        this.body0 = root.method_32086("body0");
        this.body1 = root.method_32086("body1");
        this.leg0 = root.method_32086("leg0");
        this.leg1 = root.method_32086("leg1");
        this.leg2 = root.method_32086("leg2");
        this.leg3 = root.method_32086("leg3");
        this.leg4 = root.method_32086("leg4");
        this.leg5 = root.method_32086("leg5");
        this.leg6 = root.method_32086("leg6");
        this.leg7 = root.method_32086("leg7");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 head = modelPartData.method_32117("head", class_5606.method_32108().method_32101(12, 4).method_32098(-4.0f, -5.6f, -8.0f, 8.0f, 8.0f, 8.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)15.0f, (float)-3.0f));
        class_5610 body0 = modelPartData.method_32117("body0", class_5606.method_32108().method_32101(37, 8).method_32098(-3.0f, -4.6f, -3.0f, 6.0f, 6.0f, 6.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)15.0f, (float)0.0f));
        class_5610 leg6_r1 = body0.method_32117("leg6_r1", class_5606.method_32108().method_32101(39, 21).method_32098(-13.0f, -7.5858f, -3.0f, 11.0f, 1.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32091((float)-1.0f, (float)6.4f, (float)18.0f, (float)0.0f, (float)-1.4835f, (float)0.3491f));
        class_5610 leg6_r2 = body0.method_32117("leg6_r2", class_5606.method_32108().method_32101(39, 21).method_32098(-13.0f, -7.5858f, -3.0f, 11.0f, 1.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32091((float)6.0f, (float)6.4f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        class_5610 leg6_r3 = body0.method_32117("leg6_r3", class_5606.method_32108().method_32101(41, 21).method_32098(-11.0f, -7.5858f, -3.0f, 9.0f, 1.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32091((float)3.0f, (float)4.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        class_5610 cube_r1 = body0.method_32117("cube_r1", class_5606.method_32108().method_32101(44, 13).method_32098(0.0f, -5.0f, -1.0f, 1.0f, 5.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32091((float)-6.0f, (float)-8.6f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        class_5610 cube_r2 = body0.method_32117("cube_r2", class_5606.method_32108().method_32101(44, 15).method_32098(0.0f, -5.0f, -1.0f, 1.0f, 5.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32091((float)7.0f, (float)-8.6f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        class_5610 cube_r3 = body0.method_32117("cube_r3", class_5606.method_32108().method_32101(37, 8).method_32098(-2.0f, -8.0f, -1.0f, 3.0f, 8.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)5.0f, (float)-2.6f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        class_5610 cube_r4 = body0.method_32117("cube_r4", class_5606.method_32108().method_32101(42, 7).method_32098(-2.0f, -8.0f, -1.0f, 3.0f, 8.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)-3.0f, (float)-2.6f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        class_5610 cube_r5 = body0.method_32117("cube_r5", class_5606.method_32108().method_32101(25, 12).method_32098(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)-9.6f, (float)15.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        class_5610 cube_r6 = body0.method_32117("cube_r6", class_5606.method_32108().method_32101(41, 10).method_32098(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)-5.6f, (float)12.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        class_5610 body1 = modelPartData.method_32117("body1", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)15.0f, (float)9.0f));
        class_5610 body1_r1 = body1.method_32117("body1_r1", class_5606.method_32108().method_32101(12, 3).method_32098(-5.0f, -20.0f, 3.0f, 10.0f, 8.0f, 12.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)14.4f, (float)-9.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        class_5610 leg0 = modelPartData.method_32117("leg0", class_5606.method_32108().method_32101(19, 8).method_32098(-12.5f, 0.1213f, -1.5f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)-4.0f, (float)15.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)-0.7854f));
        class_5610 leg1 = modelPartData.method_32117("leg1", class_5606.method_32108().method_32101(20, 11).method_32098(1.0f, -0.5858f, 0.0f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)4.0f, (float)15.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.7854f));
        class_5610 leg2 = modelPartData.method_32117("leg2", class_5606.method_32108().method_32101(27, 13).method_32098(-12.3168f, 0.2119f, -1.0849f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)-4.0f, (float)15.0f, (float)1.0f, (float)0.0f, (float)0.2618f, (float)-0.6109f));
        class_5610 leg3 = modelPartData.method_32117("leg3", class_5606.method_32108().method_32101(28, 13).method_32098(0.4175f, -0.8528f, -0.576f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)4.0f, (float)15.0f, (float)1.0f, (float)0.0f, (float)-0.2618f, (float)0.6109f));
        class_5610 leg4 = modelPartData.method_32117("leg4", class_5606.method_32108().method_32101(24, 10).method_32098(-12.3168f, 0.2119f, -0.9151f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)-4.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.6109f));
        class_5610 leg5 = modelPartData.method_32117("leg5", class_5606.method_32108().method_32101(14, 20).method_32098(0.4175f, -0.8528f, -1.424f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)4.0f, (float)15.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.6109f));
        class_5610 leg6 = modelPartData.method_32117("leg6", class_5606.method_32108().method_32101(27, 13).method_32098(-12.5f, 0.1213f, -0.5f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)-4.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)-0.7854f));
        class_5610 leg7 = modelPartData.method_32117("leg7", class_5606.method_32108().method_32101(23, 10).method_32098(1.0f, -0.5858f, -2.0f, 13.0f, 3.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32091((float)4.0f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.7854f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)32);
    }

    public void setAngles(HematicSerenityEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root.method_32088().forEach(class_630::method_41923);
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.handleAnimations(entity, limbAngle, limbDistance, animationProgress);
    }

    private void handleAnimations(HematicSerenityEntity entity, float limbAngle, float limbDistance, float animationProgress) {
        class_630 cube_r1 = this.body0.method_32086("cube_r1");
        class_630 cube_r2 = this.body0.method_32086("cube_r2");
        class_630 cube_r3 = this.body0.method_32086("cube_r3");
        class_630 cube_r4 = this.body0.method_32086("cube_r4");
        class_630 cube_r5 = this.body0.method_32086("cube_r5");
        class_630 cube_r6 = this.body0.method_32086("cube_r6");
        if (!entity.isCastingSkill() && limbDistance < 0.1f) {
            this.applyIdleAnimation(animationProgress, cube_r1, cube_r3, cube_r5);
        }
        if (limbDistance > 0.1f && !entity.isCastingSkill()) {
            this.applyWalkAnimation(limbAngle, limbDistance);
        }
        if (entity.isCastingSkill()) {
            this.applySkillAnimation(entity.getCurrentSkill(), entity.getSkillAnimationTicks(), cube_r1, cube_r2, cube_r3, cube_r4, cube_r5, cube_r6);
        }
        if (entity.isVoidRage()) {
            this.applyVoidRageAnimation(animationProgress, cube_r1, cube_r3, cube_r5);
        }
    }

    private void applyVoidRageAnimation(float progress, class_630 cube_r1, class_630 cube_r3, class_630 cube_r5) {
        float intensity = (float)Math.sin(progress * 0.3f) * 0.3f;
        this.head.field_3656 = 15.0f + intensity;
        this.body0.field_3656 = 15.0f + intensity;
        this.body1.field_3656 = 15.0f + intensity;
        if (cube_r1 != null) {
            cube_r1.field_3654 = -intensity * 5.0f;
        }
        if (cube_r3 != null) {
            cube_r3.field_3675 = -intensity * 3.0f;
        }
        if (cube_r5 != null) {
            cube_r5.field_3675 = intensity * 3.0f;
        }
    }

    private void applyWalkAnimation(float limbAngle, float limbDistance) {
        float bodySway;
        float speed = limbDistance * 2.0f;
        class_630[] legs = new class_630[]{this.leg0, this.leg1, this.leg2, this.leg3, this.leg4, this.leg5, this.leg6, this.leg7};
        for (int i = 0; i < legs.length; ++i) {
            float rotation;
            float phase = i % 2 == 0 ? 0.0f : (float)Math.PI;
            legs[i].field_3654 = rotation = (float)Math.sin(limbAngle * speed + phase) * limbDistance * 0.3f;
        }
        this.body0.field_3674 = bodySway = (float)Math.sin(limbAngle * speed) * limbDistance * 0.1f;
        this.body1.field_3674 = bodySway;
    }

    private void applySkillAnimation(int skillType, int ticks, class_630 cube_r1, class_630 cube_r2, class_630 cube_r3, class_630 cube_r4, class_630 cube_r5, class_630 cube_r6) {
        float progress = (float)ticks / 20.0f;
        switch (skillType) {
            case 1: {
                this.applyVoidNovaAnimation(progress, cube_r1, cube_r2, cube_r3, cube_r4, cube_r5);
                break;
            }
            case 2: {
                this.applyTentacleLashAnimation(progress, cube_r3, cube_r4);
                break;
            }
            case 3: {
                this.applyCosmicPoolAnimation(progress, cube_r1, cube_r3, cube_r5);
                break;
            }
            case 4: {
                this.applyEldritchGazeAnimation(progress, cube_r1, cube_r3, cube_r5);
                break;
            }
            case 5: {
                this.applyRitualAnimation(progress, cube_r1, cube_r2, cube_r3, cube_r4, cube_r5, cube_r6);
                break;
            }
            case 6: {
                this.applyVoidGazeAnimation(progress, cube_r1, cube_r3, cube_r5);
            }
        }
    }

    private void applyVoidGazeAnimation(float progress, class_630 cube_r1, class_630 cube_r3, class_630 cube_r5) {
        if (progress < 0.33f) {
            float ascendProgress = progress / 0.33f;
            this.head.field_3656 = 15.0f + ascendProgress * 8.0f;
            this.body0.field_3656 = 15.0f + ascendProgress * 8.0f;
            this.body1.field_3656 = 15.0f + ascendProgress * 8.0f;
            this.head.field_3654 = -ascendProgress * 0.3f;
        } else {
            float shake;
            float beamProgress = (progress - 0.33f) / 0.67f;
            this.body0.field_3674 = shake = (float)Math.sin(beamProgress * 20.0f) * 0.1f;
            this.head.field_3675 = shake * 0.5f;
            if (cube_r1 != null) {
                cube_r1.field_3654 = -beamProgress * 0.5f;
            }
            if (cube_r3 != null) {
                cube_r3.field_3654 = -beamProgress * 0.4f;
            }
            if (cube_r5 != null) {
                cube_r5.field_3654 = -beamProgress * 0.6f;
            }
        }
        for (int i = 0; i < 8; ++i) {
            class_630 leg = this.getLeg(i);
            leg.field_3654 = progress * 0.4f;
        }
    }

    private void applyVoidNovaAnimation(float progress, class_630 cube_r1, class_630 cube_r2, class_630 cube_r3, class_630 cube_r4, class_630 cube_r5) {
        float spikeRotation = Math.min(progress * 90.0f, 90.0f);
        if (cube_r1 != null) {
            cube_r1.field_3654 = -spikeRotation * ((float)Math.PI / 180);
        }
        if (cube_r2 != null) {
            cube_r2.field_3654 = -spikeRotation * 1.2f * ((float)Math.PI / 180);
        }
        if (cube_r5 != null) {
            cube_r5.field_3654 = -spikeRotation * 0.8f * ((float)Math.PI / 180);
        }
        this.body0.field_3656 = Math.min(progress * 1.0f, 1.0f);
        this.body1.field_3656 = Math.min(progress * 1.0f, 1.0f);
    }

    private void applyTentacleLashAnimation(float progress, class_630 cube_r3, class_630 cube_r4) {
        float lashProgress = Math.min(progress * 3.0f, 1.0f);
        if (cube_r3 != null) {
            cube_r3.field_3675 = -lashProgress * 45.0f * ((float)Math.PI / 180);
        }
        if (cube_r4 != null) {
            cube_r4.field_3675 = -lashProgress * 60.0f * ((float)Math.PI / 180);
        }
        this.leg2.field_3654 = -lashProgress * 0.5f;
        this.leg3.field_3654 = -lashProgress * 0.5f;
    }

    private void applyCosmicPoolAnimation(float progress, class_630 cube_r1, class_630 cube_r3, class_630 cube_r5) {
        float rotation = progress % 1.0f * 360.0f;
        if (cube_r1 != null) {
            cube_r1.field_3675 = rotation * ((float)Math.PI / 180);
        }
        if (cube_r3 != null) {
            cube_r3.field_3675 = (rotation + 120.0f) * ((float)Math.PI / 180);
        }
        if (cube_r5 != null) {
            cube_r5.field_3675 = (rotation + 240.0f) * ((float)Math.PI / 180);
        }
        this.body0.field_3656 = -Math.min(progress * 0.5f, 0.5f);
        this.body1.field_3656 = -Math.min(progress * 0.5f, 0.5f);
        for (int i = 0; i < 8; ++i) {
            class_630 leg = this.getLeg(i);
            leg.field_3654 = 0.2f;
            leg.field_3674 = i % 2 == 0 ? 0.1f : -0.1f;
        }
    }

    private void applyEldritchGazeAnimation(float progress, class_630 cube_r1, class_630 cube_r3, class_630 cube_r5) {
        this.head.field_3654 = Math.min(progress * 20.0f, 20.0f) * ((float)Math.PI / 180);
        this.body0.field_3654 = Math.min(progress * 15.0f, 15.0f) * ((float)Math.PI / 180);
        this.body1.field_3654 = Math.min(progress * 15.0f, 15.0f) * ((float)Math.PI / 180);
        float focus = Math.min(progress * 30.0f, 30.0f);
        if (cube_r1 != null) {
            cube_r1.field_3654 = -focus * ((float)Math.PI / 180);
        }
        if (cube_r3 != null) {
            cube_r3.field_3654 = -focus * 0.8f * ((float)Math.PI / 180);
        }
        if (cube_r5 != null) {
            cube_r5.field_3654 = -focus * 0.8f * ((float)Math.PI / 180);
        }
    }

    private void applyRitualAnimation(float progress, class_630 cube_r1, class_630 cube_r2, class_630 cube_r3, class_630 cube_r4, class_630 cube_r5, class_630 cube_r6) {
        this.body0.field_3656 = Math.min(progress * 2.0f, 2.0f);
        this.body1.field_3656 = Math.min(progress * 2.0f, 2.0f);
        float spikeRotation = Math.min(progress * 60.0f, 60.0f);
        if (cube_r1 != null) {
            cube_r1.field_3654 = -spikeRotation * ((float)Math.PI / 180);
        }
        if (cube_r2 != null) {
            cube_r2.field_3654 = -spikeRotation * 1.5f * ((float)Math.PI / 180);
        }
        if (cube_r3 != null) {
            cube_r3.field_3675 = -spikeRotation * ((float)Math.PI / 180);
        }
        if (cube_r4 != null) {
            cube_r4.field_3675 = -spikeRotation * 1.5f * ((float)Math.PI / 180);
        }
        if (cube_r5 != null) {
            cube_r5.field_3675 = spikeRotation * ((float)Math.PI / 180);
        }
        if (cube_r6 != null) {
            cube_r6.field_3675 = spikeRotation * 1.5f * ((float)Math.PI / 180);
        }
        for (int i = 0; i < 8; ++i) {
            class_630 leg = this.getLeg(i);
            leg.field_3654 = (float)Math.sin(progress * 5.0f + (float)i) * 0.1f;
        }
    }

    private void applyIdleAnimation(float progress, class_630 cube_r1, class_630 cube_r3, class_630 cube_r5) {
        float floatAmount = (float)Math.sin(progress * 0.05f) * 0.1f;
        this.head.field_3656 = 15.0f + floatAmount;
        this.body0.field_3656 = 15.0f + floatAmount;
        this.body1.field_3656 = 15.0f + floatAmount;
        float spikeFloat = (float)Math.sin(progress * 0.08f) * 0.05f;
        if (cube_r1 != null) {
            cube_r1.field_3654 = spikeFloat;
        }
        if (cube_r3 != null) {
            cube_r3.field_3654 = spikeFloat;
        }
        if (cube_r5 != null) {
            cube_r5.field_3654 = spikeFloat;
        }
    }

    private class_630 getLeg(int index) {
        switch (index) {
            case 0: {
                return this.leg0;
            }
            case 1: {
                return this.leg1;
            }
            case 2: {
                return this.leg2;
            }
            case 3: {
                return this.leg3;
            }
            case 4: {
                return this.leg4;
            }
            case 5: {
                return this.leg5;
            }
            case 6: {
                return this.leg6;
            }
            case 7: {
                return this.leg7;
            }
        }
        return this.leg0;
    }

    public void render(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.root.method_22698(matrices, vertexConsumer, light, overlay);
    }

    public class_630 method_32008() {
        return this.root;
    }
}

